/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io.broker;

import com.mathworks.toolbox.distcomp.pmode.io.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerErrorCode;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerException;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerMessage;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerPeerSessionFactory;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectPortReply;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectPortRequest;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectReadyToAcceptMessage;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredSocketConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.Log;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerActiveAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingRuntimeException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.util.concurrent.SignalingAtomicBoolean;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class BrokeredConnector
implements MessageObserver {
    private static final AtomicLong SEQUENCE_NUMBER_SOURCE = new AtomicLong(0L);
    private final MatlabPoolPeerInstance fLocalPeer;
    private final String fLogId;
    private final Map<UUID, EasyFuture<BrokeredConnectPortReply>> fGroupUuidsToPortReplies = new ConcurrentHashMap<UUID, EasyFuture<BrokeredConnectPortReply>>();

    public BrokeredConnector(MatlabPoolPeerInstance matlabPoolPeerInstance) {
        this.fLocalPeer = matlabPoolPeerInstance;
        this.fLogId = this.getClass().getSimpleName() + " for " + matlabPoolPeerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection activelyConnectTo(BrokeredSocketConnectInfo brokeredSocketConnectInfo, String string) throws InterruptedException, PeerMessagingException {
        Log.LOGGER.finest(this.fLogId + " started activelyConnectTo " + brokeredSocketConnectInfo + " from " + string + " " + this.fLocalPeer);
        PeerInstance peerInstance = BrokerPeerSessionFactory.createPeerOfBroker(brokeredSocketConnectInfo.getBrokerClientInfo());
        Log.LOGGER.fine(this.fLogId + " is " + peerInstance);
        Connection connection = BrokerPeerSessionFactory.createConnectionToBroker(peerInstance, brokeredSocketConnectInfo.getBrokerClientInfo(), this.fLogId);
        PeerSession peerSession = BrokerPeerSessionFactory.createPeerSessionWithBroker(peerInstance, connection, this.fLogId);
        Log.LOGGER.finest(this.fLogId + " started PeerSession with broker on " + string + " for " + this.fLocalPeer);
        try {
            BrokeredConnectPortReply brokeredConnectPortReply = this.requestPortFromBroker(brokeredSocketConnectInfo, string, connection, peerSession);
            ServerSocketAcceptInfo serverSocketAcceptInfo = brokeredSocketConnectInfo.getBrokeredConnectorAcceptInfo();
            ServerSocketAcceptInfo serverSocketAcceptInfo2 = serverSocketAcceptInfo.createWithNewPortOffsetAndStep(brokeredConnectPortReply.getPortOffset(), brokeredConnectPortReply.getPortStepsize());
            Connection connection2 = this.sendConnectinfoToBrokerAndConnect(brokeredSocketConnectInfo, string, connection, peerSession, serverSocketAcceptInfo2);
            return connection2;
        }
        finally {
            peerSession.normalShutdown();
            Log.LOGGER.finer(this.fLogId + " Shut down PeerSession " + peerSession + " from " + string + " for " + this.fLocalPeer);
        }
    }

    private BrokeredConnectPortReply requestPortFromBroker(BrokeredSocketConnectInfo brokeredSocketConnectInfo, String string, Connection connection, PeerSession peerSession) throws InterruptedException, NoPortFromBrokerException {
        BrokeredConnectPortRequest brokeredConnectPortRequest = new BrokeredConnectPortRequest(brokeredSocketConnectInfo.getGroupUUID(), string, this.fLocalPeer.getNumberOfLabs(), SEQUENCE_NUMBER_SOURCE.getAndIncrement());
        EasyFuture easyFuture = new EasyFuture();
        this.fGroupUuidsToPortReplies.put(brokeredSocketConnectInfo.getGroupUUID(), easyFuture);
        peerSession.getOutputGroup().sendTo(connection.getRemoteInstance(), brokeredConnectPortRequest, this);
        Log.LOGGER.finest(this.fLogId + " sent " + brokeredConnectPortRequest + " to broker");
        try {
            BrokeredConnectPortReply brokeredConnectPortReply = (BrokeredConnectPortReply)easyFuture.get(brokeredSocketConnectInfo.getHandShakeTimeout(), TimeUnit.MILLISECONDS);
            Log.LOGGER.finest(this.fLogId + " got " + brokeredConnectPortReply + " from broker");
            BrokeredConnectPortReply brokeredConnectPortReply2 = brokeredConnectPortReply;
            return brokeredConnectPortReply2;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new PeerMessagingRuntimeException("Unexpected exception when " + this.fLocalPeer + " on " + string + " requested a port from the broker at " + connection.getLogString(), executionException);
        }
        catch (TimeoutException timeoutException) {
            throw new NoPortFromBrokerException(string, this.fLocalPeer, brokeredSocketConnectInfo, timeoutException);
        }
        finally {
            this.fGroupUuidsToPortReplies.remove(brokeredSocketConnectInfo.getGroupUUID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection sendConnectinfoToBrokerAndConnect(BrokeredSocketConnectInfo brokeredSocketConnectInfo, String string, Connection connection, PeerSession peerSession, ServerSocketAcceptInfo serverSocketAcceptInfo) throws PeerMessagingException {
        PeerActiveAcceptor peerActiveAcceptor = new PeerActiveAcceptor(string, this.fLocalPeer, serverSocketAcceptInfo);
        Log.LOGGER.finest(this.fLogId + " created peerActiveAcceptor on " + string + " for " + this.fLocalPeer);
        try {
            this.sendConnectInfoToBroker(string, this.fLocalPeer, this.fLogId, peerActiveAcceptor, connection, peerSession);
            Connection connection2 = peerActiveAcceptor.activelyAccept(brokeredSocketConnectInfo.getBrokeredConnectAcceptorInterval(), brokeredSocketConnectInfo.getBrokeredConnectAcceptorTimeout());
            if (null == connection2) {
                Log.LOGGER.fine(this.fLogId + "Failed to connect using " + brokeredSocketConnectInfo + " from " + peerActiveAcceptor.getInfoToConnect().getSocketAddress() + " after polling accept for " + brokeredSocketConnectInfo.getBrokeredConnectAcceptorTimeout() + " ms");
                throw new PeerFailedToConnectException(string, this.fLocalPeer, brokeredSocketConnectInfo);
            }
            Log.LOGGER.fine(this.fLogId + " Connected to " + connection2 + " from " + string + " for " + this.fLocalPeer);
            Connection connection3 = connection2;
            return connection3;
        }
        finally {
            peerActiveAcceptor.close();
        }
    }

    private void sendConnectInfoToBroker(String string, MatlabPoolPeerInstance matlabPoolPeerInstance, String string2, PeerActiveAcceptor peerActiveAcceptor, Connection connection, PeerSession peerSession) {
        BrokeredConnectReadyToAcceptMessage brokeredConnectReadyToAcceptMessage = new BrokeredConnectReadyToAcceptMessage(peerActiveAcceptor.getInfoToConnect(), matlabPoolPeerInstance.getNumberOfLabs());
        peerSession.getOutputGroup().sendTo(connection.getRemoteInstance(), brokeredConnectReadyToAcceptMessage);
        Log.LOGGER.finer(string2 + " Sent " + brokeredConnectReadyToAcceptMessage + " to broker from " + string + " for " + matlabPoolPeerInstance);
    }

    @Override
    public void completed(ReturnMessage returnMessage, Instance instance) {
        EasyFuture<BrokeredConnectPortReply> easyFuture;
        Object object;
        Log.LOGGER.finer(this.fLogId + " received " + returnMessage + " from " + instance);
        if (returnMessage instanceof BrokerMessage) {
            object = (BrokerMessage)((Object)returnMessage);
            if (!object.getGroupUuid().equals(this.fLocalPeer.getGroupUuid())) {
                easyFuture = this.fLogId + ": Got reply for the wrong group. Expected " + this.fLocalPeer.getGroupUuid() + " got " + object.getGroupUuid();
                assert (object.getGroupUuid().equals(this.fLocalPeer.getGroupUuid())) : easyFuture;
                Log.LOGGER.warning((String)((Object)easyFuture));
            }
        } else {
            object = this.fLogId + " Expected " + returnMessage + " to be a " + BrokerMessage.class.getSimpleName() + " but it is a " + returnMessage.getClass();
            assert (false) : object;
            Log.LOGGER.warning((String)object);
        }
        if (returnMessage instanceof BrokeredConnectPortReply) {
            object = (BrokeredConnectPortReply)returnMessage;
            easyFuture = this.fGroupUuidsToPortReplies.get(((BrokeredConnectPortReply)object).getGroupUuid());
            if (easyFuture == null) {
                String string = this.fLogId + ": Reply is from an unexpected group. Expected " + this.fLocalPeer.getGroupUuid() + " got " + ((BrokeredConnectPortReply)object).getGroupUuid();
                assert (((BrokeredConnectPortReply)object).getGroupUuid().equals(this.fLocalPeer.getGroupUuid())) : string;
                Log.LOGGER.warning(string);
            } else {
                easyFuture.set((BrokeredConnectPortReply)object);
                Log.LOGGER.finest(this.fLogId + " completed for ");
            }
        } else {
            Log.LOGGER.severe(this.fLogId + " Unknown message type: " + returnMessage.getClass());
            throw new UnsupportedOperationException(this.fLogId + " Unknown message type: " + returnMessage.getClass());
        }
    }

    public static final class NoPortFromBrokerException
    extends BrokeredConnectorException {
        private final String fLocalhost;
        private final MatlabPoolPeerInstance fLocalPeer;
        private final BrokeredSocketConnectInfo fBrokeredSocketConnectInfo;

        private NoPortFromBrokerException(String string, MatlabPoolPeerInstance matlabPoolPeerInstance, BrokeredSocketConnectInfo brokeredSocketConnectInfo, TimeoutException timeoutException) {
            super(BrokerErrorCode.NoPortFromBroker, (Exception)timeoutException);
            this.fLocalhost = string;
            this.fLocalPeer = matlabPoolPeerInstance;
            this.fBrokeredSocketConnectInfo = brokeredSocketConnectInfo;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fLocalhost, this.fLocalPeer, this.fBrokeredSocketConnectInfo.getBrokerClientInfo().getConnectToBrokerInfo().getSocketAddress(), this.fBrokeredSocketConnectInfo.getHandShakeTimeout()};
        }
    }

    public static final class PeerFailedToConnectException
    extends BrokeredConnectorException {
        private final String fLocalhost;
        private final MatlabPoolPeerInstance fLocalPeer;
        private final BrokeredSocketConnectInfo fBrokeredSocketConnectInfo;

        private PeerFailedToConnectException(String string, MatlabPoolPeerInstance matlabPoolPeerInstance, BrokeredSocketConnectInfo brokeredSocketConnectInfo) {
            super(BrokerErrorCode.BrokeredPeerFailedToConnect);
            this.fLocalhost = string;
            this.fLocalPeer = matlabPoolPeerInstance;
            this.fBrokeredSocketConnectInfo = brokeredSocketConnectInfo;
        }

        @Override
        protected Object[] getMessageArguments() {
            return new Object[]{this.fLocalhost, this.fLocalPeer, this.fBrokeredSocketConnectInfo.getBrokerClientInfo().getConnectToBrokerInfo().getSocketAddress(), this.fBrokeredSocketConnectInfo.getBrokeredConnectAcceptorTimeout()};
        }
    }

    private static abstract class BrokeredConnectorException
    extends BrokerException {
        protected BrokeredConnectorException(BrokerErrorCode brokerErrorCode) {
            super(brokerErrorCode);
        }

        protected BrokeredConnectorException(BrokerErrorCode brokerErrorCode, Exception exception) {
            super(brokerErrorCode, exception);
        }
    }

    private static final class EasyFuture<Value>
    implements Future<Value> {
        private final SignalingAtomicBoolean fIsDoneOrCancelled = new SignalingAtomicBoolean(false);
        private final AtomicBoolean fIsDone = new AtomicBoolean(false);
        private final AtomicBoolean fIsCancelled = new AtomicBoolean(false);
        private final AtomicReference<Value> fResult = new AtomicReference();
        private final AtomicReference<Throwable> fThrowable = new AtomicReference();

        private EasyFuture() {
        }

        @Override
        public boolean cancel(boolean bl) {
            this.fIsCancelled.set(true);
            this.fIsDoneOrCancelled.set(true);
            return !this.fIsDone.get();
        }

        @Override
        public boolean isCancelled() {
            return this.fIsCancelled.get();
        }

        @Override
        public boolean isDone() {
            return this.fIsDone.get();
        }

        private Value throwOrGet() throws ExecutionException {
            Throwable throwable = this.fThrowable.get();
            if (throwable != null) {
                throw new ExecutionException(throwable);
            }
            return this.fResult.get();
        }

        @Override
        public Value get() throws InterruptedException, ExecutionException {
            this.fIsDoneOrCancelled.awaitTrue();
            return this.throwOrGet();
        }

        @Override
        public Value get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.fIsDoneOrCancelled.awaitTrue(l, timeUnit)) {
                throw new TimeoutException("Timed out after " + l + " " + (Object)((Object)timeUnit));
            }
            return this.throwOrGet();
        }

        public void done() {
            this.fIsDone.set(true);
            this.fIsDoneOrCancelled.set(true);
        }

        public void set(Value Value) {
            this.fResult.set(Value);
            this.done();
        }

        public void setException(Throwable throwable) {
            this.fThrowable.set(throwable);
            this.done();
        }
    }
}

