/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.CredentialDescription;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterNotAllowedException;
import com.mathworks.toolbox.distcomp.remote.RequiredParameterMissingException;
import java.util.Set;

public class CredentialParameter
extends ParameterImpl<Credential> {
    private final Set<CredentialDescription> fPossibleCredentialDescriptions;
    private final CredentialDescription fDefaultCredentialDescription;

    public CredentialParameter(Parameter.PersistentKey persistentKey, Set<CredentialDescription> set, CredentialDescription credentialDescription) {
        super(persistentKey, true, Credential.class);
        this.fPossibleCredentialDescriptions = set;
        this.fDefaultCredentialDescription = credentialDescription;
    }

    public Set<CredentialDescription> getPossibleCredentialDescriptions() {
        return this.fPossibleCredentialDescriptions;
    }

    public CredentialDescription getDefaultCredentialDescription() {
        return this.fDefaultCredentialDescription;
    }

    @Override
    public void checkValueImpl(Credential credential) throws InvalidValueException {
        if (!this.fPossibleCredentialDescriptions.contains(credential.getCredentialDescription())) assert (false) : "The credential parameter " + credential + " contains an incorrect credential description. The credential description is " + credential.getCredentialDescription();
        try {
            credential.getParameterMap().checkParameters(credential.getCredentialDescription().getParameterSet());
        }
        catch (ParameterNotAllowedException parameterNotAllowedException) {
            throw new InvalidValueException(this, parameterNotAllowedException.getMessage());
        }
        catch (RequiredParameterMissingException requiredParameterMissingException) {
            throw new InvalidValueException(this, requiredParameterMissingException.getMessage());
        }
    }

    @Override
    protected String getSimpleName() {
        return CredentialParameter.class.getSimpleName();
    }
}

