/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.Logger;
import java.util.Map;
import java.util.Set;

public interface ListFileAttributesFuture
extends Future {
    public Map<String, FileAttributes> getFileAttributes() throws InterruptedException, FulfillmentException;

    public Set<String> getMissingFileNames() throws InterruptedException, FulfillmentException;

    public static final class FileAttributes {
        private final String fPath;
        private final long fSize;
        private final long fModificationTime;
        private final boolean fIsDir;
        private final String fInfoHostname;

        public FileAttributes(String string, long l, long l2, boolean bl, String string2) {
            this.fPath = string;
            this.fSize = l;
            this.fModificationTime = l2;
            this.fIsDir = bl;
            this.fInfoHostname = string2;
        }

        public String getPath() {
            return this.fPath;
        }

        public long getSize() {
            return this.fSize;
        }

        public long getModificationTime() {
            return this.fModificationTime;
        }

        public boolean isDir() {
            return this.fIsDir;
        }

        public String getInfoHostname() {
            return this.fInfoHostname;
        }

        public boolean differentFileAttributes(FileAttributes fileAttributes) {
            if (!this.getPath().equals(fileAttributes.getPath())) {
                Logger.LOGGER.finest("FileAttributes differ " + this.toString() + " " + fileAttributes + " by path");
                return true;
            }
            if (this.isDir() != fileAttributes.isDir()) {
                Logger.LOGGER.finest("FileAttributes differ " + this.toString() + " " + fileAttributes + " by dir");
                return true;
            }
            if (!this.isDir()) {
                if (this.fSize != fileAttributes.getSize()) {
                    Logger.LOGGER.finest("FileAttributes differ " + this.toString() + " " + fileAttributes + " by size");
                    return true;
                }
                if (this.getInfoHostname().equals(fileAttributes.getInfoHostname()) && this.getModificationTime() != fileAttributes.getModificationTime()) {
                    Logger.LOGGER.finest("FileAttributes differ " + this.toString() + " " + fileAttributes + " by modification time");
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.getInfoHostname() + ":" + this.getPath() + "\t" + this.getSize() + "\t" + this.getModificationTime();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof FileAttributes) {
                FileAttributes fileAttributes = (FileAttributes)object;
                return this.isDir() == fileAttributes.isDir() && this.getPath().equals(fileAttributes.getPath()) && this.getSize() == fileAttributes.getSize() && this.getModificationTime() == fileAttributes.getModificationTime() && this.getInfoHostname().equals(fileAttributes.getInfoHostname());
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.isDir() ? 0L : 107L + (101L * this.getSize() + 103L * this.getModificationTime() + (long)(109 * this.getPath().hashCode()) + (long)(113 * this.getInfoHostname().hashCode())) % Integer.MIN_VALUE);
        }
    }
}

