/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi;

import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.spi.HostParameterKey;
import com.mathworks.toolbox.distcomp.remote.spi.LeasableConnection;
import com.mathworks.toolbox.distcomp.remote.spi.Lease;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseMonitor;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseMonitorFactory;
import com.mathworks.toolbox.distcomp.remote.util.DaemonThreadFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class LeaseSource<T extends LeasableConnection> {
    private final Lock fLock = new ReentrantLock();
    private final Map<HostParameterKey, LeaseMonitor<T>> fHostsToLeaseMonitors = new HashMap<HostParameterKey, LeaseMonitor<T>>();
    private final Map<LeaseMonitor<T>, FutureTask<Object>> fLeaseMonitorsToDisconnectors = new HashMap<LeaseMonitor<T>, FutureTask<Object>>();
    private final ScheduledThreadPoolExecutor fDisconnectorExecutor;
    private final LeaseMonitorFactory<T> fLeaseMonitorFactory;

    public LeaseSource(LeaseMonitorFactory<T> leaseMonitorFactory) {
        this.fLeaseMonitorFactory = leaseMonitorFactory;
        this.fDisconnectorExecutor = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory(this.getClass().getSimpleName() + " fDisconnectorExecutor"));
        this.addDisconnectorShutdownHook();
    }

    public LeaseSource(LeaseMonitorFactory<T> leaseMonitorFactory, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        this.fLeaseMonitorFactory = leaseMonitorFactory;
        this.fDisconnectorExecutor = scheduledThreadPoolExecutor;
        this.addDisconnectorShutdownHook();
    }

    private Thread addDisconnectorShutdownHook() {
        String string = "LeaseSourceDisconnectorShutdownHook";
        Thread thread = new Thread(string){

            @Override
            public void run() {
                Collection collection = LeaseSource.this.getLeaseMonitors();
                for (LeaseMonitor leaseMonitor : collection) {
                    if (!leaseMonitor.isConnected()) continue;
                    leaseMonitor.disconnectWithNoRelease();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<LeaseMonitor<T>> getLeaseMonitors() {
        try {
            HashSet<LeaseMonitor<T>> hashSet;
            this.fLock.lock();
            HashSet<LeaseMonitor<T>> hashSet2 = hashSet = new HashSet<LeaseMonitor<T>>(this.fHostsToLeaseMonitors.values());
            return hashSet2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public Lease<T> getLease(String string, ParameterMap parameterMap) throws DispatchException {
        return this.getLease(new SimpleHostParameterKey(string, parameterMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lease<T> getLease(HostParameterKey hostParameterKey) throws DispatchException {
        try {
            this.fLock.lock();
            LeaseMonitor<T> leaseMonitor = this.getLeaseMonitor(hostParameterKey);
            Lease<T> lease = leaseMonitor.claim();
            this.unscheduleDisconnector(leaseMonitor);
            Lease<T> lease2 = lease;
            return lease2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LeaseMonitor<T> getLeaseMonitor(HostParameterKey hostParameterKey) throws DispatchException {
        try {
            this.fLock.lock();
            LeaseMonitor<T> leaseMonitor = this.fHostsToLeaseMonitors.get(hostParameterKey);
            if (leaseMonitor == null || !leaseMonitor.isConnected()) {
                leaseMonitor = this.createLeaseMonitor(hostParameterKey);
            }
            LeaseMonitor<T> leaseMonitor2 = leaseMonitor;
            return leaseMonitor2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LeaseMonitor<T> createLeaseMonitor(HostParameterKey hostParameterKey) throws DispatchException {
        try {
            this.fLock.lock();
            LeaseMonitor<T> leaseMonitor = this.fLeaseMonitorFactory.newLeaseMonitor(hostParameterKey.getHostname(), hostParameterKey.getParameterMap(), this);
            this.fHostsToLeaseMonitors.put(hostParameterKey, leaseMonitor);
            this.scheduleDisconnectorIfNeeded(leaseMonitor);
            LeaseMonitor<T> leaseMonitor2 = leaseMonitor;
            return leaseMonitor2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Lease<T> lease) {
        try {
            this.fLock.lock();
            LeaseMonitor<T> leaseMonitor = lease.getLeaseMonitor();
            leaseMonitor.release(lease);
            this.scheduleDisconnectorIfNeeded(leaseMonitor);
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void ensureLeaseMonitorExists(String string, ParameterMap parameterMap) throws DispatchException {
        this.getLeaseMonitor(new SimpleHostParameterKey(string, parameterMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleDisconnectorIfNeeded(LeaseMonitor<T> leaseMonitor) {
        try {
            this.fLock.lock();
            this.unscheduleDisconnector(leaseMonitor);
            if (leaseMonitor.noLeasesOutstanding()) {
                Disconnector<T> disconnector = new Disconnector<T>(this, leaseMonitor);
                FutureTask<Object> futureTask = new FutureTask<Object>(disconnector, new Object());
                this.fLeaseMonitorsToDisconnectors.put(leaseMonitor, futureTask);
                int n = leaseMonitor.getIdleSecondsBeforeDisconnect();
                this.fDisconnectorExecutor.schedule(futureTask, (long)n, TimeUnit.SECONDS);
                Logger.LOGGER.finest("Disconnector " + futureTask + " scheduled in " + n + " seconds.");
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unscheduleDisconnector(LeaseMonitor<T> leaseMonitor) {
        try {
            this.fLock.lock();
            FutureTask<Object> futureTask = this.fLeaseMonitorsToDisconnectors.remove(leaseMonitor);
            if (futureTask != null) {
                futureTask.cancel(false);
                this.fDisconnectorExecutor.purge();
                Logger.LOGGER.finest("Disconnector " + futureTask + " unscheduled.");
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean disconnectIfSafe(LeaseMonitor<T> leaseMonitor) {
        try {
            this.fLock.lock();
            boolean bl = leaseMonitor.disconnectIfNoLeasesOutstanding();
            if (bl) {
                SimpleHostParameterKey simpleHostParameterKey = new SimpleHostParameterKey(leaseMonitor.getHostname(), leaseMonitor.getParameterMap());
                this.fHostsToLeaseMonitors.remove(simpleHostParameterKey);
                this.unscheduleDisconnector(leaseMonitor);
            }
            boolean bl2 = true;
            return bl2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    private static final class SimpleHostParameterKey
    implements HostParameterKey {
        private final String fHostname;
        private final ParameterMap fParameterMap;

        public SimpleHostParameterKey(String string, ParameterMap parameterMap) {
            this.fHostname = string;
            this.fParameterMap = parameterMap;
        }

        @Override
        public String getHostname() {
            return this.fHostname;
        }

        @Override
        public ParameterMap getParameterMap() {
            return this.fParameterMap;
        }

        public boolean equals(Object object) {
            HostParameterKey hostParameterKey;
            if (object == this) {
                return true;
            }
            return object instanceof HostParameterKey && this.fHostname.equals((hostParameterKey = (HostParameterKey)object).getHostname()) && this.fParameterMap.equals(hostParameterKey.getParameterMap());
        }

        public int hashCode() {
            return this.fHostname.hashCode() ^ this.fParameterMap.hashCode();
        }
    }

    private static final class Disconnector<T extends LeasableConnection>
    implements Runnable {
        private final LeaseSource<T> fChannelLeaseSource;
        private final LeaseMonitor<T> fSessionMonitor;

        Disconnector(LeaseSource<T> leaseSource, LeaseMonitor<T> leaseMonitor) {
            this.fChannelLeaseSource = leaseSource;
            this.fSessionMonitor = leaseMonitor;
        }

        @Override
        public void run() {
            boolean bl = this.fChannelLeaseSource.disconnectIfSafe(this.fSessionMonitor);
            if (!bl) {
                this.fChannelLeaseSource.scheduleDisconnectorIfNeeded(this.fSessionMonitor);
            }
        }
    }
}

