/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import com.mathworks.toolbox.distcomp.remote.CopyFromRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.CopyFuture;
import com.mathworks.toolbox.distcomp.remote.CopyToRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.spi.FileCopier;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchCopyFromFuture;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchCopyToFuture;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.SshParameter;

public final class JSchCopier
implements FileCopier {
    private static final String PROTOCOL_NAME = "jschcopy";
    private static final String PROTOCOL_TYPE = "scp";

    @Override
    public ParameterSet getParameterSet() {
        return SshParameter.SSH_PARAMETER_SET;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public String getProtocolType() {
        return PROTOCOL_TYPE;
    }

    @Override
    public Class<? extends Command> getCommandClass() {
        return CopyCommand.class;
    }

    @Override
    public CopyFuture copyFile(CopyCommand copyCommand, String string, ParameterMap parameterMap) throws DispatchException {
        String string2;
        if (copyCommand instanceof CopyToRemoteCommand) {
            string2 = "Copy " + copyCommand.getLocalFile() + " to " + string + ":" + copyCommand.getRemoteFile();
            if (!copyCommand.getLocalFile().exists()) {
                throw new ProtocolDispatchException(string2 + ": local file " + copyCommand.getLocalFile() + " does not exist.");
            }
        } else {
            string2 = "Copy " + string + ":" + copyCommand.getRemoteFile() + " to " + copyCommand.getLocalFile();
        }
        parameterMap.checkParameters(this.getParameterSet());
        Runnable runnable = copyCommand instanceof CopyToRemoteCommand ? JSchCopyToFuture.createJschCopyToFuture((CopyToRemoteCommand)copyCommand, string, parameterMap, string2) : JSchCopyFromFuture.createJschCopyFromFuture((CopyFromRemoteCommand)copyCommand, string, parameterMap, string2);
        Logger.LOGGER.fine(string2 + ": started");
        return runnable;
    }

    @Override
    public Future execute(Command command, String string, ParameterMap parameterMap) throws DispatchException {
        return this.copyFile((CopyCommand)command, string, parameterMap);
    }
}

