/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.toolbox.distcomp.remote.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

final class SignalingBufferedInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 16384;
    private final Lock fInLock = new ReentrantLock();
    private final Condition fInSet = this.fInLock.newCondition();
    private final Condition fDoneReadingFIn = this.fInLock.newCondition();
    private boolean fisDoneReadingFIn = false;
    private BufferedInputStream fIn;
    private final String fLogPrefix;

    SignalingBufferedInputStream(String string) {
        this.fLogPrefix = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInputStreamAndStart(InputStream inputStream) throws IOException {
        try {
            this.fInLock.lock();
            if (this.fIn != null) {
                throw new IllegalStateException("setInputStreamAndStart() can only be called once");
            }
            this.fIn = new BufferedInputStream(inputStream, 16384);
            this.signalInputStreamAvailable();
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean awaitInputStreamAvailable() throws InterruptedException {
        try {
            this.fInLock.lock();
            if (this.fIn == null) {
                Logger.LOGGER.finest(this.fLogPrefix + ": Waiting for stream");
                this.fInSet.await();
                Logger.LOGGER.finest(this.fLogPrefix + ": Finished waiting for stream " + (this.fIn != null));
            }
            boolean bl = this.isInputStreamAvailable();
            return bl;
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalInputStreamAvailable() {
        try {
            this.fInLock.lock();
            this.fInSet.signalAll();
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInputStreamAvailable() {
        try {
            this.fInLock.lock();
            boolean bl = this.fIn != null;
            return bl;
        }
        finally {
            this.fInLock.unlock();
        }
    }

    @Override
    public int read() throws IOException {
        BufferedInputStream bufferedInputStream;
        block8: {
            bufferedInputStream = null;
            try {
                this.fInLock.lock();
                if (this.awaitInputStreamAvailable()) {
                    bufferedInputStream = this.fIn;
                    break block8;
                }
                throw new IOException(this.fLogPrefix + ": fIn stream never set");
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(this.fLogPrefix + "Interrupted during read()");
            }
            finally {
                this.fInLock.unlock();
            }
        }
        assert (bufferedInputStream != null) : "localIn should have been set";
        int n = ((InputStream)bufferedInputStream).read();
        if (n == -1) {
            this.signalDoneReading();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.fInLock.lock();
            this.closeInput();
            this.signalInputStreamAvailable();
            this.signalDoneReading();
            super.close();
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInput() {
        try {
            this.fInLock.lock();
            if (this.fIn != null) {
                this.fIn.close();
            }
        }
        catch (IOException iOException) {
            Logger.LOGGER.log(Level.WARNING, this.fLogPrefix + ": exception while closing input", iOException);
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalDoneReading() {
        try {
            this.fInLock.lock();
            this.fisDoneReadingFIn = true;
            this.fDoneReadingFIn.signalAll();
        }
        finally {
            this.fInLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitReachedEndOfInput() throws InterruptedException {
        try {
            this.fInLock.lock();
            if (!this.fisDoneReadingFIn) {
                Logger.LOGGER.finest(this.fLogPrefix + ": Waiting to finish reading");
                this.fDoneReadingFIn.await();
                Logger.LOGGER.finest(this.fLogPrefix + ": Finished reading " + this.fisDoneReadingFIn);
            }
        }
        finally {
            this.fInLock.unlock();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.isInputStreamAvailable()) {
            return this.fIn.available();
        }
        Logger.LOGGER.finest(this.fLogPrefix + ": returning 0 because fIn is null");
        return 0;
    }
}

