/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.toolbox.distcomp.remote.CredentialDescription;
import com.mathworks.toolbox.distcomp.remote.CredentialParameter;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.PasswordCredentialDescription;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;

public class SshParameter<V>
extends ParameterImpl<V> {
    public static final SshParameter<Boolean> STRICT_HOST_KEY_CHECKING = new SshParameter<Boolean>((Parameter.PersistentKey)SshPersistentKey.STRICT_HOST_KEY_CHECKING, false, false, Boolean.class, false);
    public static final SshParameter<File> KNOWN_HOSTS = new SshParameter<File>((Parameter.PersistentKey)SshPersistentKey.KNOWN_HOSTS, false, false, File.class){

        @Override
        public void checkValueImpl(File file) throws InvalidValueException {
            if (file == null) {
                throw new InvalidValueException(this, "The known hosts file should not be null.");
            }
            if (!file.exists()) {
                throw new InvalidValueException(this, file, "The known hosts file does not exist.");
            }
            if (!file.isFile()) {
                throw new InvalidValueException(this, file, "The known hosts file is not a file.");
            }
        }
    };
    public static final CredentialParameter SSH_CREDENTIAL;
    public static final int MAX_PORT_NUMBER = 49151;
    public static final int MIN_PORT_NUMBER = 1;
    public static final int DEFAULT_PORT_NUMBER = 22;
    public static final Parameter<Integer> PORT;
    public static final Parameter<Integer> IDLE_SECONDS_BEFORE_DISCONNECT;
    public static final ParameterSet SSH_PARAMETER_SET;

    private SshParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz, V v) {
        super(persistentKey, bl, bl2, clazz, v);
    }

    private SshParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz) {
        super(persistentKey, bl, bl2, clazz);
    }

    @Override
    protected String getSimpleName() {
        return SshParameter.class.getSimpleName();
    }

    static {
        LinkedHashSet<CredentialDescription> linkedHashSet = new LinkedHashSet<CredentialDescription>();
        linkedHashSet.add(PasswordCredentialDescription.INSTANCE);
        linkedHashSet.add(IdentityFileCredentialDescription.INSTANCE);
        SSH_CREDENTIAL = new CredentialParameter((Parameter.PersistentKey)SshPersistentKey.SSH_CREDENTIAL, Collections.unmodifiableSet(linkedHashSet), PasswordCredentialDescription.INSTANCE);
        PORT = new SshParameter<Integer>((Parameter.PersistentKey)SshPersistentKey.PORT, false, false, Integer.class, Integer.valueOf(22)){

            @Override
            public void checkValueImpl(Integer n) throws InvalidValueException {
                if (n == null) {
                    throw new InvalidValueException(this, "The port number should not be null.");
                }
                if (n < 1 || n > 49151) {
                    throw new InvalidValueException(this, n, "The port number can be between 1 and 49151.");
                }
            }
        };
        IDLE_SECONDS_BEFORE_DISCONNECT = new SshParameter<Integer>((Parameter.PersistentKey)SshPersistentKey.IDLE_SECONDS_BEFORE_DISCONNECT, false, false, Integer.class, Integer.valueOf(300)){

            @Override
            public void checkValueImpl(Integer n) throws InvalidValueException {
                if (n == null) {
                    throw new InvalidValueException(this, "The idle seconds before disconnect should not be null.");
                }
                if (n <= 1) {
                    throw new InvalidValueException(this, n, "The idle seconds before disconnect must be greater than 0.");
                }
            }
        };
        SSH_PARAMETER_SET = new ParameterSet(SSH_CREDENTIAL, STRICT_HOST_KEY_CHECKING, KNOWN_HOSTS, PORT);
    }

    private static enum SshPersistentKey implements Parameter.PersistentKey
    {
        SSH_CREDENTIAL,
        STRICT_HOST_KEY_CHECKING,
        KNOWN_HOSTS,
        PORT,
        IDLE_SECONDS_BEFORE_DISCONNECT;

    }
}

