/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFile;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.RandomAccessFilePool;
import java.io.File;
import java.io.IOException;

public class BlobFileFactory {
    private RandomAccessFilePool fRandomAccessFilePool;

    public BlobFileFactory(int n) {
        this.fRandomAccessFilePool = new RandomAccessFilePool(n);
    }

    public BlobFile createBlobFile(File file) throws BlobFileException {
        this.createFile(file);
        return new BlobFile(file, this.fRandomAccessFilePool);
    }

    public BlobFile createBlobFile(File file, long l) throws BlobFileException {
        if (!file.exists()) {
            throw new BlobFileException("Error recreating blob file: file does not exist on disk");
        }
        return new BlobFile(file, l, this.fRandomAccessFilePool);
    }

    private void createFile(File file) throws BlobFileException {
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            throw new BlobFileException("Unable to create blob file", iOException);
        }
    }
}

