/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.jobmonitor;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.distcomp.ui.UpdateChangeListener;
import com.mathworks.toolbox.distcomp.ui.UpdateChangeSupport;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobTableRowModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;

final class JobMonitorModel {
    private String fCurrentProfile;
    private boolean fShowJobsFromAllUser = false;
    private List<String> fProfileList;
    private List<JobTableRowModel> fAllUsersJobTableRows;
    private List<JobTableRowModel> fIndividualUserJobTableRows;
    private PropertyChangeSupport fPropertyChangeSupport = new PropertyChangeSupport(this);
    public static final String CURRENT_PROFILE_CHANGED_PROPERTY = "CurrentProfileChanged";
    public static final String SHOW_JOBS_FROM_ALL_USER_CHANGED_PROPERTY = "ShowJobsFromAllUserChanged";
    public static final String PROFILE_LIST_CHANGED_PROPERTY = "ProfileListChanged";
    public static final String ALL_USERS_JOB_TABLE_ROWS_CHANGED_PROPERTY = "AllUsersJobTableRowsChanged";
    public static final String INDIVIDUAL_USER_JOB_TABLE_ROWS_CHANGED_PROPERTY = "IndividualUserTableRowsChanged";
    public static final String CANCEL_JOB_ERRORED = "CancelJobErrored";
    public static final String DELETE_JOB_ERRORED = "DeleteJobErrored";
    public static final String SHOW_JOB_DETAILS_ERRORED = "ShowJobDetailsErrored";
    public static final String SHOW_ERRORED_TASKS_ERRORED = "ShowErroredTasksErrored";
    public static final String LOAD_VARIABLES_ERRORED = "LoadVariablesErrored";
    public static final String FETCH_OUTPUTS_ERRORED = "FetchOutputsErrored";
    public static final String SHOW_DIARY_ERRORED = "ShowDiaryErrored";
    public static final String CLOSE_MATLAB_POOL_ERRORED = "CloseMATLABPoolErrored";
    public static final String REVERT_TO_DEFAULT_PROFILE = "RevertToDefaultProfile";
    public static final String MATLAB_ERROR = "MatlabError";
    public static final String UPDATE_ABORTED = "UpdateAborted";
    private UpdateChangeSupport fUpdateChangeSupport = new UpdateChangeSupport();
    private static final String JOB_MONITOR_HELPER_FCN = "parallel.internal.ui.jobMonitorHelper";
    private static final String INITIALIZE_OPTION = "initialize";
    private static final String UPDATE_OPTION = "update";
    private static final String CANCEL_JOB_OPTION = "cancelJob";
    private static final String DELETE_JOB_OPTION = "deleteJob";
    private static final String SHOW_JOB_DETAILS_OPTION = "showJobDetails";
    private static final String SHOW_ERRORED_TASKS_IN_JOB_OPTION = "showErroredTasksInJob";
    private static final String LOAD_VARIABLES_OPTION = "loadVariables";
    private static final String FETCH_OUTPUTS_OPTION = "fetchOutputs";
    private static final String SHOW_DIARY_OPTION = "showDiary";
    private static final String CLOSE_MATLAB_POOL_OPTION = "closeMATLABPool";
    private static final String MATLAB_INTERRUPTED_ERROR_MSG = "InterruptException(ctrl-c)";
    private static final String ABORT_BY_USER_ERROR_ID = "parallel:cluster:MJSUserAbortedOperation";
    private static final int NARGOUT_UPDATE_OPTION = 6;

    JobMonitorModel() {
        this.fAllUsersJobTableRows = new ArrayList<JobTableRowModel>();
        this.fIndividualUserJobTableRows = new ArrayList<JobTableRowModel>();
        this.initializeProfile();
    }

    String getCurrentProfile() {
        return this.fCurrentProfile;
    }

    void updateCurrentProfile(String string) {
        this.update(string, true);
    }

    private void setCurrentProfile(String string) {
        String string2 = this.fCurrentProfile;
        this.fCurrentProfile = string;
        this.fPropertyChangeSupport.firePropertyChange(CURRENT_PROFILE_CHANGED_PROPERTY, string2, this.fCurrentProfile);
    }

    List<String> getProfileList() {
        return Collections.unmodifiableList(this.fProfileList);
    }

    void setProfileList(List<String> list) {
        List<String> list2 = this.fProfileList;
        this.fProfileList = list;
        this.fPropertyChangeSupport.firePropertyChange(PROFILE_LIST_CHANGED_PROPERTY, list2, this.fProfileList);
    }

    List<JobTableRowModel> getAllUsersJobTableRows() {
        return Collections.unmodifiableList(this.fAllUsersJobTableRows);
    }

    void setAllUsersJobTableRows(List<JobTableRowModel> list) {
        List<JobTableRowModel> list2 = this.fAllUsersJobTableRows;
        this.fAllUsersJobTableRows = list;
        this.fPropertyChangeSupport.firePropertyChange(ALL_USERS_JOB_TABLE_ROWS_CHANGED_PROPERTY, list2, this.fAllUsersJobTableRows);
    }

    List<JobTableRowModel> getIndividualUserJobTableRows() {
        return Collections.unmodifiableList(this.fIndividualUserJobTableRows);
    }

    void setIndividualUserJobTableRows(List<JobTableRowModel> list) {
        List<JobTableRowModel> list2 = this.fIndividualUserJobTableRows;
        this.fIndividualUserJobTableRows = list;
        this.fPropertyChangeSupport.firePropertyChange(INDIVIDUAL_USER_JOB_TABLE_ROWS_CHANGED_PROPERTY, list2, this.fIndividualUserJobTableRows);
    }

    boolean isShowJobsFromAllUser() {
        return this.fShowJobsFromAllUser;
    }

    void setShowJobsFromAllUser(boolean bl) {
        boolean bl2 = this.fShowJobsFromAllUser;
        this.fShowJobsFromAllUser = bl;
        this.fPropertyChangeSupport.firePropertyChange(SHOW_JOBS_FROM_ALL_USER_CHANGED_PROPERTY, bl2, this.fShowJobsFromAllUser);
    }

    void update() {
        this.update(this.fCurrentProfile, false);
    }

    private void initializeProfile() {
        new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Job Monitor: RunOnMatlabThread in initializeProfile()");
                return 1.feval((String)JobMonitorModel.JOB_MONITOR_HELPER_FCN, (Object[])new Object[]{JobMonitorModel.INITIALIZE_OPTION}, (int)2, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Job Monitor: RunOnEdtThread in initializeProfile()");
                JobMonitorModel.this.setCurrentProfile((String)((Object[])object)[0]);
                JobMonitorModel.this.setProfileList(Arrays.asList((String[])((Object[])object)[1]));
            }
        }.start();
    }

    private void update(final String string, final boolean bl) {
        this.fUpdateChangeSupport.fireUpdateStarted();
        new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Job Monitor: RunOnMatlabThread in update()");
                return 2.feval((String)JobMonitorModel.JOB_MONITOR_HELPER_FCN, (Object[])new Object[]{JobMonitorModel.UPDATE_OPTION, string}, (int)6, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Job Monitor: RunOnEdtThread in update()");
                String string4 = (String)((Object[])object)[0];
                List<String> list = Arrays.asList((String[])((Object[])object)[1]);
                List list2 = (List)((Object[])object)[2];
                List list3 = (List)((Object[])object)[3];
                String string2 = (String)((Object[])object)[4];
                String string3 = (String)((Object[])object)[5];
                JobMonitorModel.this.setCurrentProfile(string4);
                JobMonitorModel.this.setProfileList(list);
                JobMonitorModel.this.setAllUsersJobTableRows(list2);
                JobMonitorModel.this.setIndividualUserJobTableRows(list3);
                if (!string4.equals(string) && bl) {
                    JobMonitorModel.this.fPropertyChangeSupport.firePropertyChange(JobMonitorModel.REVERT_TO_DEFAULT_PROFILE, string, string4);
                }
                if (string2.length() > 0) {
                    JobMonitorModel.this.fPropertyChangeSupport.firePropertyChange(JobMonitorModel.MATLAB_ERROR, null, string2);
                }
                if (string3.length() > 0 && string3.equals(JobMonitorModel.ABORT_BY_USER_ERROR_ID)) {
                    JobMonitorModel.this.fPropertyChangeSupport.firePropertyChange(JobMonitorModel.UPDATE_ABORTED, false, true);
                    JobMonitorModel.this.fUpdateChangeSupport.fireUpdateCanceled();
                } else {
                    JobMonitorModel.this.fUpdateChangeSupport.fireUpdateFinished();
                }
            }

            protected void handleException(Exception exception, boolean bl2) {
                if (bl2 && exception.getMessage().equals(JobMonitorModel.MATLAB_INTERRUPTED_ERROR_MSG)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JobMonitorModel.this.fUpdateChangeSupport.fireUpdateCanceled();
                        }
                    });
                } else {
                    super.handleException(exception, bl2);
                    JobMonitorModel.this.fUpdateChangeSupport.fireUpdateFinished();
                }
            }
        }.start();
    }

    void cancelJob(List<JobTableRowModel> list) {
        int[] nArray = JobMonitorModel.getJobIds(list);
        this.runMLCodeWithErrorHandling(CANCEL_JOB_OPTION, new Object[]{this.fCurrentProfile, nArray}, false, CANCEL_JOB_ERRORED, true);
    }

    private static int[] getJobIds(List<JobTableRowModel> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = list.get(i).getJobID();
        }
        return nArray;
    }

    void deleteJob(List<JobTableRowModel> list) {
        int[] nArray = JobMonitorModel.getJobIds(list);
        this.runMLCodeWithErrorHandling(DELETE_JOB_OPTION, new Object[]{this.fCurrentProfile, nArray}, false, DELETE_JOB_ERRORED, true);
    }

    void showJobDetails(JobTableRowModel jobTableRowModel) {
        this.runMLCodeWithErrorHandling(SHOW_JOB_DETAILS_OPTION, new Object[]{this.fCurrentProfile, jobTableRowModel.getJobID()}, true, SHOW_JOB_DETAILS_ERRORED, false);
    }

    void showErroredTasksInJob(JobTableRowModel jobTableRowModel) {
        this.runMLCodeWithErrorHandling(SHOW_ERRORED_TASKS_IN_JOB_OPTION, new Object[]{this.fCurrentProfile, jobTableRowModel.getJobID(), jobTableRowModel.getJobStateModel().getErroredTaskIDs()}, true, SHOW_ERRORED_TASKS_ERRORED, false);
    }

    void fetchOutput(JobTableRowModel jobTableRowModel) {
        this.runMLCodeWithErrorHandling(FETCH_OUTPUTS_OPTION, new Object[]{this.fCurrentProfile, jobTableRowModel.getJobID()}, true, FETCH_OUTPUTS_ERRORED, false);
    }

    void loadVariables(JobTableRowModel jobTableRowModel) {
        this.runMLCodeWithErrorHandling(LOAD_VARIABLES_OPTION, new Object[]{this.fCurrentProfile, jobTableRowModel.getJobID()}, true, LOAD_VARIABLES_ERRORED, false);
    }

    void showDiary(JobTableRowModel jobTableRowModel) {
        this.runMLCodeWithErrorHandling(SHOW_DIARY_OPTION, new Object[]{this.fCurrentProfile, jobTableRowModel.getJobID()}, true, SHOW_DIARY_ERRORED, false);
    }

    void closeMATLABPool() {
        this.runMLCodeWithErrorHandling(CLOSE_MATLAB_POOL_OPTION, new Object[]{this.fCurrentProfile}, true, CLOSE_MATLAB_POOL_ERRORED, true);
    }

    void runMLCodeWithErrorHandling(String string, Object[] objectArray, final boolean bl, final String string2, final boolean bl2) {
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(string);
        arrayList.addAll(Arrays.asList(objectArray));
        new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 3.feval((String)JobMonitorModel.JOB_MONITOR_HELPER_FCN, (Object[])arrayList.toArray(new Object[arrayList.size()]), (int)0, (boolean)bl);
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (bl2) {
                    JobMonitorModel.this.update(JobMonitorModel.this.fCurrentProfile, true);
                }
            }

            protected void handleException(Exception exception, boolean bl3) {
                if (bl3) {
                    JobMonitorModel.this.fPropertyChangeSupport.firePropertyChange(string2, null, exception.getMessage());
                    JobMonitorModel.this.update(JobMonitorModel.this.fCurrentProfile, false);
                } else {
                    super.handleException(exception, bl3);
                }
            }
        }.start();
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    void addUpdateChangeListener(UpdateChangeListener updateChangeListener) {
        this.fUpdateChangeSupport.addUpdateChangeListener(updateChangeListener);
    }
}

