/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.jobmonitor;

import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobStateModel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobTableRowModel;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

final class JobMonitorTableModel
extends AbstractTableModel {
    private List<JobTableRowModel> fTableData = new ArrayList<JobTableRowModel>();
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
    static final int JOB_ID_COL = 0;
    private static final int USERNAME_COL = 1;
    private static final int SUBMIT_TIME_COL = 2;
    private static final int FINISH_TIME_COL = 3;
    private static final int NUM_TASKS_COL = 4;
    static final int STATE_COL = 5;
    private static final int DESCRIPTION_COL = 6;
    private static final int NUM_COLS = 7;

    JobMonitorTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.fTableData.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 5: {
                return JobStateModel.class;
            }
        }
        return super.getColumnClass(n);
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return sRes.getString("jobmonitor.jobtablecolumn.jobid");
            }
            case 1: {
                return sRes.getString("jobmonitor.jobtablecolumn.username");
            }
            case 2: {
                return sRes.getString("jobmonitor.jobtablecolumn.submittime");
            }
            case 3: {
                return sRes.getString("jobmonitor.jobtablecolumn.finishtime");
            }
            case 4: {
                return sRes.getString("jobmonitor.jobtablecolumn.numtasks");
            }
            case 5: {
                return sRes.getString("jobmonitor.jobtablecolumn.state");
            }
            case 6: {
                return sRes.getString("jobmonitor.jobtablecolumn.Description");
            }
        }
        assert (false) : "Unknown column index = " + n;
        return "Unknown";
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        JobTableRowModel jobTableRowModel = this.fTableData.get(n);
        switch (n2) {
            case 0: {
                return jobTableRowModel.getJobID();
            }
            case 1: {
                return jobTableRowModel.getUsername();
            }
            case 2: {
                return jobTableRowModel.getSubmitTime();
            }
            case 3: {
                return jobTableRowModel.getFinishTime();
            }
            case 4: {
                return jobTableRowModel.getNumTasks();
            }
            case 5: {
                return jobTableRowModel.getJobStateModel();
            }
            case 6: {
                return jobTableRowModel.getDescription();
            }
        }
        assert (false) : "Unknown column index = " + n2;
        return "Unknown";
    }

    void updateTableData(List<JobTableRowModel> list) {
        this.fTableData.clear();
        this.fTableData.addAll(list);
        this.fireTableDataChanged();
    }

    public boolean hasAnyErrors() {
        for (JobTableRowModel jobTableRowModel : this.fTableData) {
            if (!jobTableRowModel.getJobStateModel().hasErrors()) continue;
            return true;
        }
        return false;
    }
}

