/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.jobmonitor;

public final class JobStateModel
implements Comparable<JobStateModel> {
    private final String fState;
    private final int fTotalTasks;
    private final int fPendingTasks;
    private final int fRunningTasks;
    private final int fFinishedTasks;
    private final int fFinishedTasksNoError;
    private final int fFinishedTasksWithError;
    private final int[] fErroredTaskIDs;
    private final String[] fErrorMessages;

    public JobStateModel(String string, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, String[] stringArray) {
        this.fState = string;
        this.fTotalTasks = n;
        this.fPendingTasks = n2;
        this.fRunningTasks = n3;
        this.fFinishedTasks = n4;
        this.fFinishedTasksNoError = n5;
        this.fFinishedTasksWithError = n6;
        this.fErroredTaskIDs = nArray;
        this.fErrorMessages = stringArray;
    }

    String getState() {
        return this.fState;
    }

    int getTotalTasks() {
        return this.fTotalTasks;
    }

    int getPendingTasks() {
        return this.fPendingTasks;
    }

    int getRunningTasks() {
        return this.fRunningTasks;
    }

    int getFinishedTasks() {
        return this.fFinishedTasks;
    }

    int getFinishedTasksNoError() {
        return this.fFinishedTasksNoError;
    }

    int getFinishedTasksWithError() {
        return this.fFinishedTasksWithError;
    }

    int[] getErroredTaskIDs() {
        return this.fErroredTaskIDs;
    }

    String[] getErrorMessages() {
        return this.fErrorMessages;
    }

    boolean hasErrors() {
        return this.fFinishedTasksWithError > 0;
    }

    boolean isDone() {
        return this.getState().equals("finished") || this.getState().equals("failed");
    }

    boolean isRunning() {
        return this.getState().equals("running");
    }

    public String toString() {
        String string = this.getState();
        if (this.hasErrors()) {
            string = string + " with error";
        }
        return string;
    }

    @Override
    public int compareTo(JobStateModel jobStateModel) {
        if (this.getStateSortOrder().getIndex() > jobStateModel.getStateSortOrder().getIndex()) {
            return 1;
        }
        if (this.getStateSortOrder().getIndex() < jobStateModel.getStateSortOrder().getIndex()) {
            return -1;
        }
        return 0;
    }

    private StateSortOrder getStateSortOrder() {
        if (this.getState().equals("pending")) {
            return StateSortOrder.PENDING;
        }
        if (this.getState().equals("queued")) {
            return StateSortOrder.QUEUED;
        }
        if (this.getState().equals("running")) {
            if (this.hasErrors()) {
                return StateSortOrder.RUNNING_WITH_ERRORS;
            }
            return StateSortOrder.RUNNING;
        }
        if (this.getState().equals("finished")) {
            if (this.hasErrors()) {
                return StateSortOrder.FINISHED_WITH_ERRORS;
            }
            return StateSortOrder.FINISHED;
        }
        if (this.getState().equals("failed")) {
            return StateSortOrder.FAILED;
        }
        return StateSortOrder.UNKNOWN;
    }

    private static enum StateSortOrder {
        PENDING(0),
        QUEUED(1),
        RUNNING(2),
        RUNNING_WITH_ERRORS(3),
        FINISHED(4),
        FINISHED_WITH_ERRORS(5),
        FAILED(6),
        UNKNOWN(-1);

        private final int fOrderIndex;

        private StateSortOrder(int n2) {
            this.fOrderIndex = n2;
        }

        int getIndex() {
            return this.fOrderIndex;
        }
    }
}

