/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.jobmanager.JobManager;
import com.mathworks.toolbox.distcomp.service.DistcompService;
import com.mathworks.toolbox.distcomp.util.ActivationSystemFinder;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.sun.jini.phoenix.ActivationAdmin;
import com.sun.jini.start.ServiceProxyAccessor;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.util.Map;
import java.util.Vector;

public class ActivationAdminWrapper {
    private static final boolean sDoNotForceContacting = false;
    private ActivationSystemFinder fSystemFinder = null;
    private ActivationAdmin fAdmin = null;

    public ActivationAdminWrapper(String string, int n) {
        this.fSystemFinder = new ActivationSystemFinder(string, n);
    }

    public boolean findAdminTryManyTimes() {
        this.fAdmin = (ActivationAdmin)this.fSystemFinder.findSystemTryManyTimes();
        return this.fAdmin != null;
    }

    public boolean findAdminTryOnce() {
        this.fAdmin = (ActivationAdmin)this.fSystemFinder.findSystemTryOnce();
        return this.fAdmin != null;
    }

    public void verifyAdminTryOnce() throws DistcompDiagnosticException {
        this.fAdmin = (ActivationAdmin)this.fSystemFinder.verifySystemTryOnce();
    }

    public void verifyAdminTryManyTimes() throws DistcompDiagnosticException {
        this.fAdmin = (ActivationAdmin)this.fSystemFinder.verifySystemTryManyTimes();
    }

    public Worker[] getWorkers() {
        Remote[] remoteArray = this.getRemote();
        if (remoteArray == null) {
            return null;
        }
        Vector<Worker> vector = new Vector<Worker>();
        for (int i = 0; i < remoteArray.length; ++i) {
            if (!(remoteArray[i] instanceof Worker)) continue;
            vector.add((Worker)((Object)remoteArray[i]));
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new Worker[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public JobManager[] getJobManagers() {
        Remote[] remoteArray = this.getRemote();
        if (remoteArray == null) {
            return null;
        }
        Vector<JobManager> vector = new Vector<JobManager>();
        for (int i = 0; i < remoteArray.length; ++i) {
            if (!(remoteArray[i] instanceof JobManager)) continue;
            vector.add((JobManager)((Object)remoteArray[i]));
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new JobManager[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasJobManager(String string) {
        return this.hasService(this.getJobManagers(), string);
    }

    public DistcompService getJobManager(String string) {
        return this.getServiceByName(this.getJobManagers(), string);
    }

    public boolean hasLookup() {
        Remote[] remoteArray = this.getRemote();
        if (remoteArray == null) {
            return false;
        }
        for (int i = 0; i < remoteArray.length; ++i) {
            if (!(remoteArray[i] instanceof ServiceProxyAccessor)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWorker(String string) {
        return this.hasService(this.getWorkers(), string);
    }

    public DistcompService getWorker(String string) {
        return this.getServiceByName(this.getWorkers(), string);
    }

    private ActivationGroupID[] getActivationGroupIDs() {
        Map map;
        if (this.fAdmin == null) {
            return null;
        }
        try {
            map = this.fAdmin.getActivationGroups();
        }
        catch (Exception exception) {
            return null;
        }
        Object[] objectArray = map.keySet().toArray();
        if (objectArray.length == 0) {
            return null;
        }
        ActivationGroupID[] activationGroupIDArray = new ActivationGroupID[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            activationGroupIDArray[i] = (ActivationGroupID)objectArray[i];
        }
        return activationGroupIDArray;
    }

    private ActivationID[] getActivationIDs() {
        if (this.fAdmin == null) {
            return null;
        }
        ActivationGroupID[] activationGroupIDArray = this.getActivationGroupIDs();
        if (activationGroupIDArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < activationGroupIDArray.length; ++i) {
            try {
                Object[] objectArray = this.fAdmin.getActivatableObjects(activationGroupIDArray[i]).keySet().toArray();
                if (objectArray == null) continue;
                for (int j = 0; j < objectArray.length; ++j) {
                    vector.add(objectArray[j]);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new ActivationID[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Remote[] getRemote() {
        ActivationID[] activationIDArray = this.getActivationIDs();
        if (activationIDArray == null) {
            return null;
        }
        Vector<Remote> vector = new Vector<Remote>();
        for (int i = 0; i < activationIDArray.length; ++i) {
            try {
                Remote remote = activationIDArray[i].activate(false);
                vector.add(remote);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new Remote[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean hasService(DistcompService[] distcompServiceArray, String string) {
        if (distcompServiceArray == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        for (int i = 0; i < distcompServiceArray.length; ++i) {
            try {
                if (!string.equals(distcompServiceArray[i].getName())) continue;
                return true;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    private DistcompService getServiceByName(DistcompService[] distcompServiceArray, String string) {
        if (distcompServiceArray == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        for (int i = 0; i < distcompServiceArray.length; ++i) {
            try {
                if (!string.equals(distcompServiceArray[i].getName())) continue;
                return distcompServiceArray[i];
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }
}

