/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.jmi.NativeMatlab;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MCRShutdownHandler {
    private static final Map<MatlabMCR, MCRHookList> sHooks = new HashMap<MatlabMCR, MCRHookList>();

    public static void registerForCurrentMCR() {
        assert (NativeMatlab.nativeIsMatlabThread()) : "Must be called on MATLAB main thread.";
        MCRShutdownHandler.register(MatlabMCRFactory.getForCurrentMCR());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(MatlabMCR matlabMCR) {
        Map<MatlabMCR, MCRHookList> map = sHooks;
        synchronized (map) {
            if (!MCRShutdownHandler.isRegistered(matlabMCR)) {
                sHooks.put(matlabMCR, null);
            }
        }
    }

    public static void initializeForCurrentMCR() {
        assert (NativeMatlab.nativeIsMatlabThread()) : "Must be called on MATLAB main thread.";
        MCRShutdownHandler.initialize(MatlabMCRFactory.getForCurrentMCR());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(MatlabMCR matlabMCR) {
        Map<MatlabMCR, MCRHookList> map = sHooks;
        synchronized (map) {
            if (!MCRShutdownHandler.isRegistered(matlabMCR)) {
                return;
            }
            if (MCRShutdownHandler.isInitialized(matlabMCR)) {
                throw new IllegalStateException("MCRShutdownHandler already initialized for this MCR.");
            }
            sHooks.put(matlabMCR, new MCRHookList());
        }
    }

    public static void addShutdownHookForCurrentMCR(Thread thread) {
        assert (NativeMatlab.nativeIsMatlabThread()) : "Must be called on MATLAB main thread.";
        MCRShutdownHandler.addShutdownHook(MatlabMCRFactory.getForCurrentMCR(), thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addShutdownHook(MatlabMCR matlabMCR, Thread thread) {
        assert (thread.getState() == Thread.State.NEW) : "Hook thread must not have been started.";
        Map<MatlabMCR, MCRHookList> map = sHooks;
        synchronized (map) {
            if (!MCRShutdownHandler.isRegistered(matlabMCR)) {
                return;
            }
            if (!MCRShutdownHandler.isInitialized(matlabMCR)) {
                throw new IllegalStateException("MCRShutdownHandler must be initialized before calling addShutdownHook.");
            }
            MCRHookList mCRHookList = MCRShutdownHandler.getHooksForMCR(matlabMCR);
            mCRHookList.addHook(thread);
        }
    }

    public static void runShutdownHooksForCurrentMCR() {
        assert (NativeMatlab.nativeIsMatlabThread()) : "Must be called on MATLAB main thread.";
        MCRShutdownHandler.runShutdownHooks(MatlabMCRFactory.getForCurrentMCR());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runShutdownHooks(MatlabMCR matlabMCR) {
        MCRHookList mCRHookList;
        Map<MatlabMCR, MCRHookList> map = sHooks;
        synchronized (map) {
            if (!MCRShutdownHandler.isRegistered(matlabMCR)) {
                return;
            }
            if (!MCRShutdownHandler.isInitialized(matlabMCR)) {
                throw new IllegalStateException("MCRShutdownHandler must be initialized before calling runShutdownHooks.");
            }
            mCRHookList = MCRShutdownHandler.getHooksForMCR(matlabMCR);
        }
        mCRHookList.runHooks();
        map = sHooks;
        synchronized (map) {
            sHooks.put(matlabMCR, null);
        }
    }

    private static boolean isRegistered(MatlabMCR matlabMCR) {
        return sHooks.containsKey(matlabMCR);
    }

    private static boolean isInitialized(MatlabMCR matlabMCR) {
        return sHooks.get(matlabMCR) != null;
    }

    private static MCRHookList getHooksForMCR(MatlabMCR matlabMCR) {
        if (sHooks.containsKey(matlabMCR)) {
            return sHooks.get(matlabMCR);
        }
        throw new IllegalStateException("MCRShutdownHandler has not been initialized for this MCR");
    }

    static class MCRHookList {
        private final List<Thread> fHooks = new Vector<Thread>();
        private boolean fLocked = false;

        MCRHookList() {
        }

        synchronized void addHook(Thread thread) {
            if (this.fLocked) {
                throw new IllegalStateException("Can't add hook to running hook list.");
            }
            this.fHooks.add(thread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runHooks() {
            if (this.fLocked) {
                throw new IllegalStateException("Can't run hooks when hooks are already running.");
            }
            Object object = this;
            synchronized (object) {
                this.fLocked = true;
            }
            object = this.fHooks.iterator();
            while (object.hasNext()) {
                Thread thread = (Thread)object.next();
                thread.start();
                object.remove();
            }
        }
    }
}

