/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util.concurrent;

import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class SignalingAtomicBoolean {
    private final Lock fLock = new ReentrantLock();
    private final Condition fChanged = this.fLock.newCondition();
    private boolean fValue = false;

    public SignalingAtomicBoolean() {
    }

    public SignalingAtomicBoolean(boolean bl) {
        this.fValue = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean get() {
        this.fLock.lock();
        try {
            boolean bl = this.fValue;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(boolean bl, boolean bl2) {
        this.fLock.lock();
        try {
            if (this.fValue == bl) {
                this.set(bl2);
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(boolean bl) {
        this.fLock.lock();
        try {
            boolean bl2 = this.fValue;
            this.fValue = bl;
            if (this.fValue != bl2) {
                this.fChanged.signalAll();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAndSet(boolean bl) {
        this.fLock.lock();
        try {
            boolean bl2 = this.fValue;
            this.set(bl);
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitValue(boolean bl) throws InterruptedException {
        this.fLock.lock();
        try {
            while (bl != this.fValue) {
                this.fChanged.await();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void awaitTrue() throws InterruptedException {
        this.awaitValue(true);
    }

    public void awaitFalse() throws InterruptedException {
        this.awaitValue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitValue(boolean bl, long l, TimeUnit timeUnit) throws InterruptedException {
        this.fLock.lock();
        try {
            if (bl == this.fValue) {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            long l2 = System.currentTimeMillis();
            long l3 = l2 + TimeUnit.MILLISECONDS.convert(l, timeUnit);
            if (l > 0L) assert (l3 > l2) : "awaitValue() asked to wait " + l + " " + (Object)((Object)timeUnit) + "s. Write code to support wait times less than one millisecond.";
            Date date = new Date(l3);
            while (bl != this.fValue && System.currentTimeMillis() < l3) {
                bl3 = this.fChanged.awaitUntil(date);
            }
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public boolean awaitTrue(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.awaitValue(true, l, timeUnit);
    }

    public boolean awaitFalse(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.awaitValue(false, l, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.fLock.lock();
        try {
            String string = Boolean.toString(this.fValue);
            return string;
        }
        finally {
            this.fLock.unlock();
        }
    }
}

