/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab;

import com.mathworks.toolbox.distcomp.remote.util.StreamRedirector;
import com.mathworks.toolbox.distcomp.util.NullOutputStream;
import com.mathworks.toolbox.distcomp.worker.PackageInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

final class WindowsFileAcl {
    private final File fFile;
    private final String fGrantUserScriptPath;

    WindowsFileAcl(File file, String string) {
        this.fFile = file;
        this.fGrantUserScriptPath = string + File.separator + "bin" + File.separator + "util" + File.separator + "grantUserRights.vbs";
        File file2 = new File(this.fGrantUserScriptPath);
        if (!file2.exists()) {
            throw new IllegalStateException("Can not find required script: " + this.fGrantUserScriptPath);
        }
    }

    WindowsFileAcl(File file) {
        this(file, WindowsFileAcl.getToolboxRootFromSystemProperty());
    }

    private static String getToolboxRootFromSystemProperty() {
        String string = System.getProperty("com.mathworks.toolbox.distcomp.toolboxroot");
        if (string == null) {
            throw new IllegalStateException("System property 'com.mathworks.toolbox.distcomp.toolboxroot' is not set");
        }
        return string;
    }

    void modify(String string, Permission permission) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder("cscript.exe", "//nologo", this.fGrantUserScriptPath, "-modify", this.fFile.getCanonicalPath(), string, permission.getArgumentName());
        processBuilder.redirectErrorStream(true);
        PackageInfo.LOGGER.finest("About to call " + Arrays.deepToString(processBuilder.command().toArray()));
        Process process = processBuilder.start();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamRedirector streamRedirector = StreamRedirector.getInstance();
        StreamRedirector.RedirectionPair redirectionPair = streamRedirector.addRedirect(process.getInputStream(), byteArrayOutputStream);
        StreamRedirector.RedirectionPair redirectionPair2 = streamRedirector.addRedirect(process.getErrorStream(), new NullOutputStream());
        try {
            int n = process.waitFor();
            streamRedirector.removeRedirect(redirectionPair);
            streamRedirector.removeRedirect(redirectionPair2);
            if (n != 0) {
                PackageInfo.LOGGER.warning("grantUserRights.vbs ended with exit status : " + n);
                PackageInfo.LOGGER.warning("grantUserRights.vbs output: " + byteArrayOutputStream.toString());
                throw new IOException("Failed to give " + string + " " + (Object)((Object)permission) + " permissions on " + this.fFile);
            }
        }
        catch (InterruptedException interruptedException) {
            streamRedirector.removeRedirect(redirectionPair);
            streamRedirector.removeRedirect(redirectionPair2);
            throw new IOException("Interrupted while attempting to give " + string + " " + (Object)((Object)permission) + " permissions on " + this.fFile);
        }
    }

    static enum Permission {
        TRAVERSAL("Traversal"),
        READONLY("ReadOnly"),
        READWRITE("ReadWrite"),
        FULLCONTROL("FullControl");

        private final String fArgumentName;

        private Permission(String string2) {
            this.fArgumentName = string2;
        }

        private String getArgumentName() {
            return this.fArgumentName;
        }
    }
}

