/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.swing.DocView;
import javax.accessibility.AccessibleHyperlink;

public class AccessibleLink
extends AccessibleHyperlink {
    protected DAnchorElement link;
    protected DocView docView;
    protected Html4DocumentAccess docAccess;

    public AccessibleLink(DAnchorElement dAnchorElement, DocView docView, Html4DocumentAccess html4DocumentAccess) {
        this.link = dAnchorElement;
        this.docView = docView;
        this.docAccess = html4DocumentAccess;
    }

    public boolean isValid() {
        ThePilot thePilot = this.docView.getPilot();
        if (thePilot == null) {
            return false;
        }
        DDocument dDocument = thePilot.getDDocument();
        if (dDocument == null) {
            return false;
        }
        return dDocument.contains((DNode)this.link);
    }

    public int getAccessibleActionCount() {
        return 1;
    }

    public boolean doAccessibleAction(int n) {
        if (n == 0 && this.isValid()) {
            this.link.click();
            return true;
        }
        return false;
    }

    public String getAccessibleActionDescription(int n) {
        if (n == 0 && this.isValid()) {
            String string = this.link.getInnerText();
            if (string != null) {
                return string;
            }
            String string2 = this.link.getAttribute("alt");
            if (string2 != null) {
                return string2;
            }
        }
        return null;
    }

    public Object getAccessibleActionObject(int n) {
        if (n == 0 && this.isValid()) {
            return this.link.getAttribute("href");
        }
        return null;
    }

    public Object getAccessibleActionAnchor(int n) {
        return this.getAccessibleActionDescription(0);
    }

    public int getStartIndex() {
        int n = this.docAccess.getIndexOfNode((DNode)this.link);
        if (n < 0 || n > this.docAccess.getCount(1)) {
            return -1;
        }
        return n;
    }

    public int getEndIndex() {
        int n = this.getStartIndex();
        if (n == -1) {
            return -1;
        }
        String string = this.getAccessibleActionDescription(0);
        if (string == null) {
            return -1;
        }
        int n2 = n + string.length();
        if (n2 > this.docAccess.getCount(1)) {
            return -1;
        }
        return n2;
    }
}

