/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.licensefiles;

import com.mathworks.instutil.FolderUtilsImpl;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractMarkerUtility {
    protected static final String MARKER_FILE_NAME = "license_info.xml";
    protected static final String ACTIVATION_ENTRY = "ActivationEntry";
    protected static final String ID_NUMBER = "idnumber";
    protected static final String USER_NAME = "user";
    protected static final String MLROOT = "matlabroot";
    protected static final String HOSTNAME = "hostname";
    protected static final String LIC_MODE = "licmode";
    protected static final String ROOT = "root";
    protected static final String LIC_MODE_ONLINE = "online";

    public abstract void installMarkerFile() throws Exception;

    abstract void editRequiredEntry(Node var1);

    public boolean checkMarkerFileExists(String string) {
        try {
            return new File(string + File.separatorChar + MARKER_FILE_NAME).isFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final Document readXMLFile(String string) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(string + File.separatorChar + MARKER_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printToFile(Document document, String string) throws IOException {
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setIndenting(true);
        FileOutputStream fileOutputStream = null;
        try {
            if (!new File(string).isDirectory()) {
                new FolderUtilsImpl().mkdirs(string);
            }
            fileOutputStream = new FileOutputStream(new File(string, MARKER_FILE_NAME));
            XMLSerializer xMLSerializer = new XMLSerializer(fileOutputStream, outputFormat);
            xMLSerializer.serialize(document);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    public final Node checkIfNodePresent(Document document, String string, String string2, String string3) {
        String string4 = FilenameUtils.normalizeNoEndSeparator((String)string3);
        NodeList nodeList = document.getElementsByTagName(ACTIVATION_ENTRY);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap.getLength() <= 0 || !namedNodeMap.getNamedItem(USER_NAME).getNodeValue().equals(string) || !namedNodeMap.getNamedItem(HOSTNAME).getNodeValue().equals(string2) || !FilenameUtils.equalsOnSystem((String)namedNodeMap.getNamedItem(MLROOT).getNodeValue(), (String)string4)) continue;
            return node;
        }
        return null;
    }
}

