/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.RelativeTimeConstraint;

public final class ConnectionRelativeTime
implements RelativeTimeConstraint,
Serializable {
    private static final long serialVersionUID = 6854732178792183150L;
    private final long time;

    public ConnectionRelativeTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid duration");
        }
        this.time = l;
    }

    public long getTime() {
        return this.time;
    }

    public InvocationConstraint makeAbsolute(long l) {
        return new ConnectionAbsoluteTime(ConnectionRelativeTime.add(this.time, l));
    }

    private static long add(long l, long l2) {
        long l3 = l2 + l;
        if (l3 < 0L && l2 > 0L) {
            l3 = Long.MAX_VALUE;
        }
        return l3;
    }

    public int hashCode() {
        return (int)((long)ConnectionRelativeTime.class.hashCode() + this.time);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConnectionRelativeTime)) {
            return false;
        }
        ConnectionRelativeTime connectionRelativeTime = (ConnectionRelativeTime)object;
        return this.time == connectionRelativeTime.time;
    }

    public String toString() {
        return "ConnectionRelativeTime[" + this.time + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.time < 0L) {
            throw new InvalidObjectException("invalid duration");
        }
    }
}

