/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.jini.core.constraint.InvocationConstraint;

public final class DelegationAbsoluteTime
implements InvocationConstraint,
Serializable {
    private static final long serialVersionUID = -2807470616717350051L;
    private final long minStart;
    private final long maxStart;
    private final long minStop;
    private final long maxStop;
    private static SoftReference formatterRef;

    public DelegationAbsoluteTime(long l, long l2, long l3, long l4) {
        if (l > l2 || l2 > l3 || l3 > l4) {
            throw new IllegalArgumentException("illegal times");
        }
        this.minStart = l;
        this.maxStart = l2;
        this.minStop = l3;
        this.maxStop = l4;
    }

    public DelegationAbsoluteTime(Date date, Date date2, Date date3, Date date4) {
        this(date.getTime(), date2.getTime(), date3.getTime(), date4.getTime());
    }

    public long getMinStart() {
        return this.minStart;
    }

    public long getMaxStart() {
        return this.maxStart;
    }

    public long getMinStop() {
        return this.minStop;
    }

    public long getMaxStop() {
        return this.maxStop;
    }

    public int hashCode() {
        return (int)((long)DelegationAbsoluteTime.class.hashCode() + this.minStart + this.maxStart + this.minStop + this.maxStop);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DelegationAbsoluteTime)) {
            return false;
        }
        DelegationAbsoluteTime delegationAbsoluteTime = (DelegationAbsoluteTime)object;
        return this.minStart == delegationAbsoluteTime.minStart && this.maxStart == delegationAbsoluteTime.maxStart && this.minStop == delegationAbsoluteTime.minStop && this.maxStop == delegationAbsoluteTime.maxStop;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = DelegationAbsoluteTime.getFormatter();
        FieldPosition fieldPosition = new FieldPosition(0);
        StringBuffer stringBuffer = new StringBuffer(95);
        stringBuffer.append("DelegationAbsoluteTime[start: ");
        DelegationAbsoluteTime.format(this.minStart, this.maxStart, simpleDateFormat, stringBuffer, fieldPosition);
        stringBuffer.append(", stop: ");
        DelegationAbsoluteTime.format(this.minStop, this.maxStop, simpleDateFormat, stringBuffer, fieldPosition);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static void format(long l, long l2, SimpleDateFormat simpleDateFormat, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (l == l2) {
            simpleDateFormat.format(new Date(l), stringBuffer, fieldPosition);
        } else {
            stringBuffer.append('[');
            simpleDateFormat.format(new Date(l), stringBuffer, fieldPosition);
            stringBuffer.append(", ");
            simpleDateFormat.format(new Date(l2), stringBuffer, fieldPosition);
            stringBuffer.append(']');
        }
    }

    private static synchronized SimpleDateFormat getFormatter() {
        SimpleDateFormat simpleDateFormat = null;
        if (formatterRef != null) {
            simpleDateFormat = (SimpleDateFormat)formatterRef.get();
        }
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSSS zzz", Locale.US);
            formatterRef = new SoftReference<SimpleDateFormat>(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.minStart > this.maxStart || this.maxStart > this.minStop || this.minStop > this.maxStop) {
            throw new InvalidObjectException("invalid times");
        }
    }
}

