/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.proxy;

import java.io.InvalidObjectException;
import java.lang.reflect.Method;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;

public class ConstrainableProxyUtil {
    private ConstrainableProxyUtil() {
        throw new AssertionError();
    }

    public static MethodConstraints translateConstraints(MethodConstraints methodConstraints, Method[] methodArray) {
        if (methodArray.length % 2 != 0) {
            throw new IllegalArgumentException("mappings has odd length");
        }
        if (methodConstraints == null) {
            return null;
        }
        int n = methodArray.length / 2;
        BasicMethodConstraints.MethodDesc[] methodDescArray = new BasicMethodConstraints.MethodDesc[n];
        for (int i = methodArray.length - 1; i >= 0; i -= 2) {
            Method method = methodArray[i - 1];
            Method method2 = methodArray[i];
            methodDescArray[--n] = new BasicMethodConstraints.MethodDesc(method2.getName(), (Class[])method2.getParameterTypes(), methodConstraints.getConstraints(method));
        }
        return new BasicMethodConstraints(methodDescArray);
    }

    public static boolean equivalentConstraints(MethodConstraints methodConstraints, MethodConstraints methodConstraints2, Method[] methodArray) {
        if (methodArray.length % 2 != 0) {
            throw new IllegalArgumentException("mappings has odd length");
        }
        if (methodConstraints == null && methodConstraints2 == null) {
            return true;
        }
        if (methodConstraints == null || methodConstraints2 == null) {
            return false;
        }
        int n = methodArray.length / 2;
        for (int i = 0; i < methodArray.length; i += 2) {
            InvocationConstraints invocationConstraints;
            InvocationConstraints invocationConstraints2 = methodConstraints.getConstraints(methodArray[i]);
            if (invocationConstraints2.equals((Object)(invocationConstraints = methodConstraints2.getConstraints(methodArray[i + 1])))) continue;
            return false;
        }
        return true;
    }

    public static void verifyConsistentConstraints(MethodConstraints methodConstraints, Object object, Method[] methodArray) throws InvalidObjectException {
        if (!(object instanceof RemoteMethodControl)) {
            throw new InvalidObjectException("Proxy does not implement RemoteMethodControl");
        }
        MethodConstraints methodConstraints2 = ((RemoteMethodControl)object).getConstraints();
        if (!ConstrainableProxyUtil.equivalentConstraints(methodConstraints, methodConstraints2, methodArray)) {
            throw new InvalidObjectException("Inconsistent constraints on proxy");
        }
    }
}

