/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp;

import com.mathworks.toolbox.instrument.device.drivers.vxipnp.VXIPnPLoader;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.Argument;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.FunctionPanel;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.VendorParser;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverDataType;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverProperty;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DefaultVendorParser
implements VendorParser {
    protected DriverModel fModel;
    protected Hashtable<String, ?> fFunctions;
    protected Vector<Object> fFunctionNames;
    protected Hashtable<Object, FunctionPanel> fModelFPMapping;

    @Override
    public void parseFunctionPanels(DriverModel driverModel, Hashtable<String, ?> hashtable) {
        this.fModel = driverModel;
        this.fFunctions = hashtable;
        this.fFunctionNames = new Vector();
        this.fModelFPMapping = new Hashtable();
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            this.fFunctionNames.add(enumeration.nextElement());
        }
        this.sortFunctionPanels();
        if (VXIPnPLoader.getMinPropertiesPerGroup() > 0 || VXIPnPLoader.getMinFunctionsPerGroup() > 0) {
            this.removeSmallGroups();
        }
    }

    protected void sortFunctionPanels() {
        try {
            while (!this.fFunctionNames.isEmpty()) {
                FunctionPanel functionPanel;
                FunctionPanel functionPanel2;
                String string = (String)this.fFunctionNames.get(0);
                this.fFunctionNames.remove(string);
                if (string.equals("init") || string.equals("initwithoptions") || string.equals("close") || this.ignoreThisFunction(functionPanel2 = (FunctionPanel)this.fFunctions.get(string))) continue;
                DriverGroup driverGroup = this.fModel.getGroup(functionPanel2.getMATLABSafeClassName());
                if (driverGroup == null) {
                    driverGroup = this.fModel.createGroup(functionPanel2.getMATLABSafeClassName());
                }
                if (this.canBeGetFunction(functionPanel2)) {
                    functionPanel = this.findSetFunctionFor(functionPanel2);
                    if (this.isValidPropertyPair(functionPanel2, functionPanel)) {
                        this.createProperty(this.propertyNameFor(functionPanel2, functionPanel), functionPanel2, functionPanel, driverGroup);
                        if (functionPanel == null) continue;
                        this.fFunctionNames.remove(functionPanel.getName());
                        continue;
                    }
                } else if (this.canBeSetFunction(functionPanel2) && this.isValidPropertyPair(functionPanel = this.findGetFunctionFor(functionPanel2), functionPanel2)) {
                    this.createProperty(this.propertyNameFor(functionPanel, functionPanel2), functionPanel, functionPanel2, driverGroup);
                    if (functionPanel == null) continue;
                    this.fFunctionNames.remove(functionPanel.getName());
                    continue;
                }
                this.createFunction(this.functionNameFor(functionPanel2), functionPanel2, driverGroup);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected boolean ignoreThisFunction(FunctionPanel functionPanel) {
        return false;
    }

    protected boolean canBeGetFunction(FunctionPanel functionPanel) {
        return functionPanel.getName().startsWith("Get");
    }

    protected FunctionPanel findSetFunctionFor(FunctionPanel functionPanel) {
        return (FunctionPanel)this.fFunctions.get("Set" + this.propertyNameFor(functionPanel, null));
    }

    protected boolean canBeSetFunction(FunctionPanel functionPanel) {
        return functionPanel.getName().startsWith("Set");
    }

    protected FunctionPanel findGetFunctionFor(FunctionPanel functionPanel) {
        return (FunctionPanel)this.fFunctions.get("Get" + this.propertyNameFor(null, functionPanel));
    }

    protected String propertyNameFor(FunctionPanel functionPanel, FunctionPanel functionPanel2) {
        if (functionPanel != null) {
            return functionPanel.getName().substring(3);
        }
        if (functionPanel2 != null) {
            return functionPanel2.getName().substring(3);
        }
        return "";
    }

    protected String functionNameFor(FunctionPanel functionPanel) {
        return functionPanel.getName().toLowerCase();
    }

    protected boolean isValidPropertyPair(FunctionPanel functionPanel, FunctionPanel functionPanel2) {
        if (functionPanel == null || !functionPanel.isValidAsGetFunction()) {
            return false;
        }
        return functionPanel2 == null || functionPanel2.isValidAsSetFunction();
    }

    protected DriverFunction createFunction(String string, FunctionPanel functionPanel, DriverGroup driverGroup) {
        string = string.replaceAll("\\W+", "");
        if (Character.isDigit((string = string.replaceAll("_", "")).charAt(0))) {
            string = "f" + string;
        }
        DriverFunction driverFunction = new DriverFunction(string, driverGroup);
        driverFunction.setCodeType(1);
        driverFunction.setMCodeToEvaluate(functionPanel.getMCode(driverFunction.getName().toLowerCase()));
        driverFunction.setDescription(functionPanel.getHelpText());
        this.fModel.add(driverFunction);
        this.fModelFPMapping.put(driverGroup.getName() + string, functionPanel);
        return driverFunction;
    }

    protected DriverProperty createProperty(String string, FunctionPanel functionPanel, FunctionPanel functionPanel2, DriverGroup driverGroup) {
        if ((string = string.replaceAll("\\W+", "_")).startsWith("_")) {
            string = string.substring(1);
        }
        if ((string = string.substring(0, 1).toUpperCase() + string.substring(1)).equalsIgnoreCase("timeout")) {
            string = driverGroup.getName().equalsIgnoreCase("parent") ? "DriverSpecific" + string : driverGroup.getName() + string;
        }
        DriverProperty driverProperty = new DriverProperty(string, driverGroup);
        driverProperty.setGetCodeToEvaluate(functionPanel.getPropertyGetMCode());
        if (functionPanel2 == null) {
            driverProperty.setReadOnly("always");
        } else {
            driverProperty.setSetCodeToEvaluate(functionPanel2.getPropertySetMCode());
        }
        driverProperty.setCodeType(1);
        DriverDataType driverDataType = new DriverDataType(0, 2);
        driverDataType.setParentProperty(driverProperty);
        Argument argument = functionPanel.getGetArgument();
        if (functionPanel2 != null) {
            Argument argument2 = functionPanel2.getSetArgument();
            if (argument.isBoolean() || argument2.isBoolean()) {
                driverDataType.setDataType(2);
            } else {
                int n = argument2.getType();
                if (n == 3 && argument2.getRingType() != 1) {
                    driverDataType.setRange(argument2.getMinValue(), argument2.getMaxValue());
                    driverDataType.setConstraintType(0);
                }
            }
        } else if (argument.isBoolean()) {
            driverDataType.setDataType(2);
        }
        driverProperty.addPropertyType(driverDataType);
        this.fModelFPMapping.put(driverGroup.getName() + "get" + string, functionPanel);
        if (functionPanel2 != null) {
            this.fModelFPMapping.put(driverGroup.getName() + "set" + string, functionPanel2);
        }
        this.fModel.add(driverProperty);
        return driverProperty;
    }

    protected void removeSmallGroups() {
        DriverGroup[] driverGroupArray = this.fModel.getGroups();
        FunctionPanel functionPanel = null;
        DriverGroup driverGroup = this.fModel.getGroup("parent");
        for (int i = 1; i < driverGroupArray.length; ++i) {
            Cloneable cloneable;
            DriverGroup driverGroup2 = driverGroupArray[i];
            if (driverGroup2.getProperties().size() >= VXIPnPLoader.getMinPropertiesPerGroup() && driverGroup2.getFunctions().size() >= VXIPnPLoader.getMinFunctionsPerGroup()) continue;
            this.fModel.remove(driverGroup2);
            Enumeration<Object> enumeration = driverGroup2.getProperties().elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (DriverProperty)enumeration.nextElement();
                ((DriverProperty)cloneable).setGroup(driverGroup);
                functionPanel = this.fModelFPMapping.get(driverGroup2.getName() + "get" + ((DriverProperty)cloneable).getName());
                functionPanel.setClassName("parent");
                ((DriverProperty)cloneable).setGetCodeToEvaluate(functionPanel.getPropertyGetMCode());
                functionPanel = this.fModelFPMapping.get(driverGroup2.getName() + "set" + ((DriverProperty)cloneable).getName());
                if (functionPanel != null) {
                    functionPanel.setClassName("parent");
                    ((DriverProperty)cloneable).setSetCodeToEvaluate(functionPanel.getPropertySetMCode());
                }
                driverGroup.add((DriverProperty)cloneable);
            }
            enumeration = driverGroup2.getFunctions().elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (DriverFunction)enumeration.nextElement();
                ((DriverFunction)cloneable).setGroup(driverGroup);
                functionPanel = this.fModelFPMapping.get(driverGroup2.getName() + ((DriverFunction)cloneable).getName());
                functionPanel.setClassName("parent");
                ((DriverFunction)cloneable).setMCodeToEvaluate(functionPanel.getMCode(((DriverFunction)cloneable).getName().toLowerCase()));
                driverGroup.add((DriverFunction)cloneable);
            }
        }
    }
}

