/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool.panel;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDNode;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTool;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelEvent;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelListener;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.BasePanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.DriverTableModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDComboTablePanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTable;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTablePanel;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class FunctionPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private MJTabbedPane fTabbedPane;
    private HelpPanel fHelpPanel;
    private FunctionCode fCodePanel;
    DriverFunction fFunction;
    private static String[] sResponseTypes = new String[]{"None", "ASCII", "Binary", "Binblock"};
    private static String[] sCodeTypes = new String[]{"Instrument Commands", "M-Code"};

    public FunctionPanel(DriverClient driverClient) {
        super(driverClient);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fTabbedPane = new MJTabbedPane();
        this.fTabbedPane.setPreferredSize(new Dimension(20, 20));
        this.fCodePanel = new FunctionCode(driverClient);
        this.fTabbedPane.add((Component)((Object)this.fCodePanel), (Object)"Code");
        this.fHelpPanel = new HelpPanel(driverClient);
        this.fTabbedPane.add((Component)((Object)this.fHelpPanel), (Object)"Help");
        this.add((Component)this.fTabbedPane, "Center");
    }

    @Override
    public void driverDidLoad(DriverModel driverModel) {
        this.fTabbedPane.setSelectedIndex(0);
        this.fCodePanel.driverDidLoad(driverModel);
    }

    @Override
    public void updatePanel(MIDNode mIDNode) {
        this.fFunction = (DriverFunction)mIDNode.getUserData();
        this.fHelpPanel.updatePanel(mIDNode);
        this.fCodePanel.updatePanel(mIDNode);
    }

    @Override
    public void updateNode(MIDNode mIDNode) {
        this.fHelpPanel.updateNode(mIDNode);
        this.fCodePanel.updateNode(mIDNode);
    }

    public class FunctionCode
    extends BasePanel
    implements ItemListener,
    DocumentListener,
    DriverModelListener {
        private static final long serialVersionUID = 1L;
        private MJComboBox fCodeSelection;
        private MJTextField fArgumentList;
        private MJPanel fInstrumentPanel;
        private MIDTable fCommandTable;
        private MIDTablePanel fCommandPanel;
        private MJLabel fFunctionDefinition;
        private Document fArgListDoc;
        private SyntaxTextPane fSyntaxPanel;
        private MJPanel fMCodePanel;
        private GridBagConstraints fCodeConstraints;
        private GridBagConstraints fInputArgConstraints;

        public FunctionCode(DriverClient driverClient) {
            super(driverClient);
            this.layoutPanel();
        }

        private void layoutPanel() {
            this.setLayout(new BorderLayout());
            this.fInstrumentPanel = new MJPanel((LayoutManager)new GridBagLayout());
            this.fInputArgConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 1, 0, 1), 0, 0);
            this.fInstrumentPanel.add((Component)this.createInputArgsPanel(), (Object)this.fInputArgConstraints);
            this.fCodeConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 1, 1, 1), 0, 0);
            this.fCommandTable = this.createCommandTable();
            this.fCommandPanel = new MIDComboTablePanel(this.fCommandTable, "Function commands");
            this.fCommandPanel.setEntryLabelText("Add command:");
            this.fCommandPanel.setPreferredSize(new Dimension(20, 20));
            this.fCommandPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FunctionCode.this.commandTableEvent(actionEvent);
                }
            });
            this.fInstrumentPanel.add((Component)((Object)this.fCommandPanel), (Object)this.fCodeConstraints);
            this.add((Component)this.fInstrumentPanel, "Center");
            this.add((Component)this.createCodeSelectionPanel(), "North");
            this.fMCodePanel = this.createMCodePanel();
        }

        private MJPanel createCodeSelectionPanel() {
            MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(0));
            mJPanel.add((Component)new MJLabel("Function style:"));
            this.fCodeSelection = new MJComboBox((Object[])sCodeTypes);
            this.fCodeSelection.addItemListener((ItemListener)this);
            mJPanel.add((Component)this.fCodeSelection);
            return mJPanel;
        }

        private MJPanel createInputArgsPanel() {
            MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
            mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Function definition"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0);
            this.fFunctionDefinition = new MJLabel("");
            mJPanel.add((Component)this.fFunctionDefinition, (Object)gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0);
            mJPanel.add((Component)new MJLabel("Input arguments:"), (Object)gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            this.fArgumentList = new MJTextField();
            this.fArgListDoc = this.fArgumentList.getDocument();
            this.fArgListDoc.addDocumentListener(this);
            mJPanel.add((Component)this.fArgumentList, (Object)gridBagConstraints);
            return mJPanel;
        }

        private MIDTable createCommandTable() {
            MIDTable mIDTable = new MIDTable(new CommandTableModel());
            mIDTable.setRowSelectionAllowed(true);
            this.setDefaultColumnSizes(mIDTable);
            TableColumnModel tableColumnModel = mIDTable.getColumnModel();
            tableColumnModel.getColumn(2).setCellEditor(new OutputTypeCellEditor(new JComboBox<String>(sResponseTypes)));
            tableColumnModel.getColumn(2).setCellRenderer(new OutputTypeCellRenderer());
            tableColumnModel.getColumn(3).setCellEditor(new OutputFormatCellEditor(new JComboBox()));
            tableColumnModel.getColumn(3).setCellRenderer(new OutputFormatCellRenderer());
            return mIDTable;
        }

        private MJPanel createMCodePanel() {
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel.setBorder((Border)BorderFactory.createTitledBorder("MATLAB code"));
            this.fSyntaxPanel = new SyntaxTextPane();
            this.fSyntaxPanel.setContentType(MLanguage.M_MIME_TYPE);
            mJPanel.add((Component)SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.fSyntaxPanel), (Object)"Center");
            return mJPanel;
        }

        private void setDefaultColumnSizes(JTable jTable) {
            TableColumn tableColumn = this.initColumnSize(jTable, 0);
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() * 3 / 2);
            tableColumn.setMaxWidth(tableColumn.getPreferredWidth() * 2);
            tableColumn = this.initColumnSize(jTable, 2);
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() * 2);
            tableColumn.setMaxWidth(tableColumn.getPreferredWidth() * 3);
            tableColumn = this.initColumnSize(jTable, 3);
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() * 2);
            tableColumn.setMaxWidth(tableColumn.getPreferredWidth() * 3);
        }

        @Override
        public void driverDidLoad(DriverModel driverModel) {
            FunctionPanel.this.fTabbedPane.setSelectedIndex(0);
            if (driverModel.getDriverType() == 0) {
                this.fCodeSelection.removeAllItems();
                this.fCodeSelection.addItem((Object)sCodeTypes[0]);
                this.fCodeSelection.addItem((Object)sCodeTypes[1]);
                this.fCodeSelection.setEnabled(true);
            } else {
                this.fCodeSelection.removeAllItems();
                this.fCodeSelection.addItem((Object)sCodeTypes[1]);
                this.fCodeSelection.setEnabled(false);
            }
        }

        @Override
        public void updatePanel(MIDNode mIDNode) {
            FunctionPanel.this.fFunction.addDriverModelListener(this);
            this.fCodeSelection.setSelectedItem((Object)sCodeTypes[FunctionPanel.this.fFunction.getCodeType()]);
            Vector<String> vector = FunctionPanel.this.fFunction.getInputs();
            this.fArgumentList.setText("");
            this.updateFunctionDefinition();
            if (vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    try {
                        this.fArgumentList.getDocument().insertString(this.fArgumentList.getDocument().getLength(), vector.get(i), null);
                        if (i >= vector.size() - 1) continue;
                        this.fArgumentList.getDocument().insertString(this.fArgumentList.getDocument().getLength(), ", ", null);
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            this.fSyntaxPanel.setText(FunctionPanel.this.fFunction.getMCodeToEvaluate());
            this.fSyntaxPanel.discardAllUndoEdits();
            this.fSyntaxPanel.selectAll();
            this.fSyntaxPanel.setCaretPosition(0);
            this.fCommandTable.clearSelection();
            this.fCommandPanel.updateButtonState();
            this.fCommandPanel.setEntryText("");
        }

        @Override
        public void updateNode(MIDNode mIDNode) {
            FunctionPanel.this.fFunction.removeDriverModelListener(this);
            this.fCommandTable.stopEditing();
            if (this.fCodeSelection.getSelectedItem().equals(sCodeTypes[1])) {
                FunctionPanel.this.fFunction.setCodeType(1);
            } else {
                FunctionPanel.this.fFunction.setCodeType(0);
            }
            Vector<String> vector = new Vector<String>();
            String string = this.fArgumentList.getText();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                vector.add(string2.trim());
            }
            FunctionPanel.this.fFunction.setInputs(vector);
            FunctionPanel.this.fFunction.setMCodeToEvaluate(this.fSyntaxPanel.getText());
        }

        @Override
        public void driverStateChanged(DriverModelEvent driverModelEvent) {
            if (driverModelEvent.getType() == 13 && FunctionPanel.this.fFunction == (DriverFunction)driverModelEvent.getSource()) {
                int n = this.fSyntaxPanel.getCaretPosition() <= FunctionPanel.this.fFunction.getMCodeToEvaluate().length() ? this.fSyntaxPanel.getCaretPosition() : 0;
                this.fSyntaxPanel.setText(FunctionPanel.this.fFunction.getMCodeToEvaluate());
                this.fSyntaxPanel.discardAllUndoEdits();
                this.fSyntaxPanel.setCaretPosition(n);
            }
        }

        protected void commandTableEvent(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.fCommandTable.stopEditing();
            this.fCommandTable.stopEditing();
            switch (Integer.decode(string)) {
                case 1: {
                    String string2 = this.fCommandPanel.getEntryText();
                    if (string2.length() == 0) break;
                    FunctionPanel.this.fFunction.addCommand(string2, "None", "N/A");
                    ((AbstractTableModel)this.fCommandTable.getModel()).fireTableDataChanged();
                    this.fCommandTable.ensureRowIsVisible(this.fCommandTable.getRowCount() - 1);
                    break;
                }
                case 2: {
                    if (!this.fCommandTable.willDeleteBasedOnSelection(true)) break;
                    int[] nArray = this.fCommandTable.getMultipleRowSelctionIndices();
                    this.fCommandTable.clearSelection();
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        FunctionPanel.this.fFunction.removeCommand(nArray[i]);
                    }
                    ((AbstractTableModel)this.fCommandTable.getModel()).fireTableDataChanged();
                    this.fCommandTable.setSelectionBasedOnIndex(nArray[0]);
                    break;
                }
                case 4: {
                    if (!this.fCommandTable.willMoveRowBasedOnSelection(false)) break;
                    int n = this.fCommandTable.getSelectedRow();
                    ((CommandTableModel)this.fCommandTable.getModel()).exchangeRows(n, n + 1);
                    ((AbstractTableModel)this.fCommandTable.getModel()).fireTableDataChanged();
                    this.fCommandTable.setRowSelectionInterval(n + 1, n + 1);
                    break;
                }
                case 3: {
                    if (!this.fCommandTable.willMoveRowBasedOnSelection(true)) break;
                    int n = this.fCommandTable.getSelectedRow();
                    ((CommandTableModel)this.fCommandTable.getModel()).exchangeRows(n, n - 1);
                    ((AbstractTableModel)this.fCommandTable.getModel()).fireTableDataChanged();
                    this.fCommandTable.setRowSelectionInterval(n - 1, n - 1);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                return;
            }
            if (this.fCodeSelection.getSelectedItem() == sCodeTypes[0]) {
                this.remove((Component)this.fMCodePanel);
                this.add((Component)this.fInstrumentPanel, "Center");
            } else {
                this.remove((Component)this.fInstrumentPanel);
                this.add((Component)this.fMCodePanel, "Center");
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == this.fArgListDoc) {
                this.updateFunctionDefinition();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == this.fArgListDoc) {
                this.updateFunctionDefinition();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == this.fArgListDoc) {
                this.updateFunctionDefinition();
            }
        }

        private void updateFunctionDefinition() {
            this.fFunctionDefinition.setText("Current definition: " + FunctionPanel.this.fFunction.getName() + "(" + this.fArgumentList.getText() + ")");
        }

        public class OutputFormatCellEditor
        extends DefaultCellEditor {
            private static final long serialVersionUID = 1L;
            public String[] kAsciiFormats;
            public String[] kBinaryFormats;
            String lastResponse;

            public OutputFormatCellEditor(JComboBox jComboBox) {
                super(jComboBox);
                this.kAsciiFormats = new String[]{"text", "numeric"};
                this.kBinaryFormats = new String[]{"int8", "int16", "int32", "uint8", "uint16", "uint32", "float", "double"};
                this.lastResponse = "";
                jComboBox.setBorder(null);
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                JComboBox jComboBox = (JComboBox)this.getComponent();
                String string = (String)jTable.getValueAt(n, 2);
                if (!this.lastResponse.equalsIgnoreCase(string)) {
                    String[] stringArray;
                    jComboBox.removeAllItems();
                    if (string.equalsIgnoreCase("ascii")) {
                        stringArray = this.kAsciiFormats;
                    } else if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("binblock")) {
                        stringArray = this.kBinaryFormats;
                    } else {
                        return jComboBox;
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        jComboBox.addItem(stringArray[i]);
                    }
                    this.lastResponse = string;
                }
                return jComboBox;
            }
        }

        public class OutputFormatCellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;
            JComboBox box;

            public OutputFormatCellRenderer() {
                String[] stringArray = new String[]{"N/A", "text", "numeric", "int8", "int16", "int32", "uint8", "uint16", "uint32", "float", "double"};
                this.box = new JComboBox<String>(stringArray);
                this.box.setBorder(null);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.box.setEnabled(jTable.isCellEditable(n, n2));
                this.box.setSelectedItem(object);
                return this.box;
            }
        }

        private class OutputTypeCellEditor
        extends DefaultCellEditor
        implements ItemListener {
            private static final long serialVersionUID = 1L;
            JComboBox box;

            public OutputTypeCellEditor(JComboBox jComboBox) {
                super(jComboBox);
                this.box = jComboBox;
                this.box.setBorder(null);
                this.box.addItemListener(this);
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                itemEvent.getSource();
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.box.setSelectedItem(object);
                return this.box;
            }
        }

        public class OutputTypeCellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;
            JComboBox box;

            public OutputTypeCellRenderer() {
                String[] stringArray = new String[]{"None", "ASCII", "Binary", "Binblock"};
                this.box = new JComboBox<String>(stringArray);
                this.box.setBorder(null);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.box.setSelectedItem(object);
                return this.box;
            }
        }

        public class CommandTableModel
        extends DriverTableModel {
            private static final long serialVersionUID = 1L;
            private final String[] sHeaders = new String[]{"Index", "Command", "Output", "Format"};

            @Override
            public void exchangeRows(int n, int n2) {
                String string = FunctionPanel.this.fFunction.getCommand(n);
                String string2 = FunctionPanel.this.fFunction.getOutputType(n);
                String string3 = FunctionPanel.this.fFunction.getOutputFormat(n);
                String string4 = FunctionPanel.this.fFunction.getCommand(n2);
                String string5 = FunctionPanel.this.fFunction.getOutputType(n2);
                String string6 = FunctionPanel.this.fFunction.getOutputFormat(n2);
                FunctionPanel.this.fFunction.setCommand(string4, n);
                FunctionPanel.this.fFunction.setOutputType(string5, n);
                FunctionPanel.this.fFunction.setOutputFormat(string6, n);
                FunctionPanel.this.fFunction.setCommand(string, n2);
                FunctionPanel.this.fFunction.setOutputType(string2, n2);
                FunctionPanel.this.fFunction.setOutputFormat(string3, n2);
            }

            @Override
            public String getColumnName(int n) {
                return this.sHeaders[n];
            }

            @Override
            public int getRowCount() {
                if (FunctionPanel.this.fFunction == null) {
                    return 0;
                }
                return FunctionPanel.this.fFunction.getCommandCount();
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                Object object = null;
                if (FunctionPanel.this.fFunction != null) {
                    switch (n2) {
                        case 0: {
                            object = new Integer(n + 1);
                            break;
                        }
                        case 1: {
                            object = FunctionPanel.this.fFunction.getCommand(n);
                            break;
                        }
                        case 2: {
                            object = FunctionPanel.this.fFunction.getOutputType(n);
                            break;
                        }
                        case 3: {
                            object = FunctionPanel.this.fFunction.getOutputFormat(n);
                        }
                    }
                }
                return object;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (FunctionPanel.this.fFunction != null) {
                    switch (n2) {
                        case 0: {
                            try {
                                int n3 = Integer.parseInt((String)object);
                                int n4 = this.moveRow(n, n3 - 1);
                                this.fireTableDataChanged();
                                FunctionCode.this.fCommandTable.setRowSelectionInterval(n4, n4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                MJOptionPane.showMessageDialog((Component)FunctionCode.this.fDriverClient.getBrowserFrame(), (Object)("The index must be an integer between 1 and " + this.getRowCount() + " ."), (String)"Index Error", (int)0);
                            }
                            break;
                        }
                        case 1: {
                            FunctionPanel.this.fFunction.setCommand(object, n);
                            break;
                        }
                        case 2: {
                            FunctionPanel.this.fFunction.setOutputType(object, n);
                            this.fireTableDataChanged();
                            break;
                        }
                        case 3: {
                            FunctionPanel.this.fFunction.setOutputFormat(object, n);
                        }
                    }
                }
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (n2 == 3) {
                    String string = (String)this.getValueAt(n, 2);
                    return !string.equalsIgnoreCase("none");
                }
                return true;
            }
        }
    }

    public class HelpPanel
    extends BasePanel {
        private static final long serialVersionUID = 1L;
        private MJTextArea fDescription;

        public HelpPanel(DriverClient driverClient) {
            super(driverClient);
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.setLayout(new BorderLayout());
            this.add((Component)new MJLabel("Help text:"), "North");
            this.fDescription = new MJTextArea();
            this.fDescription.setColumns(20);
            this.fDescription.setRows(1);
            this.fDescription.setLineWrap(true);
            this.fDescription.setWrapStyleWord(true);
            this.fDescription.setMargin(new Insets(2, 2, 2, 2));
            this.fDescription.setForeground(MIDTool.getMCommentColor());
            this.fDescription.setTabSize(4);
            this.fDescription.setDragEnabled(true);
            this.add((Component)new MJScrollPane((Component)this.fDescription), "Center");
        }

        @Override
        public void updatePanel(MIDNode mIDNode) {
            this.fDescription.setText(FunctionPanel.this.fFunction.getDescription());
            this.fDescription.setCaretPosition(0);
        }

        @Override
        public void updateNode(MIDNode mIDNode) {
            FunctionPanel.this.fFunction.setDescription(this.fDescription.getText());
        }
    }
}

