/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import com.sun.jini.action.GetBooleanAction;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.jeri.internal.runtime.WeakKey;
import com.sun.jini.logging.Levels;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.ExportException;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.io.MarshalInputStream;
import net.jini.io.MarshalOutputStream;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.ServerCapabilities;
import net.jini.security.proxytrust.ProxyTrust;
import net.jini.security.proxytrust.ServerProxyTrust;

public class BasicInvocationDispatcher
implements InvocationDispatcher {
    static final byte VERSION = 0;
    static final byte MISMATCH = 0;
    static final byte RETURN = 1;
    static final byte THROW = 2;
    private final ClassLoader loader;
    private final MethodConstraints serverConstraints;
    private final Constructor permConstructor;
    private final boolean permUsesMethod;
    private final Map permissions;
    private final Map methods;
    private static final Map domains = new HashMap();
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static final Logger logger = Logger.getLogger("net.jini.jeri.BasicInvocationDispatcher");
    private static final boolean suppressStackTraces = (Boolean)AccessController.doPrivileged(new GetBooleanAction("com.sun.jini.jeri.server.suppressStackTraces"));
    private static final CodeSource emptyCS = new CodeSource(null, (Certificate[])null);
    private static final ProtectionDomain emptyPD = new ProtectionDomain(emptyCS, null, null, null);
    private static final Permission getClassLoaderPermission = new RuntimePermission("getClassLoader");

    public BasicInvocationDispatcher(Collection collection, ServerCapabilities serverCapabilities, MethodConstraints methodConstraints, Class clazz, ClassLoader classLoader) throws ExportException {
        if (serverCapabilities == null) {
            throw new NullPointerException();
        }
        this.methods = new HashMap();
        this.loader = classLoader;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) {
                throw new NullPointerException("methods contains null");
            }
            if (!(e instanceof Method)) {
                throw new IllegalArgumentException("methods must contain only Methods");
            }
            this.methods.put(new Long(Util.getMethodHash((Method)e)), e);
        }
        this.serverConstraints = methodConstraints;
        if (clazz != null) {
            Util.checkPackageAccess(clazz);
        }
        this.permConstructor = BasicInvocationDispatcher.getConstructor(clazz);
        this.permUsesMethod = this.permConstructor != null && this.permConstructor.getParameterTypes()[0] == Method.class;
        this.permissions = this.permConstructor == null ? null : new IdentityHashMap(collection.size() + 2);
        try {
            if (methodConstraints == null) {
                BasicInvocationDispatcher.checkConstraints(serverCapabilities, InvocationConstraints.EMPTY);
            } else {
                iterator = methodConstraints.possibleConstraints();
                while (iterator.hasNext()) {
                    BasicInvocationDispatcher.checkConstraints(serverCapabilities, (InvocationConstraints)iterator.next());
                }
            }
        }
        catch (UnsupportedConstraintException unsupportedConstraintException) {
            throw new ExportException("server does not support some constraints", unsupportedConstraintException);
        }
    }

    private static void checkConstraints(ServerCapabilities serverCapabilities, InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        InvocationConstraints invocationConstraints2 = serverCapabilities.checkConstraints(invocationConstraints);
        Iterator iterator = invocationConstraints2.requirements().iterator();
        while (iterator.hasNext()) {
            InvocationConstraint invocationConstraint = (InvocationConstraint)iterator.next();
            if (invocationConstraint instanceof Integrity) continue;
            throw new UnsupportedConstraintException("cannot satisfy unfulfilled constraint: " + invocationConstraint);
        }
    }

    protected final ClassLoader getClassLoader() {
        return this.loader;
    }

    public static void checkPermissionClass(Class clazz) {
        BasicInvocationDispatcher.getConstructor(clazz);
    }

    private static Constructor getConstructor(Class clazz) {
        Constructor constructor;
        if (clazz == null) {
            return null;
        }
        int n = clazz.getModifiers();
        if (!Permission.class.isAssignableFrom(clazz) || Modifier.isAbstract(n) || !Modifier.isPublic(n)) {
            throw new IllegalArgumentException("bad permission class");
        }
        try {
            constructor = clazz.getConstructor(Method.class);
            if (constructor.getExceptionTypes().length == 0) {
                return constructor;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            constructor = clazz.getConstructor(String.class);
            if (constructor.getExceptionTypes().length == 0) {
                return constructor;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new IllegalArgumentException("bad permission class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Remote remote, InboundRequest inboundRequest, Collection collection) {
        block50: {
            Object object;
            boolean bl;
            if (remote == null || collection == null) {
                throw new NullPointerException();
            }
            InputStream inputStream = null;
            try {
                inputStream = inboundRequest.getRequestInputStream();
                switch (inputStream.read()) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        throw new EOFException();
                    }
                    default: {
                        inputStream.close();
                        OutputStream outputStream = inboundRequest.getResponseOutputStream();
                        outputStream.write(0);
                        outputStream.write(0);
                        outputStream.close();
                        return;
                    }
                }
                switch (inputStream.read()) {
                    case 0: {
                        bl = false;
                        break;
                    }
                    case -1: {
                        throw new EOFException();
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                if (logger.isLoggable(Levels.FAILED)) {
                    this.logThrow(remote, throwable);
                }
                inboundRequest.abort();
                return;
            }
            Method method = null;
            Object object2 = null;
            Throwable throwable = null;
            boolean bl2 = false;
            Util.populateContext(collection, bl);
            ObjectInputStream objectInputStream = null;
            try {
                Serializable serializable;
                objectInputStream = this.createMarshalInputStream(remote, inboundRequest, bl, collection);
                method = this.unmarshalMethod(remote, objectInputStream, collection);
                Object object3 = object = this.serverConstraints == null ? InvocationConstraints.EMPTY : this.serverConstraints.getConstraints(method);
                if (bl && !((InvocationConstraints)object).requirements().contains(Integrity.YES)) {
                    serializable = new ArrayList(((InvocationConstraints)object).requirements());
                    serializable.add(Integrity.YES);
                    object = new InvocationConstraints((Collection)((Object)serializable), ((InvocationConstraints)object).preferences());
                }
                serializable = inboundRequest.checkConstraints((InvocationConstraints)object);
                Object[] objectArray = ((InvocationConstraints)serializable).requirements().iterator();
                while (objectArray.hasNext()) {
                    InvocationConstraint invocationConstraint = (InvocationConstraint)objectArray.next();
                    if (invocationConstraint instanceof Integrity && (bl || invocationConstraint != Integrity.YES)) continue;
                    throw new UnsupportedConstraintException("cannot satisfy unfulfilled constraint: " + invocationConstraint);
                }
                this.checkAccess(remote, method, (InvocationConstraints)object, collection);
                objectArray = this.unmarshalArguments(remote, method, objectInputStream, collection);
                if (logger.isLoggable(Level.FINE)) {
                    this.logCall(remote, method, objectArray);
                }
                try {
                    object2 = this.invoke(remote, method, objectArray, collection);
                    if (logger.isLoggable(Level.FINE)) {
                        this.logReturn(remote, method, object2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    bl2 = true;
                }
            }
            catch (RuntimeException runtimeException) {
                throwable = runtimeException;
            }
            catch (Exception exception) {
                throwable = new UnmarshalException("unmarshalling method/arguments", exception);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                inboundRequest.getResponseOutputStream().write(throwable == null ? 1 : 2);
                object = this.createMarshalOutputStream(remote, method, inboundRequest, collection);
                if (throwable != null) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        this.logThrow(remote, method, throwable, bl2);
                    }
                    if (throwable instanceof RemoteException) {
                        throwable = new ServerException("RemoteException in server thread", (Exception)throwable);
                    } else if (throwable instanceof Error) {
                        throwable = new ServerError("Error in server thread", (Error)throwable);
                    }
                    if (suppressStackTraces) {
                        Util.clearStackTraces(throwable);
                    }
                    this.marshalThrow(remote, method, throwable, (ObjectOutputStream)object, collection);
                } else {
                    this.marshalReturn(remote, method, object2, (ObjectOutputStream)object, collection);
                }
                ((ObjectOutputStream)object).close();
            }
            catch (Throwable throwable4) {
                try {
                    inboundRequest.getResponseOutputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                inboundRequest.abort();
                if (!logger.isLoggable(Levels.FAILED)) break block50;
                this.logThrow(remote, throwable4);
            }
        }
    }

    protected ObjectInputStream createMarshalInputStream(Object object, InboundRequest inboundRequest, boolean bl, Collection collection) throws IOException {
        Object object2;
        ClassLoader classLoader;
        if (this.loader != null) {
            classLoader = this.getClassLoader();
        } else {
            object2 = System.getSecurityManager();
            if (object2 != null) {
                ((SecurityManager)object2).checkPermission(getClassLoaderPermission);
            }
            classLoader = object.getClass().getClassLoader();
        }
        object2 = Collections.unmodifiableCollection(collection);
        MarshalInputStream marshalInputStream = new MarshalInputStream(inboundRequest.getRequestInputStream(), classLoader, bl, classLoader, (Collection)object2);
        marshalInputStream.useCodebaseAnnotations();
        return marshalInputStream;
    }

    protected ObjectOutputStream createMarshalOutputStream(Object object, Method method, InboundRequest inboundRequest, Collection collection) throws IOException {
        if (object == null) {
            throw new NullPointerException();
        }
        OutputStream outputStream = inboundRequest.getResponseOutputStream();
        Collection collection2 = Collections.unmodifiableCollection(collection);
        return new MarshalOutputStream(outputStream, collection2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAccess(Remote remote, Method method, InvocationConstraints invocationConstraints, Collection collection) {
        Permission permission;
        if (remote == null || method == null || collection == null) {
            throw new NullPointerException();
        }
        if (this.permConstructor == null) {
            return;
        }
        Map map = this.permissions;
        synchronized (map) {
            permission = (Permission)this.permissions.get(method);
        }
        if (permission == null) {
            try {
                permission = (Permission)this.permConstructor.newInstance(this.permUsesMethod ? method : method.getDeclaringClass().getName() + "." + method.getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw (RuntimeException)throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException("unexpected exception", exception);
            }
            map = this.permissions;
            synchronized (map) {
                this.permissions.put(method, permission);
            }
        }
        BasicInvocationDispatcher.checkClientPermission(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkClientPermission(Permission permission) {
        ProtectionDomain protectionDomain;
        if (permission == null) {
            throw new NullPointerException();
        }
        Subject subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Util.getClientSubject();
                }
                catch (ServerNotActiveException serverNotActiveException) {
                    throw new IllegalStateException("server not active");
                }
            }
        });
        if (System.getSecurityManager() == null) {
            return;
        }
        if (subject == null) {
            protectionDomain = emptyPD;
        } else {
            Map map = domains;
            synchronized (map) {
                WeakKey weakKey;
                while ((weakKey = (WeakKey)queue.poll()) != null) {
                    domains.remove(weakKey);
                }
                protectionDomain = (ProtectionDomain)domains.get(new WeakKey(subject));
                if (protectionDomain == null) {
                    Set<Principal> set = subject.getPrincipals();
                    Principal[] principalArray = set.toArray(new Principal[set.size()]);
                    protectionDomain = new ProtectionDomain(emptyCS, null, null, principalArray);
                    domains.put(new WeakKey(subject, queue), protectionDomain);
                }
            }
        }
        boolean bl = protectionDomain.implies(permission);
        if (!bl) {
            throw new AccessControlException("access denied " + permission);
        }
    }

    protected Method unmarshalMethod(Remote remote, ObjectInputStream objectInputStream, Collection collection) throws IOException, NoSuchMethodException, ClassNotFoundException {
        if (remote == null || collection == null) {
            throw new NullPointerException();
        }
        long l = objectInputStream.readLong();
        Method method = (Method)this.methods.get(new Long(l));
        if (method == null) {
            throw new NoSuchMethodException("invalid method hash");
        }
        return method;
    }

    protected Object[] unmarshalArguments(Remote remote, Method method, ObjectInputStream objectInputStream, Collection collection) throws IOException, ClassNotFoundException {
        if (remote == null || objectInputStream == null || collection == null) {
            throw new NullPointerException();
        }
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = Util.unmarshalValue(classArray[i], objectInputStream);
        }
        return objectArray;
    }

    protected Object invoke(Remote remote, Method method, Object[] objectArray, Collection collection) throws Throwable {
        if (remote == null || objectArray == null || collection == null) {
            throw new NullPointerException();
        }
        if (!(method.isAccessible() || Modifier.isPublic(method.getDeclaringClass().getModifiers()) && Modifier.isPublic(method.getModifiers()))) {
            throw new IllegalArgumentException("method not public or set accessible");
        }
        Class<?> clazz = method.getDeclaringClass();
        if (clazz == ProxyTrust.class && method.getName().equals("getProxyVerifier") && remote instanceof ServerProxyTrust) {
            if (objectArray.length != 0) {
                throw new IllegalArgumentException("incorrect arguments");
            }
            return ((ServerProxyTrust)((Object)remote)).getProxyVerifier();
        }
        try {
            return method.invoke((Object)remote, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    protected void marshalReturn(Remote remote, Method method, Object object, ObjectOutputStream objectOutputStream, Collection collection) throws IOException {
        if (remote == null || objectOutputStream == null || collection == null) {
            throw new NullPointerException();
        }
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            Util.marshalValue(clazz, object, objectOutputStream);
        }
    }

    protected void marshalThrow(Remote remote, Method method, Throwable throwable, ObjectOutputStream objectOutputStream, Collection collection) throws IOException {
        if (remote == null || throwable == null || collection == null) {
            throw new NullPointerException();
        }
        objectOutputStream.writeObject(throwable);
    }

    private void logCall(Remote remote, Method method, Object[] objectArray) {
        Subject subject;
        String string = "inbound call {0}.{1} to {2} from {3}\nclient {4}";
        if (logger.isLoggable(Level.FINEST)) {
            string = "inbound call {0}.{1} to {2} from {3}\nargs {5}\nclient {4}";
        }
        Set<Principal> set = (subject = BasicInvocationDispatcher.getClientSubject()) != null ? subject.getPrincipals() : null;
        String string2 = null;
        try {
            string2 = Util.getClientHostString();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        logger.log(Level.FINE, string, new Object[]{method.getDeclaringClass().getName(), method.getName(), remote, string2, set, Arrays.asList(objectArray)});
    }

    private void logReturn(Remote remote, Method method, Object object) {
        String string = "inbound call {0}.{1} to {2} returns";
        if (logger.isLoggable(Level.FINEST) && method.getReturnType() != Void.TYPE) {
            string = "inbound call {0}.{1} to {2} returns {3}";
        }
        logger.logp(Level.FINE, this.getClass().getName(), "dispatch", string, new Object[]{method.getDeclaringClass().getName(), method.getName(), remote, object});
    }

    private void logThrow(Remote remote, Method method, Throwable throwable, boolean bl) {
        LogRecord logRecord = new LogRecord(Levels.FAILED, bl ? "inbound call {0}.{1} to {2} remotely throws" : (logger.isLoggable(Level.FINEST) ? "inbound call {0}.{1} to {2} dispatch remotely throws\nclient {3}" : "inbound call {0}.{1} to {2} dispatch remotely throws"));
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(this.getClass().getName());
        logRecord.setSourceMethodName("dispatch");
        logRecord.setParameters(new Object[]{method == null ? "<unknown>" : method.getDeclaringClass().getName(), method == null ? "<unknown>" : method.getName(), remote, BasicInvocationDispatcher.getClientSubject()});
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    private void logThrow(Remote remote, Throwable throwable) {
        LogRecord logRecord = new LogRecord(Levels.FAILED, logger.isLoggable(Level.FINEST) ? "{0} locally throws\nclient {1}" : "{0} locally throws");
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(this.getClass().getName());
        logRecord.setSourceMethodName("dispatch");
        logRecord.setParameters(new Object[]{remote, BasicInvocationDispatcher.getClientSubject()});
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    private static Subject getClientSubject() {
        return (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Util.getClientSubject();
                }
                catch (ServerNotActiveException serverNotActiveException) {
                    return null;
                }
            }
        });
    }
}

