/*
 * Decompiled with CFR 0.152.
 */
package net.jini.loader.pref;

import com.sun.jini.loader.pref.internal.PreferredResources;
import com.sun.jini.logging.Levels;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.loader.ClassAnnotation;
import net.jini.loader.DownloadPermission;
import net.jini.loader.pref.PreferredFactoryClassLoader;

public class PreferredClassLoader
extends URLClassLoader
implements ClassAnnotation {
    private static final String PREF_NAME = "META-INF/PREFERRED.LIST";
    private ClassLoader parent;
    private String exportAnnotation;
    private Permissions permissions;
    private PreferredResources preferredResources;
    private AccessControlContext acc;
    private boolean createAttempted = false;
    private boolean preferredInactive = false;
    private boolean requireDlPerm = false;
    private static final Permission downloadPermission = new DownloadPermission();
    private static final Logger preferredLogger = Logger.getLogger("net.jini.loader.pref.PreferredClassLoader.preferred");
    private static final Logger exceptionLogger = Logger.getLogger("net.jini.loader.pref.PreferredClassLoader.exception");
    private static final Set existSet = new HashSet(11);

    public PreferredClassLoader(URL[] uRLArray, ClassLoader classLoader, String string, boolean bl) {
        this(uRLArray, classLoader, string, bl, false);
    }

    PreferredClassLoader(URL[] uRLArray, ClassLoader classLoader, String string, boolean bl, boolean bl2) {
        super(uRLArray, classLoader);
        this.parent = classLoader;
        this.exportAnnotation = string;
        this.requireDlPerm = bl;
        this.preferredInactive = bl2;
        this.acc = AccessController.getContext();
        this.permissions = new Permissions();
        PreferredClassLoader.addPermissionsForURLs(uRLArray, this.permissions, false);
        if (this.exportAnnotation == null) {
            this.exportAnnotation = PreferredClassLoader.urlsToPath(uRLArray);
        }
    }

    static String urlsToPath(URL[] uRLArray) {
        if (uRLArray.length == 0) {
            return null;
        }
        if (uRLArray.length == 1) {
            return uRLArray[0].toExternalForm();
        }
        StringBuffer stringBuffer = new StringBuffer(uRLArray[0].toExternalForm());
        for (int i = 1; i < uRLArray.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(uRLArray[i].toExternalForm());
        }
        return stringBuffer.toString();
    }

    public static PreferredClassLoader newInstance(final URL[] uRLArray, final ClassLoader classLoader, final String string, final boolean bl) {
        Permissions permissions = new Permissions();
        PreferredClassLoader.addPermissionsForURLs(uRLArray, permissions, false);
        PreferredClassLoader.checkPermissions(permissions);
        AccessControlContext accessControlContext = PreferredClassLoader.getLoaderAccessControlContext(uRLArray);
        return (PreferredClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new PreferredFactoryClassLoader(uRLArray, classLoader, string, bl);
            }
        }, accessControlContext);
    }

    private void createPreferred() throws IOException {
        URL[] uRLArray = this.getURLs();
        InputStream inputStream = null;
        if (uRLArray.length > 0 && uRLArray[0] != null) {
            block5: {
                String string = uRLArray[0].toString();
                try {
                    inputStream = this.getPreferredInputStream(string);
                }
                catch (IOException iOException) {
                    if (!string.startsWith("file:") && !(iOException instanceof FileNotFoundException)) {
                        throw iOException;
                    }
                    if (!exceptionLogger.isLoggable(Levels.HANDLED)) break block5;
                    this.logException(iOException, string);
                }
            }
            if (inputStream != null) {
                this.preferredResources = new PreferredResources(inputStream);
            }
        }
    }

    private InputStream getPreferredInputStream(String string) throws IOException {
        String string2 = null;
        URLConnection uRLConnection = null;
        InputStream inputStream = null;
        if (string.endsWith("/")) {
            string2 = string + PREF_NAME;
            uRLConnection = this.getPreferredConnection(string2, false);
            if (uRLConnection != null) {
                inputStream = uRLConnection.getInputStream();
            }
        } else if (this.jarExists(string)) {
            string2 = "jar:" + string + "!/" + PREF_NAME;
            uRLConnection = this.getPreferredConnection(string2, false);
        }
        if (uRLConnection != null) {
            inputStream = uRLConnection.getInputStream();
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jarExists(String string) throws IOException {
        boolean bl;
        Set set = existSet;
        synchronized (set) {
            bl = existSet.contains(string);
        }
        if (!bl) {
            boolean bl2 = bl = this.getPreferredConnection(string, true) != null;
            if (bl) {
                set = existSet;
                synchronized (set) {
                    existSet.add(string);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URLConnection getPreferredConnection(String string, boolean bl) throws IOException {
        Object var3_3 = null;
        URL uRL = new URL(string);
        if (string.startsWith("file:")) {
            return uRL.openConnection();
        }
        URLConnection uRLConnection = null;
        URLConnection uRLConnection2 = null;
        try {
            uRLConnection2 = uRLConnection = uRL.openConnection();
            if (!(uRLConnection2 instanceof HttpURLConnection)) return uRLConnection2;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection2;
            if (bl) {
                httpURLConnection.setRequestMethod("HEAD");
            }
            int n = httpURLConnection.getResponseCode();
            switch (n) {
                case 200: 
                case 203: {
                    return uRLConnection2;
                }
                case 403: 
                case 404: 
                case 410: {
                    uRLConnection2 = null;
                    return uRLConnection2;
                }
                default: {
                    throw new IOException("Indefinite http response for preferred list request:" + httpURLConnection.getResponseMessage());
                }
            }
        }
        finally {
            if (bl && uRLConnection != null) {
                try {
                    uRLConnection.getInputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void logException(IOException iOException, String string) {
        String string2 = string.endsWith("/") ? string + PREF_NAME : "jar:" + string + "!/" + PREF_NAME;
        exceptionLogger.logp(Levels.HANDLED, this.getClass().getName(), "isPreferredResource", string2, iOException);
    }

    protected boolean isPreferredResource(final String string, final boolean bl) throws IOException {
        if (this.preferredInactive) {
            return false;
        }
        if (bl && string.startsWith("java.")) {
            return false;
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    boolean bl2 = PreferredClassLoader.this.isPreferredResource0(string, bl);
                    return bl2;
                }
            }, this.acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPreferredResource0(String string, boolean bl) throws IOException {
        Object object = this;
        synchronized (object) {
            if (!this.createAttempted) {
                this.createPreferred();
                this.createAttempted = true;
            }
            if (this.preferredResources == null) {
                return false;
            }
        }
        object = string;
        if (bl) {
            object = string.replace('.', '/') + ".class";
        }
        boolean bl2 = false;
        PreferredClassLoader preferredClassLoader = this;
        synchronized (preferredClassLoader) {
            int n = this.preferredResources.getNameState((String)object, bl);
            switch (n) {
                case 1: {
                    bl2 = false;
                    break;
                }
                case 3: {
                    bl2 = true;
                    break;
                }
                case 0: {
                    Boolean bl3 = this.preferredResources.getWildcardPreference((String)object);
                    if (bl3 == null) {
                        bl3 = this.preferredResources.getDefaultPreference();
                    }
                    if (!bl3.booleanValue()) break;
                    bl2 = this.findResourceUpdateState(string, (String)object);
                    break;
                }
                case 2: {
                    bl2 = this.findResourceUpdateState(string, (String)object);
                    if (bl2) break;
                    throw new IOException("no resource found for complete preferred name");
                }
                default: {
                    throw new Error("unknown preference state");
                }
            }
        }
        return bl2;
    }

    private boolean findResourceUpdateState(String string, String string2) throws IOException {
        boolean bl = false;
        if (this.findResource(string2) != null) {
            this.preferredResources.setNameState(string2, 3);
            bl = true;
            if (preferredLogger.isLoggable(Level.FINE)) {
                this.logPreferred(string);
            }
        }
        return bl;
    }

    private void logPreferred(String string) {
        preferredLogger.logp(Level.FINE, this.getClass().getName(), "isPreferredResource", "resource named \"{0}\" is preferred", string);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            boolean bl2;
            try {
                bl2 = this.isPreferredResource(string, true);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("Could not access preferred list for " + string, iOException);
            }
            if (bl2) {
                clazz = this.findClass(string);
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            return super.loadClass(string, bl);
        }
        return clazz;
    }

    public URL getResource(String string) {
        try {
            return this.isPreferredResource(string, false) ? this.findResource(string) : super.getResource(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        try {
            return super.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.getPackage(string);
        }
    }

    public String getClassAnnotation() {
        return this.exportAnnotation;
    }

    void checkPermissions() {
        PreferredClassLoader.checkPermissions(this.permissions);
    }

    private static void checkPermissions(Permissions permissions) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Enumeration<Permission> enumeration = permissions.elements();
            while (enumeration.hasMoreElements()) {
                securityManager.checkPermission(enumeration.nextElement());
            }
        }
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        ProtectionDomain protectionDomain;
        SecurityManager securityManager;
        if (this.requireDlPerm && (securityManager = System.getSecurityManager()) != null && !(protectionDomain = new ProtectionDomain(codeSource, null, this, null)).implies(downloadPermission)) {
            throw new SecurityException("CodeSource not permitted to define class: " + codeSource);
        }
        return super.getPermissions(codeSource);
    }

    public String toString() {
        return super.toString() + "[\"" + this.exportAnnotation + "\"]";
    }

    static AccessControlContext getLoaderAccessControlContext(URL[] uRLArray) {
        PermissionCollection permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource codeSource = new CodeSource(null, (Certificate[])null);
                Policy policy = Policy.getPolicy();
                if (policy != null) {
                    return policy.getPermissions(codeSource);
                }
                return new Permissions();
            }
        });
        permissionCollection.add(new RuntimePermission("createClassLoader"));
        permissionCollection.add(new PropertyPermission("java.*", "read"));
        PreferredClassLoader.addPermissionsForURLs(uRLArray, permissionCollection, true);
        ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(uRLArray.length > 0 ? uRLArray[0] : null, (Certificate[])null), permissionCollection);
        return new AccessControlContext(new ProtectionDomain[]{protectionDomain});
    }

    static void addPermissionsForURLs(URL[] uRLArray, PermissionCollection permissionCollection, boolean bl) {
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL = uRLArray[i];
            try {
                String string;
                Permission permission = uRL.openConnection().getPermission();
                if (permission == null) continue;
                if (permission instanceof FilePermission) {
                    string = permission.getName();
                    int n = string.lastIndexOf(File.separatorChar);
                    if (n != -1) {
                        if ((string = string.substring(0, n + 1)).endsWith(File.separator)) {
                            string = string + "-";
                        }
                        permissionCollection.add(new FilePermission(string, "read"));
                        continue;
                    }
                    permissionCollection.add(permission);
                    continue;
                }
                permissionCollection.add(permission);
                if (!bl || (string = uRL.getHost()) == null) continue;
                permissionCollection.add(new SocketPermission(string, "connect, accept"));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

