/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.Header;
import com.sun.jini.jeri.internal.http.HttpServerManager;
import com.sun.jini.jeri.internal.http.MessageReader;
import com.sun.jini.jeri.internal.http.MessageWriter;
import com.sun.jini.jeri.internal.http.Request;
import com.sun.jini.jeri.internal.http.StartLine;
import com.sun.jini.jeri.internal.http.TimedConnection;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.StringTokenizer;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.io.context.AcknowledgmentSource;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;

public abstract class HttpServerConnection
implements TimedConnection {
    private static final int HTTP_MAJOR = 1;
    private static final int HTTP_MINOR = 1;
    private static final int UNSTARTED = 0;
    private static final int IDLE = 1;
    private static final int BUSY = 2;
    private static final int CLOSED = 3;
    private static final String serverString = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return "Java/" + System.getProperty("java.version", "???") + " " + (class$com$sun$jini$jeri$internal$http$HttpServerConnection == null ? (class$com$sun$jini$jeri$internal$http$HttpServerConnection = HttpServerConnection.class$("com.sun.jini.jeri.internal.http.HttpServerConnection")) : class$com$sun$jini$jeri$internal$http$HttpServerConnection).getName();
        }
    });
    private static final Executor userThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(true));
    private final Socket sock;
    private final InputStream in;
    private final OutputStream out;
    private final RequestDispatcher dispatcher;
    private final HttpServerManager manager;
    private final Object stateLock = new Object();
    private int state = 0;
    static /* synthetic */ Class class$com$sun$jini$jeri$internal$http$HttpServerConnection;

    public HttpServerConnection(Socket socket, RequestDispatcher requestDispatcher, HttpServerManager httpServerManager) throws IOException {
        if (requestDispatcher == null) {
            throw new NullPointerException();
        }
        this.sock = socket;
        this.dispatcher = requestDispatcher;
        this.manager = httpServerManager;
        this.in = new BufferedInputStream(socket.getInputStream());
        this.out = new BufferedOutputStream(socket.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException();
            }
            this.state = 1;
            userThreadPool.execute(new Dispatcher(), "HTTP dispatcher");
        }
    }

    protected void checkPermissions() {
    }

    protected InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        if (invocationConstraints.requirements().isEmpty()) {
            return InvocationConstraints.EMPTY;
        }
        throw new UnsupportedConstraintException("cannot satisfy constraints: " + invocationConstraints);
    }

    protected abstract void populateContext(Collection var1);

    protected void idle() {
    }

    protected void busy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(boolean bl) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                return true;
            }
            if (!bl && this.state == 2) {
                return false;
            }
            this.state = 3;
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void registerAcks(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.manager.notifyAckListeners(stringTokenizer.nextToken().trim());
            }
        }
    }

    private static boolean supportsPersist(StartLine startLine, Header header) {
        if (header.containsValue("Connection", "close", true)) {
            return false;
        }
        if (header.containsValue("Connection", "Keep-Alive", true)) {
            return true;
        }
        int n = StartLine.compareVersions(startLine.major, startLine.minor, 1, 1);
        return n >= 0;
    }

    private static boolean supportsChunking(StartLine startLine, Header header) {
        int n = StartLine.compareVersions(startLine.major, startLine.minor, 1, 1);
        return n >= 0 && header.containsValue("TE", "trailers", true);
    }

    private static Header createResponseHeader(boolean bl) {
        Header header = new Header();
        long l = System.currentTimeMillis();
        header.setField("Date", Header.getDateString(l));
        header.setField("Server", serverString);
        header.setField("Connection", bl ? "Keep-Alive" : "close");
        return header;
    }

    private class InboundRequestImpl
    extends Request
    implements InboundRequest {
        private final MessageReader reader;
        private final MessageWriter writer;
        private String cookie;
        private boolean corrupt = false;

        InboundRequestImpl(MessageReader messageReader, MessageWriter messageWriter) {
            this.reader = messageReader;
            this.writer = messageWriter;
        }

        public void checkPermissions() {
            HttpServerConnection.this.checkPermissions();
        }

        public InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
            return HttpServerConnection.this.checkConstraints(invocationConstraints);
        }

        public void populateContext(Collection collection) {
            collection.add(new AcknowledgmentSource(){

                public boolean addAcknowledgmentListener(AcknowledgmentSource.Listener listener) {
                    if (listener == null) {
                        throw new NullPointerException();
                    }
                    return InboundRequestImpl.this.addAcknowledgmentListener(listener);
                }
            });
            HttpServerConnection.this.populateContext(collection);
        }

        public InputStream getRequestInputStream() {
            return this.getInputStream();
        }

        public OutputStream getResponseOutputStream() {
            return this.getOutputStream();
        }

        boolean streamCorrupt() {
            return this.corrupt;
        }

        void startOutput() throws IOException {
        }

        void write(byte[] byArray, int n, int n2) throws IOException {
            this.writer.writeContent(byArray, n, n2);
        }

        void endOutput() throws IOException {
            if (this.cookie != null) {
                Header header = new Header();
                header.setField("RMI-Response-Cookie", this.cookie);
                this.writer.writeTrailer(header);
            } else {
                this.writer.writeTrailer(null);
            }
        }

        boolean startInput() throws IOException {
            return true;
        }

        int read(byte[] byArray, int n, int n2) throws IOException {
            return this.reader.readContent(byArray, n, n2);
        }

        int available() throws IOException {
            return this.reader.availableContent();
        }

        void endInput() throws IOException {
            Header header = this.reader.readTrailer();
            if (header != null) {
                HttpServerConnection.this.registerAcks(header.getField("RMI-Response-Ack"));
            }
        }

        void addAckListener(AcknowledgmentSource.Listener listener) {
            if (this.cookie == null) {
                this.cookie = HttpServerConnection.this.manager.newCookie();
            }
            HttpServerConnection.this.manager.addAckListener(this.cookie, listener);
        }

        void done(boolean bl) {
            this.corrupt = bl;
        }
    }

    private class Dispatcher
    implements Runnable {
        private Dispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {}
                catch (IOException iOException) {
                    Object var8_9 = null;
                    HttpServerConnection.this.shutdown(true);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                HttpServerConnection.this.shutdown(true);
                throw throwable;
            }
            while (true) {
                HttpServerConnection.this.idle();
                MessageReader messageReader = new MessageReader(HttpServerConnection.this.in, false);
                StartLine startLine = messageReader.readStartLine();
                HttpServerConnection.this.busy();
                Object object = HttpServerConnection.this.stateLock;
                synchronized (object) {
                    if (HttpServerConnection.this.state == 3) {
                        // MONITOREXIT @DISABLED, blocks:[18, 6, 10] lbl24 : MonitorExitStatement: MONITOREXIT : var3_4
                        Object var8_7 = null;
                        HttpServerConnection.this.shutdown(true);
                        return;
                    }
                    HttpServerConnection.this.state = 2;
                }
                object = messageReader.readHeader();
                String string = ((Header)object).getField("RMI-Request-Type");
                if (!"POST".equals(startLine.method)) {
                    this.handleBadRequest(startLine, (Header)object, messageReader);
                } else if ("standard".equalsIgnoreCase(string)) {
                    this.handleRequest(startLine, (Header)object, messageReader);
                } else if ("ping".equalsIgnoreCase(string)) {
                    this.handlePing(startLine, (Header)object, messageReader);
                } else {
                    this.handleBadRequest(startLine, (Header)object, messageReader);
                }
                Object object2 = HttpServerConnection.this.stateLock;
                synchronized (object2) {
                    if (HttpServerConnection.this.state == 3) {
                        // MONITOREXIT @DISABLED, blocks:[7, 10, 11] lbl48 : MonitorExitStatement: MONITOREXIT : var5_6
                        Object var8_8 = null;
                        HttpServerConnection.this.shutdown(true);
                        return;
                    }
                    HttpServerConnection.this.state = 1;
                }
            }
        }

        private void handleBadRequest(StartLine startLine, Header header, MessageReader messageReader) throws IOException {
            header.merge(messageReader.readTrailer());
            HttpServerConnection.this.registerAcks(header.getField("RMI-Response-Ack"));
            boolean bl = HttpServerConnection.supportsPersist(startLine, header);
            MessageWriter messageWriter = new MessageWriter(HttpServerConnection.this.out, false);
            messageWriter.writeStartLine(new StartLine(1, 1, 400, "Bad Request"));
            messageWriter.writeHeader(HttpServerConnection.createResponseHeader(bl));
            messageWriter.writeTrailer(null);
            if (!bl) {
                HttpServerConnection.this.shutdown(true);
            }
        }

        private void handlePing(StartLine startLine, Header header, MessageReader messageReader) throws IOException {
            header.merge(messageReader.readTrailer());
            HttpServerConnection.this.registerAcks(header.getField("RMI-Response-Ack"));
            boolean bl = HttpServerConnection.supportsPersist(startLine, header);
            MessageWriter messageWriter = new MessageWriter(HttpServerConnection.this.out, false);
            messageWriter.writeStartLine(new StartLine(1, 1, 200, "OK"));
            messageWriter.writeHeader(HttpServerConnection.createResponseHeader(bl));
            messageWriter.writeTrailer(null);
            if (!bl) {
                HttpServerConnection.this.shutdown(true);
            }
        }

        private void handleRequest(StartLine startLine, Header header, MessageReader messageReader) throws IOException {
            HttpServerConnection.this.registerAcks(header.getField("RMI-Response-Ack"));
            boolean bl = HttpServerConnection.supportsPersist(startLine, header);
            boolean bl2 = HttpServerConnection.supportsChunking(startLine, header);
            MessageWriter messageWriter = new MessageWriter(HttpServerConnection.this.out, bl2);
            messageWriter.writeStartLine(new StartLine(1, 1, 200, "OK"));
            messageWriter.writeHeader(HttpServerConnection.createResponseHeader(bl));
            InboundRequestImpl inboundRequestImpl = new InboundRequestImpl(messageReader, messageWriter);
            try {
                HttpServerConnection.this.dispatcher.dispatch(inboundRequestImpl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            inboundRequestImpl.finish();
            if (!bl || inboundRequestImpl.streamCorrupt()) {
                HttpServerConnection.this.shutdown(true);
            }
        }
    }
}

