/*
 * Decompiled with CFR 0.152.
 */
package net.jini.config;

import com.sun.jini.logging.Levels;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.jini.config.AbstractConfiguration;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationNotFoundException;
import net.jini.config.NoSuchEntryException;
import net.jini.config.UnicodeEscapesDecodingReader;
import net.jini.config.Utilities;
import net.jini.security.Security;

public class ConfigurationFile
extends AbstractConfiguration {
    private static final Class[] primitives;
    private static final int INT_INDEX = 4;
    private static final int BYTE_INDEX = 1;
    private static final Set prohibitedMethods;
    private static final String moreProhibitedMethods = "net/jini/config/resources/ConfigurationFile.moreProhibitedMethods";
    private static final PrivilegedAction contextClassLoader;
    static final RuntimePermission getClassLoaderPermission;
    final Map entries;
    final Map classImports;
    final List onDemandImports;
    private String location;
    private int override;
    private final ClassLoader cl;
    private final boolean nonNullLoaderSupplied;
    private final Object resolveLock;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    public ConfigurationFile(String[] stringArray) throws ConfigurationException {
        this(stringArray, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationFile(String[] stringArray, ClassLoader classLoader) throws ConfigurationException {
        block13: {
            this.entries = new HashMap(11);
            this.classImports = new HashMap(1);
            this.onDemandImports = new ArrayList(1);
            this.override = 0;
            this.resolveLock = new Object();
            stringArray = this.checkOptions(stringArray);
            this.nonNullLoaderSupplied = classLoader != null;
            ClassLoader classLoader2 = this.cl = this.nonNullLoaderSupplied ? classLoader : (ClassLoader)Security.doPrivileged(contextClassLoader);
            if (this.location == null) {
                new Parser(null, stringArray);
            } else {
                InputStream inputStream = null;
                try {
                    try {
                        try {
                            URL uRL = new URL(this.location);
                            inputStream = uRL.openStream();
                        }
                        catch (MalformedURLException malformedURLException) {
                            inputStream = new FileInputStream(this.location);
                        }
                        new Parser(new InputStreamReader(inputStream), stringArray);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new ConfigurationNotFoundException("configuration file not found: " + this.location, fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        throw new ConfigurationException("problem reading configuration file " + this.location, iOException);
                    }
                    catch (RuntimeException runtimeException) {
                        throw new ConfigurationException("problem reading configuration file " + this.location, runtimeException);
                    }
                    Object var6_9 = null;
                    if (inputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                inputStream.close();
            }
        }
        logger.log(Level.FINER, "created {0}", this);
    }

    private String[] checkOptions(String[] stringArray) throws ConfigurationException {
        if (stringArray == null) {
            return new String[0];
        }
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                throw new ConfigurationException("option is null");
            }
            if (!"-".equals(stringArray[0])) {
                this.location = stringArray[0];
            }
        }
        return stringArray;
    }

    public ConfigurationFile(Reader reader, String[] stringArray) throws ConfigurationException {
        this(reader, stringArray, null);
    }

    public ConfigurationFile(Reader reader, String[] stringArray, ClassLoader classLoader) throws ConfigurationException {
        this.entries = new HashMap(11);
        this.classImports = new HashMap(1);
        this.onDemandImports = new ArrayList(1);
        this.override = 0;
        this.resolveLock = new Object();
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        stringArray = this.checkOptions(stringArray);
        this.nonNullLoaderSupplied = classLoader != null;
        this.cl = this.nonNullLoaderSupplied ? classLoader : (ClassLoader)Security.doPrivileged(contextClassLoader);
        new Parser(reader, stringArray);
        logger.log(Level.FINER, "created {0}", this);
    }

    protected Object getEntryInternal(String string, String string2, Class clazz, Object object) throws ConfigurationException {
        if (string == null || string2 == null || clazz == null) {
            throw new NullPointerException("component, name and type cannot be null");
        }
        Entry entry = (Entry)this.entries.get(string + '.' + string2);
        if (entry == null || entry.isPrivate) {
            throw new NoSuchEntryException("entry not found for component " + string + ", name " + string2);
        }
        Class clazz2 = entry.resolve(null);
        if (!ConfigurationFile.assignable(clazz2, clazz)) {
            Object object2;
            if (clazz2 != null && clazz2.isPrimitive() && entry.isConstant() && (object2 = this.narrowingAssignable(entry.eval(NO_DATA), clazz)) != null) {
                return new AbstractConfiguration.Primitive(object2);
            }
            throw new ConfigurationException("entry of wrong type for component " + string + ", name " + string2 + ": expected " + Utilities.typeString(clazz) + ", found " + Utilities.typeString(clazz2));
        }
        Object object3 = entry.eval(object);
        if (clazz2 != null && clazz2.isPrimitive()) {
            if (clazz2 != clazz) {
                object3 = ConfigurationFile.convertPrimitive(object3, clazz);
            }
            return new AbstractConfiguration.Primitive(object3);
        }
        return object3;
    }

    public Set getEntryNames() {
        HashSet<String> hashSet = new HashSet<String>(this.entries.size());
        Iterator iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.isPrivate) continue;
            hashSet.add(entry.fullName);
        }
        return hashSet;
    }

    public Class getEntryType(String string, String string2) throws ConfigurationException {
        ConfigurationException configurationException;
        if (string == null) {
            throw new NullPointerException("component cannot be null");
        }
        if (!ConfigurationFile.validQualifiedIdentifier(string)) {
            throw new IllegalArgumentException("component must be a valid qualified identifier");
        }
        if (string2 == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (!ConfigurationFile.validIdentifier(string2)) {
            throw new IllegalArgumentException("name must be a valid identifier");
        }
        Entry entry = (Entry)this.entries.get(string + '.' + string2);
        if (entry == null || entry.isPrivate) {
            if (logger.isLoggable(Levels.FAILED)) {
                logger.log(Levels.FAILED, "entry for component {0}, name {1} not found in {2}", new Object[]{string, string2, this});
            }
            throw new NoSuchEntryException("entry not found for component " + string + ", name " + string2);
        }
        try {
            Class clazz = entry.resolve(null);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "{0}, component {1}, name {2}: returns {3}", new Object[]{this, string, string2, clazz});
            }
            return clazz;
        }
        catch (ConfigurationException configurationException2) {
            configurationException = configurationException2;
        }
        catch (RuntimeException runtimeException) {
            configurationException = new ConfigurationException("problem getting type of entry for component " + string + ", name " + string2, runtimeException);
        }
        if (logger.isLoggable(Levels.FAILED)) {
            this.logThrow("getEntryType", "{0}, component {1}, name {2}: throws", new Object[]{this, string, string2}, configurationException);
        }
        throw configurationException;
    }

    protected Class getSpecialEntryType(String string) throws ConfigurationException {
        throw new NoSuchEntryException("entry not found: " + string);
    }

    protected Object getSpecialEntry(String string) throws ConfigurationException {
        throw new NoSuchEntryException("entry not found: " + string);
    }

    Class findClass(String string, int n, int n2) throws ConfigurationException {
        return this.findClass(string, n, n2, false);
    }

    Class findClass(String string, int n, int n2, boolean bl) throws ConfigurationException {
        Class clazz;
        Class clazz2 = ConfigurationFile.findPrimitiveClass(string);
        if (clazz2 != null) {
            return clazz2;
        }
        int n3 = string.indexOf(46);
        String string2 = n3 < 0 ? string : string.substring(0, n3);
        String string3 = (String)this.classImports.get(string2);
        if (string3 != null) {
            if (n3 >= 0) {
                string3 = string3 + string.substring(n3).replace('.', '$');
            }
            if ((clazz = this.findClassNoImports(string3, n, n2)) != null) {
                return clazz;
            }
        }
        if ((clazz = this.findClassNoImports(string, n, n2)) != null) {
            return clazz;
        }
        String string4 = string.replace('.', '$');
        Class clazz3 = null;
        int n4 = this.onDemandImports.size();
        while (--n4 >= 0) {
            String string5 = (String)this.onDemandImports.get(n4);
            for (int i = 0; i < 2; ++i) {
                char c = i == 0 ? (char)'.' : '$';
                Class clazz4 = this.findClassExact(string5 + c + string4, n, n2);
                if (clazz4 == null) continue;
                if (clazz3 != null) {
                    this.oops("ambiguous class: " + string, n, n2);
                }
                clazz3 = clazz4;
            }
        }
        if (clazz3 == null && !bl) {
            this.oops("class not found: " + string, n, n2);
        }
        return clazz3;
    }

    static Class findPrimitiveClass(String string) {
        if (string.indexOf(46) < 0) {
            int n = primitives.length;
            while (--n >= 0) {
                if (!string.equals(primitives[n].getName())) continue;
                return primitives[n];
            }
        }
        return null;
    }

    Class findClassNoImports(String string, int n, int n2) throws ConfigurationException {
        int n3;
        Class clazz = this.findClassExact(string, n, n2);
        if (clazz != null) {
            return clazz;
        }
        while ((n3 = string.lastIndexOf(46)) >= 0) {
            clazz = this.findClassExact(string = string.substring(0, n3) + '$' + string.substring(n3 + 1), n, n2);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    Class findClassExact(String string, int n, int n2) throws ConfigurationException {
        try {
            Class<?> clazz;
            Class<?> clazz2 = clazz = Class.forName(string, false, this.cl);
            do {
                if (Modifier.isPublic(clazz2.getModifiers())) continue;
                string = string.replace('$', '.');
                if (clazz2 == clazz) {
                    this.oops("class not public: " + string, n, n2);
                    continue;
                }
                this.oops("class " + string + " is not accessible: " + "declaring class " + clazz2.getName().replace('$', '.') + " is not public", n, n2);
            } while ((clazz2 = clazz2.getDeclaringClass()) != null);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    Field findField(String string, int n, int n2) throws ConfigurationException {
        String string2;
        Class clazz;
        int n3 = string.lastIndexOf(46);
        if (n3 < 0) {
            this.oops("entry not found: " + string, n, n2);
        }
        if ((clazz = this.findClass(string2 = string.substring(0, n3), n, n2, true)) == null) {
            this.oops("entry or field not found: " + string, n, n2);
        }
        String string3 = string.substring(n3 + 1);
        ConfigurationFile.checkPackageAccess(clazz);
        try {
            Field field = clazz.getField(string3);
            if (!Modifier.isStatic(field.getModifiers())) {
                this.oops(string3 + " is not a static field of class " + string2, n, n2);
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.oops(string3 + " is not a public field of class " + string2, n, n2);
            return null;
        }
    }

    private static void checkPackageAccess(Class clazz) {
        String string;
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = (string = clazz.getName()).lastIndexOf(46)) != -1) {
            securityManager.checkPackageAccess(string.substring(0, n));
        }
    }

    Method findMethod(String string, Class[] classArray, int n, int n2) throws ConfigurationException {
        int n3 = string.lastIndexOf(46);
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3 + 1);
        Class clazz = this.findClass(string2, n, n2, true);
        if (clazz == null) {
            this.oops("method not found: " + string, n, n2);
        }
        Method method = null;
        ConfigurationFile.checkPackageAccess(clazz);
        Method[] methodArray = clazz.getMethods();
        boolean bl = false;
        int n4 = methodArray.length;
        while (--n4 >= 0) {
            if (!string3.equals(methodArray[n4].getName()) || !Modifier.isStatic(methodArray[n4].getModifiers()) || !ConfigurationFile.compatible(methodArray[n4].getParameterTypes(), classArray)) continue;
            if (method == null) {
                method = methodArray[n4];
                continue;
            }
            if (ConfigurationFile.assignable(methodArray[n4].getParameterTypes(), method.getParameterTypes()) && ConfigurationFile.assignable(methodArray[n4].getDeclaringClass(), method.getDeclaringClass())) {
                method = methodArray[n4];
                continue;
            }
            bl = true;
        }
        if (method == null) {
            this.oops("no applicable public static method found: " + clazz.getName() + '.' + string3 + ConfigurationFile.typesString(classArray), n, n2);
        } else if (prohibitedMethods.contains(method.getDeclaringClass().getName() + '.' + string3)) {
            this.oops("call to method prohibited: " + string, n, n2);
        } else if (bl) {
            n4 = methodArray.length;
            while (--n4 >= 0) {
                if (methodArray[n4] == method || !string3.equals(methodArray[n4].getName()) || !Modifier.isStatic(methodArray[n4].getModifiers()) || !ConfigurationFile.compatible(methodArray[n4].getParameterTypes(), classArray) || ConfigurationFile.assignable(method.getParameterTypes(), methodArray[n4].getParameterTypes()) && ConfigurationFile.assignable(method.getDeclaringClass(), methodArray[n4].getDeclaringClass())) continue;
                this.oops("ambiguous method invocation: " + clazz.getName() + '.' + string3 + ConfigurationFile.typesString(classArray), n, n2);
            }
        }
        return method;
    }

    Constructor findConstructor(String string, Class[] classArray, int n, int n2) throws ConfigurationException {
        Class clazz = this.findClass(string, n, n2);
        if (Modifier.isInterface(clazz.getModifiers())) {
            this.oops("calling constructor for interface class: " + clazz.getName(), n, n2);
        } else if (clazz.isPrimitive()) {
            this.oops("calling constructor for primitive class: " + clazz.getName(), n, n2);
        } else if (Modifier.isAbstract(clazz.getModifiers())) {
            this.oops("calling constructor for abstract class: " + clazz.getName(), n, n2);
        }
        ConfigurationFile.checkPackageAccess(clazz);
        Constructor<?>[] constructorArray = clazz.getConstructors();
        Constructor<?> constructor = null;
        boolean bl = false;
        int n3 = constructorArray.length;
        while (--n3 >= 0) {
            if (!ConfigurationFile.compatible(constructorArray[n3].getParameterTypes(), classArray)) continue;
            if (constructor == null || ConfigurationFile.assignable(constructorArray[n3].getParameterTypes(), constructor.getParameterTypes())) {
                constructor = constructorArray[n3];
                continue;
            }
            bl = true;
        }
        if (constructor == null) {
            this.oops("no public constructor found: " + clazz.getName() + ConfigurationFile.typesString(classArray), n, n2);
        } else if (bl) {
            n3 = constructorArray.length;
            while (--n3 >= 0) {
                if (constructorArray[n3] == constructor || !ConfigurationFile.compatible(constructorArray[n3].getParameterTypes(), classArray) || ConfigurationFile.assignable(constructor.getParameterTypes(), constructorArray[n3].getParameterTypes())) continue;
                this.oops("ambiguous constructor invocation: " + clazz.getName() + ConfigurationFile.typesString(classArray), n, n2);
            }
        }
        return constructor;
    }

    private static boolean compatible(Class[] classArray, Class[] classArray2) {
        return classArray.length == classArray2.length && ConfigurationFile.assignable(classArray2, classArray);
    }

    private static boolean assignable(Class[] classArray, Class[] classArray2) {
        int n = classArray.length;
        while (--n >= 0) {
            if (ConfigurationFile.assignable(classArray[n], classArray2[n])) continue;
            return false;
        }
        return true;
    }

    static boolean assignable(Class clazz, Class clazz2) {
        if (clazz == null) {
            return !clazz2.isPrimitive();
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz2.isPrimitive() && clazz.isPrimitive()) {
            if (clazz == Byte.TYPE && clazz2 == Short.TYPE) {
                return true;
            }
            int n = primitives.length;
            while (--n >= 4) {
                if (clazz2 != primitives[n]) continue;
                while (--n >= 1) {
                    if (clazz != primitives[n]) continue;
                    return true;
                }
                break block0;
            }
        }
        return false;
    }

    Object narrowingAssignable(Object object, Class clazz) {
        if (object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer) {
            int n;
            int n2 = n = object instanceof Character ? ((Character)object).charValue() : ((Number)object).intValue();
            if (clazz == Byte.TYPE) {
                if (n >= -128 && n <= 127) {
                    return new Byte((byte)n);
                }
            } else if (clazz == Character.TYPE) {
                if (n >= 0 && n <= 65535) {
                    return new Character((char)n);
                }
            } else if (clazz == Short.TYPE && n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
                return new Short((short)n);
            }
        }
        return null;
    }

    static Object convertPrimitive(Object object, Class clazz) {
        Number number;
        Number number2 = number = object instanceof Character ? (Number)new Integer(((Character)object).charValue()) : (Number)((Number)object);
        if (clazz == Byte.TYPE) {
            return new Byte(number.byteValue());
        }
        if (clazz == Character.TYPE) {
            return new Character((char)number.intValue());
        }
        if (clazz == Short.TYPE) {
            return new Short(number.shortValue());
        }
        if (clazz == Integer.TYPE) {
            return new Integer(number.intValue());
        }
        if (clazz == Long.TYPE) {
            return new Long(number.longValue());
        }
        if (clazz == Float.TYPE) {
            return new Float(number.floatValue());
        }
        if (clazz == Double.TYPE) {
            return new Double(number.doubleValue());
        }
        return null;
    }

    static boolean compatibleMethods(Class clazz, Class clazz2) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        while (--n >= 0) {
            Method method = methodArray[n];
            try {
                Method method2 = clazz2.getMethod(method.getName(), method.getParameterTypes());
                if (method2 == null || method.getReturnType() == method2.getReturnType()) continue;
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return true;
    }

    private static String typesString(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(Utilities.typeString(classArray[i]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    String expandStringProperties(String string, int n) throws ConfigurationException {
        StringBuffer stringBuffer;
        block8: {
            int n2;
            int n3 = string.indexOf("${", 0);
            if (n3 == -1) {
                return string;
            }
            int n4 = string.length();
            stringBuffer = new StringBuffer(n4);
            int n5 = 0;
            do {
                if (n3 > n5) {
                    stringBuffer.append(string.substring(n5, n3));
                    n5 = n3;
                }
                if ((n2 = string.indexOf(125, n3 + 2)) == -1) {
                    stringBuffer.append(string.substring(n3, n4));
                    break block8;
                }
                String string2 = string.substring(n3 + 2, n2);
                if (string2.equals("/")) {
                    stringBuffer.append(File.separatorChar);
                    continue;
                }
                try {
                    String string3;
                    String string4 = string3 = string2.length() == 0 ? null : System.getProperty(string2);
                    if (string3 != null) {
                        stringBuffer.append(string3);
                        continue;
                    }
                    this.oops("problem expanding system property '" + string2 + "'", n, this.override);
                }
                catch (SecurityException securityException) {
                    this.oops("problem expanding system property '" + string2 + "'", n, this.override, securityException);
                }
            } while ((n3 = string.indexOf("${", n5 = n2 + 1)) != -1);
            if (n5 >= n4) break block8;
            stringBuffer.append(string.substring(n5, n4));
        }
        return stringBuffer.toString();
    }

    void oops(String string, int n, int n2) throws ConfigurationException {
        this.oops(string, n, n2, null);
    }

    void oops(String string, int n, int n2, Throwable throwable) throws ConfigurationException {
        throw new ConfigurationException((n2 != 0 ? "Override " + n2 + ": Line " : (this.location == null ? "Line " : this.location + ":")) + n + ": " + string, throwable);
    }

    public String toString() {
        return "ConfigurationFile@" + Integer.toHexString(this.hashCode()) + (this.location == null ? "" : "{" + this.location + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block12: {
            ConfigurationFile.primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
            ConfigurationFile.prohibitedMethods = new HashSet<String>(Arrays.asList(new String[]{"java.lang.Class.forName", "java.lang.ClassLoader.getSystemClassLoader", "java.lang.Package.getPackage", "java.lang.Package.getPackages", "java.lang.System.load", "java.lang.System.loadLibrary", "java.security.AccessController.doPrivileged", "java.sql.DriverManager.deregisterDriver", "java.sql.DriverManager.getConnection", "java.sql.DriverManager.getDriver", "java.sql.DriverManager.getDrivers", "net.jini.security.Security.doPrivileged"}));
            var0 = null;
            try {
                try {
                    var1_1 = ConfigurationFile.class.getClassLoader();
                    if (var1_1 == null) {
                        var1_1 = Utilities.bootstrapResourceLoader;
                    }
                    if ((var0 = var1_1.getResourceAsStream("net/jini/config/resources/ConfigurationFile.moreProhibitedMethods")) != null) {
                        var2_3 = new BufferedReader(new InputStreamReader(var0, "utf-8"));
                        while ((var3_4 = var2_3.readLine()) != null) {
                            ConfigurationFile.logger.log(Level.FINER, "Adding prohibited method: {0}", var3_4);
                            ConfigurationFile.prohibitedMethods.add(var3_4);
                        }
                    }
                    var5_5 = null;
                    if (var0 == null) break block12;
                }
                catch (IOException var1_2) {
                    ConfigurationFile.logger.log(Level.INFO, "Problem reading prohibited methods resource", var1_2);
                    var5_6 = null;
                    if (var0 != null) {
                        try {
                            var0.close();
                        }
                        catch (IOException var6_9) {}
                    }
                    break block12;
                }
            }
            catch (Throwable var4_11) {
                var5_7 = null;
                if (var0 == null) throw var4_11;
                ** try [egrp 2[TRYBLOCK] [4 : 284->291)] { 
lbl34:
                // 1 sources

                var0.close();
                throw var4_11;
lbl36:
                // 1 sources

                catch (IOException var6_10) {
                    // empty catch block
                }
                throw var4_11;
            }
            try {}
            catch (IOException var6_8) {}
            var0.close();
        }
        ConfigurationFile.contextClassLoader = new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        ConfigurationFile.getClassLoaderPermission = new RuntimePermission("getClassLoader");
    }

    private class Parser {
        private StreamTokenizer st;

        Parser(Reader reader, String[] stringArray) throws ConfigurationException {
            try {
                try {
                    ConfigurationFile.this.onDemandImports.add("java.lang");
                    if (reader != null) {
                        if (!(reader instanceof BufferedReader)) {
                            reader = new BufferedReader(reader);
                        }
                        this.createTokenizer(reader);
                        this.parseSource();
                    }
                    for (int i = 1; i < stringArray.length; ++i) {
                        ConfigurationFile.this.override = i;
                        this.createTokenizer(new StringReader(stringArray[i]));
                        this.parseOverride();
                    }
                    Object var6_6 = null;
                }
                catch (IOException iOException) {
                    throw new ConfigurationException((ConfigurationFile.this.location == null ? "" : ConfigurationFile.this.location + ": ") + "problem reading configuration file", iOException);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ConfigurationFile.this.override = 0;
                throw throwable;
            }
            ConfigurationFile.this.override = 0;
        }

        private void createTokenizer(Reader reader) {
            reader = new UnicodeEscapesDecodingReader(reader);
            this.st = new PushbackStreamTokenizer(reader);
            this.st.ordinaryChar(46);
            this.st.wordChars(46, 46);
            this.st.ordinaryChars(48, 57);
            this.st.wordChars(48, 57);
            this.st.ordinaryChar(45);
            this.st.wordChars(45, 45);
            this.st.wordChars(95, 95);
            this.st.wordChars(36, 36);
            this.st.ordinaryChar(47);
            this.st.slashSlashComments(true);
            this.st.slashStarComments(true);
        }

        private void parseSource() throws ConfigurationException, IOException {
            int n;
            while ((n = this.st.nextToken()) != -1) {
                this.st.pushBack();
                String string = this.token("keyword 'import', 'static' or 'private', or component");
                if ("import".equals(string)) {
                    this.parseImport();
                    continue;
                }
                this.parseComponent(string);
            }
        }

        private void parseImport() throws ConfigurationException, IOException {
            if (!ConfigurationFile.this.entries.isEmpty()) {
                this.oops("import follows entry");
            }
            this.st.wordChars(42, 42);
            String string = this.token("import package or type");
            this.st.ordinaryChar(42);
            boolean bl = string.endsWith(".*");
            if (bl) {
                string = string.substring(0, string.length() - 2);
            }
            if (!AbstractConfiguration.validQualifiedIdentifier(string)) {
                this.syntax("import package or type");
            }
            this.token(';');
            if (bl) {
                if (!ConfigurationFile.this.onDemandImports.contains(string)) {
                    Class clazz = ConfigurationFile.this.findClassNoImports(string, this.st.lineno(), ConfigurationFile.this.override);
                    if (clazz != null && clazz.getName().indexOf(46) < 0) {
                        this.oops("import from unnamed package");
                    }
                    ConfigurationFile.this.onDemandImports.add(string);
                }
            } else {
                Class clazz;
                int n = string.lastIndexOf(46);
                if (n < 0) {
                    this.oops("import from unnamed package");
                }
                if ((clazz = ConfigurationFile.this.findClassNoImports(string, this.st.lineno(), ConfigurationFile.this.override)) == null) {
                    this.oops("class not found: " + string);
                } else if (clazz.getName().indexOf(46) < 0) {
                    this.oops("import from unnamed package");
                }
                String string2 = string.substring(n + 1);
                if (ConfigurationFile.this.classImports.containsKey(string2) && !ConfigurationFile.this.classImports.get(string2).equals(string)) {
                    this.oops("conflicting imports: " + ConfigurationFile.this.classImports.get(string2) + " and " + string);
                }
                ConfigurationFile.this.classImports.put(string2, string);
            }
        }

        private void parseComponent(String string) throws ConfigurationException, IOException {
            if (!AbstractConfiguration.validQualifiedIdentifier(string)) {
                this.oops("invalid component: '" + string + "'");
            }
            this.token('{');
            while (true) {
                int n;
                if ((n = this.st.nextToken()) == -3) {
                    this.parseEntry(string, this.st.sval);
                    continue;
                }
                if (n == 125) break;
                this.syntax("'}', keyword 'static' or 'private', or entry name");
            }
        }

        private void parseEntry(String string, String string2) throws ConfigurationException, IOException {
            String string3;
            boolean bl = false;
            boolean bl2 = false;
            while (true) {
                if ("private".equals(string2)) {
                    if (bl) {
                        this.oops("duplicate 'private'");
                    }
                    bl = true;
                } else {
                    if (!"static".equals(string2)) break;
                    if (bl2) {
                        this.oops("duplicate 'static'");
                    }
                    bl2 = true;
                }
                string2 = this.token("keyword 'static' or 'private', or entry name");
            }
            if (!AbstractConfiguration.validIdentifier(string2)) {
                this.oops("illegal entry name: " + string2);
            }
            if (ConfigurationFile.this.entries.containsKey(string3 = string + '.' + string2)) {
                this.oops("duplicate entry name: " + string2);
            }
            this.token('=');
            Entry entry = new Entry(string, string3, bl, bl2, false, this.st.lineno(), this);
            this.token(';');
            ConfigurationFile.this.entries.put(string3, entry);
        }

        private void parseOverride() throws ConfigurationException, IOException {
            Entry entry;
            String string;
            boolean bl = false;
            boolean bl2 = false;
            while (true) {
                if ("private".equals(string = this.token("keyword 'static' or 'private', or fully qualified entry name"))) {
                    if (bl) {
                        this.oops("duplicate 'private'");
                    }
                    bl = true;
                    continue;
                }
                if (!"static".equals(string)) break;
                if (bl2) {
                    this.oops("duplicate 'static'");
                }
                bl2 = true;
            }
            int n = string.lastIndexOf(46);
            if (!AbstractConfiguration.validQualifiedIdentifier(string) || n < 0) {
                this.syntax("fully qualified entry name");
            }
            if ((entry = (Entry)ConfigurationFile.this.entries.get(string)) != null && entry.isOverride) {
                this.oops("duplicate override: " + string);
            }
            this.token('=');
            String string2 = string.substring(0, n);
            entry = new Entry(string2, string, bl, bl2, true, this.st.lineno(), this);
            int n2 = this.st.nextToken();
            if (n2 != -1) {
                this.syntax("no more characters");
            }
            ConfigurationFile.this.entries.put(string, entry);
        }

        private ParseNode[] parseArgs(Entry entry, char c) throws ConfigurationException, IOException {
            ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>(1);
            int n = this.st.nextToken();
            if (n != c) {
                this.st.pushBack();
                while (true) {
                    arrayList.add(this.parseExpr(entry));
                    n = this.st.nextToken();
                    if (n == c) break;
                    if (n == 44) continue;
                    this.syntax("',' or '" + c + "'");
                }
            }
            return arrayList.toArray(new ParseNode[arrayList.size()]);
        }

        ParseNode parseExpr(Entry entry) throws ConfigurationException, IOException {
            int n = this.st.nextToken();
            String string = this.st.sval;
            if (n == 39) {
                if (string.length() != 1) {
                    this.oops("invalid character: '" + string + "'");
                }
                return new Literal(Character.TYPE, new Character(string.charAt(0)), this.st.lineno());
            }
            if (n == 34) {
                return new StringLiteral(string, this.st.lineno());
            }
            if (n == 40) {
                int n2 = this.st.lineno();
                String string2 = this.token("type");
                n = this.st.nextToken();
                boolean bl = false;
                if (n == 91) {
                    bl = true;
                    this.token(']');
                    n = this.st.nextToken();
                }
                if (n != 41) {
                    this.syntax("')'");
                }
                return new Cast(string2, bl, this.parseExpr(entry), n2);
            }
            this.st.pushBack();
            string = this.token("expression");
            if (Character.isDigit(string.charAt(0)) || string.charAt(0) == '-') {
                return this.getNumber(string);
            }
            if ("true".equals(string)) {
                return new Literal(Boolean.TYPE, Boolean.TRUE, this.st.lineno());
            }
            if ("false".equals(string)) {
                return new Literal(Boolean.TYPE, Boolean.FALSE, this.st.lineno());
            }
            if ("null".equals(string)) {
                return new Literal(null, null, this.st.lineno());
            }
            if ("new".equals(string)) {
                return this.parseNewInstance(entry);
            }
            if ("this".equals(string)) {
                return new ThisRef(this.st.lineno());
            }
            if (string.endsWith(".class")) {
                if (ConfigurationFile.findPrimitiveClass(string = string.substring(0, string.length() - 6)) == null && !AbstractConfiguration.validQualifiedIdentifier(string)) {
                    this.oops("illegal class name: " + string);
                }
                return new ClassLiteral(string, false, this.st.lineno());
            }
            n = this.st.nextToken();
            if (n == 91) {
                int n3 = this.st.lineno();
                this.token(']');
                if (!".class".equals(this.token("'.class'"))) {
                    this.syntax("'.class'");
                } else if (ConfigurationFile.findPrimitiveClass(string) == null && !AbstractConfiguration.validQualifiedIdentifier(string)) {
                    this.oops("illegal class name: " + string);
                }
                return new ClassLiteral(string, true, n3);
            }
            this.st.pushBack();
            if (!AbstractConfiguration.validQualifiedIdentifier(string)) {
                if (n == 40) {
                    this.oops("illegal method name: " + string);
                } else {
                    this.oops("illegal field or entry name: " + string);
                }
            }
            if (n == 40) {
                return this.parseMethodCall(entry, string);
            }
            if ("$data".equals(string)) {
                if (entry.isStatic) {
                    this.oops("cannot use '$data' in a static entry");
                }
                entry.setRefersToData();
            }
            return new NameRef(entry.component, string, this.st.lineno());
        }

        private Literal getNumber(String string) throws ConfigurationException, IOException {
            char c = string.charAt(string.length() - 1);
            try {
                if (c == 'l' || c == 'L') {
                    return new Literal(Long.TYPE, Long.decode(string.substring(0, string.length() - 1)), this.st.lineno());
                }
                if (c == 'f' || c == 'F') {
                    return new Literal(Float.TYPE, Float.valueOf(string.substring(0, string.length() - 1)), this.st.lineno());
                }
                if (c == 'd' || c == 'D') {
                    return new Literal(Double.TYPE, Double.valueOf(string.substring(0, string.length() - 1)), this.st.lineno());
                }
                if (string.indexOf(101) > 0 || string.indexOf(69) > 0 || string.indexOf(46) > 0) {
                    return new Literal(Double.TYPE, Double.valueOf(string), this.st.lineno());
                }
                return new Literal(Integer.TYPE, Integer.decode(string), this.st.lineno());
            }
            catch (NumberFormatException numberFormatException) {
                this.oops("bad numeric literal: " + string);
                return null;
            }
        }

        private ParseNode parseNewInstance(Entry entry) throws ConfigurationException, IOException {
            int n = this.st.lineno();
            String string = this.token("type name");
            int n2 = this.st.nextToken();
            if (n2 == 91) {
                this.token(']');
                this.token('{');
                return new ArrayConstructor(string, this.parseArgs(entry, '}'), n);
            }
            if (n2 != 40) {
                this.syntax("'(' or '['");
            }
            return new ConstructorCall(string, this.parseArgs(entry, ')'), n);
        }

        private MethodCall parseMethodCall(Entry entry, String string) throws ConfigurationException, IOException {
            if (!AbstractConfiguration.validQualifiedIdentifier(string) || string.indexOf(46) < 0) {
                this.syntax("method name");
            }
            int n = this.st.lineno();
            this.token('(');
            return new MethodCall(string, this.parseArgs(entry, ')'), n);
        }

        private void token(char c) throws ConfigurationException, IOException {
            int n = this.st.nextToken();
            if (n != c) {
                if (c == '\"') {
                    this.syntax("a String");
                } else {
                    this.syntax(new String(new char[]{'\'', c, '\''}));
                }
            }
        }

        private String token(String string) throws ConfigurationException, IOException {
            int n = this.st.nextToken();
            if (n != -3) {
                this.syntax(string);
            }
            if (this.st.sval.indexOf(46) >= 0 || AbstractConfiguration.validIdentifier(this.st.sval) || ConfigurationFile.findPrimitiveClass(this.st.sval) != null) {
                String string2 = this.st.sval;
                while (true) {
                    int n2;
                    if ((n2 = this.st.nextToken()) != -3 || !string2.endsWith(".") && !this.st.sval.startsWith(".")) break;
                    string2 = string2 + this.st.sval;
                }
                this.st.pushBack();
                this.st.sval = string2;
            }
            return this.st.sval;
        }

        private void syntax(String string) throws ConfigurationException {
            this.oops("expected " + string + ", found " + this.describeCurrentToken());
        }

        private String describeCurrentToken() {
            switch (this.st.ttype) {
                case -1: {
                    return "end of file";
                }
                case 10: {
                    return "end of line";
                }
                case -3: {
                    return "'" + this.st.sval + "'";
                }
                case -2: {
                    return "'" + this.st.nval + "'";
                }
                case 34: {
                    return "\"" + this.st.sval + "\"";
                }
                case 39: {
                    return "'" + this.st.sval.charAt(0) + "'";
                }
            }
            return "'" + (char)this.st.ttype + "'";
        }

        private void oops(String string) throws ConfigurationException {
            ConfigurationFile.this.oops(string, this.st.lineno(), ConfigurationFile.this.override, null);
        }
    }

    private class ArrayConstructor
    extends Call {
        private final String typeName;
        private Class type;

        ArrayConstructor(String string, ParseNode[] parseNodeArray, int n) {
            super(parseNodeArray, n);
            this.typeName = string;
        }

        Class resolve(Entry entry) throws ConfigurationException {
            this.type = ConfigurationFile.this.findClass(this.typeName, this.lineno, this.override);
            Class[] classArray = this.resolveArgs(entry);
            for (int i = 0; i < classArray.length; ++i) {
                Object object;
                if (ConfigurationFile.assignable(classArray[i], this.type)) continue;
                if (this.args[i] instanceof Literal && (object = ConfigurationFile.this.narrowingAssignable(this.args[i].eval(Configuration.NO_DATA), this.type)) != null) {
                    this.args[i] = new Literal(Utilities.getPrimitiveType(object.getClass()), object, this.args[i].lineno);
                    continue;
                }
                this.oops("array element " + i + " has incorrect type", this.args[i].lineno);
            }
            return Array.newInstance(this.type, 0).getClass();
        }

        Object eval(Object object) throws ConfigurationException {
            Object[] objectArray = this.evalArgs(object);
            Object object2 = Array.newInstance(this.type, this.args.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Class<?> clazz;
                Object object3 = objectArray[i];
                Class<?> clazz2 = clazz = object3 == null ? null : object3.getClass();
                if (!this.type.isPrimitive() && !ConfigurationFile.assignable(clazz, this.type)) {
                    this.oops("array element " + i + " has incorrect type", this.args[i].lineno);
                }
                Array.set(object2, i, object3);
            }
            return object2;
        }
    }

    private class MethodCall
    extends Call {
        final String fullName;
        private Method method;

        MethodCall(String string, ParseNode[] parseNodeArray, int n) {
            super(parseNodeArray, n);
            this.fullName = string;
        }

        Class resolve(Entry entry) throws ConfigurationException {
            this.method = ConfigurationFile.this.findMethod(this.fullName, this.resolveArgs(entry), this.lineno, this.override);
            Class<?> clazz = this.method.getReturnType();
            if (clazz == Void.TYPE) {
                this.oops("method has void return type: " + this.fullName);
            }
            return clazz;
        }

        Object eval(Object object) throws ConfigurationException {
            Throwable throwable;
            Object[] objectArray = this.evalArgs(object);
            try {
                return this.method.invoke(null, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
            }
            catch (Exception exception) {
                throwable = exception;
            }
            this.oops("problem invoking method " + this.fullName, throwable);
            return null;
        }
    }

    private class ConstructorCall
    extends Call {
        private final String typeName;
        private Constructor constructor;

        ConstructorCall(String string, ParseNode[] parseNodeArray, int n) {
            super(parseNodeArray, n);
            this.typeName = string;
        }

        Class resolve(Entry entry) throws ConfigurationException {
            this.constructor = ConfigurationFile.this.findConstructor(this.typeName, this.resolveArgs(entry), this.lineno, this.override);
            return this.constructor.getDeclaringClass();
        }

        Object eval(Object object) throws ConfigurationException {
            Throwable throwable;
            Object[] objectArray = this.evalArgs(object);
            try {
                return this.constructor.newInstance(objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
            }
            catch (Exception exception) {
                throwable = exception;
            }
            this.oops("problem invoking constructor for " + this.typeName, throwable);
            return null;
        }
    }

    private abstract class Call
    extends ParseNode {
        final ParseNode[] args;

        Call(ParseNode[] parseNodeArray, int n) {
            super(n);
            this.args = parseNodeArray;
        }

        boolean isConstant() {
            return false;
        }

        Class[] resolveArgs(Entry entry) throws ConfigurationException {
            Class[] classArray = new Class[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                classArray[i] = this.args[i].resolve(entry);
            }
            return classArray;
        }

        Object[] evalArgs(Object object) throws ConfigurationException {
            Object[] objectArray = new Object[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                objectArray[i] = this.args[i].eval(object);
            }
            return objectArray;
        }
    }

    private class Cast
    extends ParseNode {
        private final String typeName;
        private final boolean isArray;
        private final ParseNode arg;
        private Class type;

        Cast(String string, boolean bl, ParseNode parseNode, int n) {
            super(n);
            this.typeName = string;
            this.isArray = bl;
            this.arg = parseNode;
        }

        Class resolve(Entry entry) throws ConfigurationException {
            Class clazz;
            this.type = ConfigurationFile.this.findClass(this.typeName, this.lineno, this.override);
            if (this.isArray) {
                this.type = Array.newInstance(this.type, 0).getClass();
            }
            if (this.type == (clazz = this.arg.resolve(entry))) {
                return this.type;
            }
            if (this.type.isPrimitive()) {
                if (this.type != Boolean.TYPE && clazz != Boolean.TYPE && clazz != null && clazz.isPrimitive()) {
                    return this.type;
                }
            } else {
                if (clazz == null || this.type.isAssignableFrom(clazz) || clazz.isAssignableFrom(this.type)) {
                    return this.type;
                }
                if (this.type.isInterface() && clazz.isInterface() ? ConfigurationFile.compatibleMethods(this.type, clazz) : this.type.isInterface() && !clazz.isArray() && !Modifier.isFinal(clazz.getModifiers()) || clazz.isInterface() && !this.type.isArray() && !Modifier.isFinal(this.type.getModifiers())) {
                    return this.type;
                }
            }
            this.oops("cannot convert '" + Utilities.typeString(clazz) + "' to '" + Utilities.typeString(this.type) + "'");
            return null;
        }

        boolean isConstant() throws ConfigurationException {
            return this.arg.isConstant();
        }

        Object eval(Object object) throws ConfigurationException {
            Object object2 = this.arg.eval(object);
            if (this.type.isPrimitive()) {
                if (Utilities.getPrimitiveType(object2.getClass()) != this.type) {
                    object2 = ConfigurationFile.convertPrimitive(object2, this.type);
                }
            } else if (object2 != null && !this.type.isInstance(object2)) {
                this.oops("cannot convert '" + Utilities.typeString(object2.getClass()) + "' to '" + Utilities.typeString(this.type) + "'");
            }
            return object2;
        }
    }

    private class ClassLiteral
    extends ParseNode {
        private final String className;
        private final boolean isArray;
        private Class value;

        ClassLiteral(String string, boolean bl, int n) {
            super(n);
            this.className = string;
            this.isArray = bl;
        }

        Class resolve(Entry entry) throws ConfigurationException {
            Class<?> clazz = ConfigurationFile.this.findClass(this.className, this.lineno, this.override);
            if (this.isArray) {
                clazz = Array.newInstance(clazz, 0).getClass();
            }
            this.value = clazz;
            return class$java$lang$Class == null ? (class$java$lang$Class = ConfigurationFile.class$("java.lang.Class")) : class$java$lang$Class;
        }

        boolean isConstant() {
            return true;
        }

        Object eval(Object object) {
            return this.value;
        }
    }

    private class StringLiteral
    extends ParseNode {
        private final String value;

        StringLiteral(String string, int n) {
            super(n);
            this.value = string;
        }

        Class resolve(Entry entry) {
            return class$java$lang$String == null ? (class$java$lang$String = ConfigurationFile.class$("java.lang.String")) : class$java$lang$String;
        }

        boolean isConstant() {
            return this.value.indexOf("${") < 0;
        }

        Object eval(Object object) throws ConfigurationException {
            return ConfigurationFile.this.expandStringProperties(this.value, this.lineno);
        }
    }

    private class ThisRef
    extends Literal {
        ThisRef(int n) {
            super(class$net$jini$config$ConfigurationFile == null ? (class$net$jini$config$ConfigurationFile = ConfigurationFile.class$("net.jini.config.ConfigurationFile")) : class$net$jini$config$ConfigurationFile, ConfigurationFile.this, n);
        }
    }

    private class Literal
    extends ParseNode {
        private final Class type;
        private final Object value;

        Literal(Class clazz, Object object, int n) {
            super(n);
            this.type = clazz;
            this.value = object;
        }

        Class resolve(Entry entry) {
            return this.type;
        }

        boolean isConstant() {
            return true;
        }

        Object eval(Object object) {
            return this.value;
        }
    }

    private class NameRef
    extends ParseNode {
        private final String name;
        private final String fullName;
        private Entry entry;
        private Field field;

        NameRef(String string, String string2, int n) {
            super(n);
            this.name = string2;
            this.fullName = string2.indexOf(46) < 0 ? string + '.' + string2 : string2;
        }

        Class resolve(Entry entry) throws ConfigurationException {
            this.entry = (Entry)ConfigurationFile.this.entries.get(this.fullName);
            if (this.entry != null) {
                Class clazz = this.entry.resolve(entry);
                if (this.entry.getRefersToData()) {
                    if (entry.isStatic) {
                        this.oops("static entry '" + entry.fullName + "' cannot refer to entry '" + this.fullName + "', which uses '$data'");
                    }
                    entry.setRefersToData();
                }
                return clazz;
            }
            if (this.name.equals("$data")) {
                return class$java$lang$Object == null ? (class$java$lang$Object = ConfigurationFile.class$("java.lang.Object")) : class$java$lang$Object;
            }
            if (this.name.equals("$loader")) {
                return class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ConfigurationFile.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader;
            }
            if (this.name.startsWith("$") && this.name.indexOf(46) == -1) {
                try {
                    return ConfigurationFile.this.getSpecialEntryType(this.name);
                }
                catch (NoSuchEntryException noSuchEntryException) {
                    this.oops("entry not found: " + this.name, this.lineno);
                }
                catch (ConfigurationException configurationException) {
                    this.oops("problem referring to entry '" + this.name + "'", configurationException);
                }
                catch (RuntimeException runtimeException) {
                    this.oops("problem referring to entry '" + this.name + "'", runtimeException);
                }
                return null;
            }
            this.field = ConfigurationFile.this.findField(this.name, this.lineno, this.override);
            return this.field.getType();
        }

        boolean isConstant() throws ConfigurationException {
            return this.entry != null && this.entry.isConstant();
        }

        Object eval(Object object) throws ConfigurationException {
            if (this.entry != null) {
                return this.entry.eval(object);
            }
            if (this.field != null) {
                try {
                    return this.field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.oops("problem accessing field '" + this.name + "'", illegalAccessException);
                    return null;
                }
            }
            if (this.name.equals("$data")) {
                if (object == Configuration.NO_DATA) {
                    this.oops("no data specified for '$data'");
                }
                return object;
            }
            if (this.name.equals("$loader")) {
                SecurityManager securityManager;
                if (!ConfigurationFile.this.nonNullLoaderSupplied && (securityManager = System.getSecurityManager()) != null) {
                    securityManager.checkPermission(getClassLoaderPermission);
                }
                return ConfigurationFile.this.cl;
            }
            try {
                return ConfigurationFile.this.getSpecialEntry(this.name);
            }
            catch (ConfigurationException configurationException) {
                this.oops("problem referring to entry '" + this.name + "'", configurationException);
            }
            catch (RuntimeException runtimeException) {
                this.oops("problem referring to entry '" + this.name + "'", runtimeException);
            }
            return null;
        }
    }

    private class Entry
    extends ParseNode {
        final String component;
        final String fullName;
        private final ParseNode node;
        final boolean isPrivate;
        final boolean isStatic;
        final boolean isOverride;
        private Class type;
        private boolean resolved;
        private boolean resolving;
        private boolean isConstant;
        private boolean refersToData;
        private boolean evaluated;
        private boolean evaluating;
        private Object value;

        Entry(String string, String string2, boolean bl, boolean bl2, boolean bl3, int n, Parser parser) throws ConfigurationException, IOException {
            super(n);
            this.component = string;
            this.fullName = string2;
            this.isPrivate = bl;
            this.isStatic = bl2;
            this.isOverride = bl3;
            this.node = parser.parseExpr(this);
        }

        boolean getRefersToData() {
            return this.refersToData;
        }

        void setRefersToData() {
            this.refersToData = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Class resolve(Entry entry) throws ConfigurationException {
            Object object = ConfigurationFile.this.resolveLock;
            synchronized (object) {
                if (!this.resolved) {
                    if (this.resolving) {
                        this.oops("entry with circular reference: " + this.fullName);
                    }
                    this.resolving = true;
                    try {
                        this.type = this.node.resolve(this);
                        this.isConstant = this.node.isConstant();
                        Object var4_3 = null;
                        this.resolving = false;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        this.resolving = false;
                        throw throwable;
                    }
                    this.resolved = true;
                }
            }
            return this.type;
        }

        boolean isConstant() throws ConfigurationException {
            this.resolve(this);
            return this.isConstant;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object eval(Object object) throws ConfigurationException {
            this.resolve(this);
            if (!this.isStatic) {
                return this.node.eval(object);
            }
            Entry entry = this;
            synchronized (entry) {
                if (!this.evaluated) {
                    if (this.evaluating) {
                        this.oops("entry with circular reference: " + this.fullName);
                    }
                    this.evaluating = true;
                    try {
                        this.value = this.node.eval(Configuration.NO_DATA);
                        Object var4_3 = null;
                        this.evaluating = false;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        this.evaluating = false;
                        throw throwable;
                    }
                    this.evaluated = true;
                }
            }
            return this.value;
        }
    }

    private abstract class ParseNode {
        final int lineno;
        final int override;

        ParseNode(int n) {
            this.lineno = n;
            this.override = ConfigurationFile.this.override;
        }

        abstract Class resolve(Entry var1) throws ConfigurationException;

        abstract boolean isConstant() throws ConfigurationException;

        abstract Object eval(Object var1) throws ConfigurationException;

        void oops(String string) throws ConfigurationException {
            ConfigurationFile.this.oops(string, this.lineno, this.override, null);
        }

        void oops(String string, int n) throws ConfigurationException {
            ConfigurationFile.this.oops(string, n, this.override, null);
        }

        void oops(String string, Throwable throwable) throws ConfigurationException {
            ConfigurationFile.this.oops(string, this.lineno, this.override, throwable);
        }
    }

    private static class PushbackStreamTokenizer
    extends StreamTokenizer {
        private boolean gotToken;
        private boolean pushedBack;
        private double savedNval;
        private String savedSval;
        private int savedTtype;
        private int savedLineno;

        PushbackStreamTokenizer(Reader reader) {
            super(reader);
        }

        public int nextToken() throws IOException {
            if (this.pushedBack) {
                this.nval = this.savedNval;
                this.sval = this.savedSval;
                this.ttype = this.savedTtype;
                this.pushedBack = false;
            } else {
                this.savedNval = this.nval;
                this.savedSval = this.sval;
                this.savedTtype = this.ttype;
                this.savedLineno = this.lineno();
                super.nextToken();
                this.gotToken = true;
            }
            return this.ttype;
        }

        public void pushBack() {
            if (this.gotToken && !this.pushedBack) {
                double d = this.savedNval;
                this.savedNval = this.nval;
                this.nval = d;
                String string = this.savedSval;
                this.savedSval = this.sval;
                this.sval = string;
                int n = this.savedTtype;
                this.savedTtype = this.ttype;
                this.ttype = n;
                this.pushedBack = true;
            }
        }

        public int lineno() {
            return this.pushedBack ? this.savedLineno : super.lineno();
        }
    }
}

