/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.proxytrust;

import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.security.Permission;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.export.Exporter;
import net.jini.security.Security;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ProxyTrust;
import net.jini.security.proxytrust.ProxyTrustInvocationHandler;
import net.jini.security.proxytrust.ServerProxyTrust;
import net.jini.security.proxytrust.TrustEquivalence;

public class ProxyTrustExporter
implements Exporter {
    private static final Permission loaderPermission = new RuntimePermission("getClassLoader");
    private static final Executor systemThreadPool = (Executor)Security.doPrivileged(new GetThreadPoolAction(false));
    private static final Set refs = new HashSet();
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static Reaper reaper = null;
    private final Exporter mainExporter;
    private final Exporter bootExporter;
    private final ClassLoader loader;
    private WeakRef ref = null;

    public ProxyTrustExporter(Exporter exporter, Exporter exporter2) {
        this(exporter, exporter2, null);
    }

    public ProxyTrustExporter(Exporter exporter, Exporter exporter2, ClassLoader classLoader) {
        if (exporter == null || exporter2 == null) {
            throw new NullPointerException("exporter is null");
        }
        this.mainExporter = exporter;
        this.bootExporter = exporter2;
        this.loader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Remote export(Remote remote) throws ExportException {
        Object object;
        block21: {
            Remote remote2;
            block22: {
                Object object2;
                if (remote != null && !(remote instanceof ServerProxyTrust)) {
                    throw new IllegalArgumentException("must implement ServerProxyTrust");
                }
                if (this.loader == null && (object2 = System.getSecurityManager()) != null) {
                    ((SecurityManager)object2).checkPermission(loaderPermission);
                }
                object2 = this.mainExporter.export(remote);
                Class<?> clazz = object2.getClass();
                LinkedList linkedList = new LinkedList();
                remote2 = null;
                boolean bl = false;
                try {
                    Object object3;
                    if (!(object2 instanceof RemoteMethodControl)) {
                        throw new ExportException("main proxy must implement RemoteMethodControl");
                    }
                    if (!(object2 instanceof TrustEquivalence)) {
                        throw new ExportException("main proxy must implement TrustEquivalence");
                    }
                    boolean bl2 = !Modifier.isPublic(clazz.getModifiers());
                    for (object3 = clazz; object3 != null; object3 = ((Class)object3).getSuperclass()) {
                        object = ((Class)object3).getInterfaces();
                        int n = ((Class<?>[])object).length;
                        while (--n >= 0) {
                            if (bl2 && !Modifier.isPublic(object[n].getModifiers())) {
                                throw new ExportException("main proxy implements non-public interface");
                            }
                            linkedList.remove(object[n]);
                            linkedList.addFirst(object[n]);
                        }
                    }
                    this.ref = new WeakRef(remote);
                    object3 = refs;
                    synchronized (object3) {
                        if (reaper == null) {
                            reaper = new Reaper();
                            systemThreadPool.execute(reaper, "ProxyTrustExporter.Reaper");
                        }
                        refs.add(this.ref);
                    }
                    remote2 = this.bootExporter.export(this.ref.boot);
                    if (!(remote2 instanceof ProxyTrust)) {
                        throw new ExportException("bootstrap proxy must implement ProxyTrust");
                    }
                    if (!(remote2 instanceof RemoteMethodControl)) {
                        throw new ExportException("bootstrap proxy must implement RemoteMethodControl");
                    }
                    if (!(remote2 instanceof TrustEquivalence)) {
                        throw new ExportException("bootstrap proxy must implement TrustEquivalence");
                    }
                    object3 = (Remote)Proxy.newProxyInstance(this.loader != null ? this.loader : clazz.getClassLoader(), linkedList.toArray(new Class[linkedList.size()]), (InvocationHandler)new ProxyTrustInvocationHandler((RemoteMethodControl)object2, (ProxyTrust)remote2));
                    bl = true;
                    object = object3;
                    Object var13_13 = null;
                    if (bl) break block21;
                    if (this.ref == null) break block22;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        throw new ExportException("export failed", illegalArgumentException);
                    }
                    catch (Throwable throwable) {
                        block23: {
                            Object var13_14 = null;
                            if (bl) break block23;
                            if (this.ref != null) {
                                this.ref.enqueue();
                            }
                            if (remote2 != null) {
                                this.bootExporter.unexport(true);
                            }
                            this.mainExporter.unexport(true);
                        }
                        throw throwable;
                    }
                }
                this.ref.enqueue();
            }
            if (remote2 != null) {
                this.bootExporter.unexport(true);
            }
            this.mainExporter.unexport(true);
        }
        return object;
    }

    public synchronized boolean unexport(boolean bl) {
        if (!this.mainExporter.unexport(bl)) {
            return false;
        }
        this.bootExporter.unexport(true);
        if (this.ref != null) {
            this.ref.enqueue();
        }
        return true;
    }

    private static class ProxyTrustImpl
    implements ProxyTrust {
        private final Reference ref;

        ProxyTrustImpl(Reference reference) {
            this.ref = reference;
        }

        public TrustVerifier getProxyVerifier() throws RemoteException {
            ServerProxyTrust serverProxyTrust = (ServerProxyTrust)this.ref.get();
            if (serverProxyTrust == null) {
                throw new UnsupportedOperationException("impl is gone");
            }
            return serverProxyTrust.getProxyVerifier();
        }
    }

    private static class Reaper
    implements Runnable {
        Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Reference reference = queue.remove();
                    reference.clear();
                    Set set = refs;
                    synchronized (set) {
                        refs.remove(reference);
                        if (refs.isEmpty()) {
                            ProxyTrustExporter.reaper = null;
                            return;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private static class WeakRef
    extends WeakReference {
        ProxyTrust boot = new ProxyTrustImpl(this);

        WeakRef(Remote remote) {
            super(remote, queue);
        }

        public void clear() {
            super.clear();
            this.boot = null;
        }
    }
}

