/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequest;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ActionRequestCreator;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ResponseHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.ServiceAction;
import com.mathworks.toolbox.distcomp.admincenter.services.action.SystemErrorHandler;
import com.mathworks.toolbox.distcomp.admincenter.services.action.TargetSource;
import com.mathworks.toolbox.distcomp.admincenter.services.model.ClientMonitor;
import com.mathworks.toolbox.distcomp.admincenter.services.model.SubmissionProgressListener;
import com.mathworks.toolbox.distcomp.admincenter.services.view.AdminUserPanel;
import com.mathworks.toolbox.distcomp.admincenter.services.view.ServiceDialog;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.control.servicerequest.JobManagerServiceRequest;
import com.mathworks.toolbox.distcomp.control.servicerequest.ServiceRequest;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideRelatedPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;

class RestartJMAction
extends ServiceAction {
    private static final Dimension DEFAULT_DIALOG_SIZE = new Dimension(400, 450);

    RestartJMAction(TargetSource targetSource, String string, ResponseHandler responseHandler, ClientMonitor clientMonitor, SubmissionProgressListener submissionProgressListener, SystemErrorHandler systemErrorHandler) {
        super(ResourceStatics.sRes.getString("module.jm.action.restart"), targetSource, string, new RestartJMRequestCreator(), responseHandler, clientMonitor, submissionProgressListener, systemErrorHandler);
    }

    private static class RestartJMDialog
    extends ServiceDialog<Object[]> {
        private static final String HELP = "AC_RESTART_JM";

        protected RestartJMDialog(Frame frame, ClientMonitor clientMonitor, TargetSource targetSource) {
            super(frame, ResourceStatics.sRes.getString("services.dialog.restartjm"), ResourceStatics.sRes.getString("services.dialog.okay"), HELP, new RestartDialogContent(clientMonitor, targetSource));
        }

        private static class RestartDialogContent
        extends StyleGuidePanel
        implements ServiceDialog.ServiceDialogContent<Object[]> {
            private final MJRadioButton fStopButton = new MJRadioButton(ResourceStatics.sRes.getString("services.dialog.restartjm.stop"));
            private AdminUserPanel fAdminUserPanel;
            private MJRadioButton fDestroyButton;

            RestartDialogContent(ClientMonitor clientMonitor, TargetSource targetSource) {
                this.fStopButton.setSelected(true);
                StyleGuideRelatedPanel styleGuideRelatedPanel = new StyleGuideRelatedPanel();
                styleGuideRelatedPanel.addLine((JComponent)new MJMultilineLabel(ResourceStatics.sRes.getString("services.dialog.restartjm.stop.note"), true));
                this.fDestroyButton = new MJRadioButton(ResourceStatics.sRes.getString("services.dialog.restartjm.destroy"));
                this.fAdminUserPanel = new AdminUserPanel();
                Collection<ServiceInfo> collection = targetSource.getTargets();
                Host host = null;
                for (ServiceInfo serializable2 : collection) {
                    if (!(serializable2 instanceof JobManagerServiceInfo)) continue;
                    host = serializable2.getHost();
                    break;
                }
                for (ServiceInfo serviceInfo : clientMonitor.getServiceInfo()) {
                    if (!(serviceInfo instanceof MDCSServiceInfo) || !serviceInfo.getHost().equals(host)) continue;
                    this.fAdminUserPanel.setSelectedHost((MDCSServiceInfo)serviceInfo);
                    break;
                }
                this.fAdminUserPanel.setEnabled(this.fDestroyButton.isSelected());
                this.fStopButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RestartDialogContent.this.fAdminUserPanel.setEnabled(RestartDialogContent.this.fDestroyButton.isSelected());
                    }
                });
                this.fDestroyButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RestartDialogContent.this.fAdminUserPanel.setEnabled(RestartDialogContent.this.fDestroyButton.isSelected());
                    }
                });
                StyleGuideRelatedPanel styleGuideRelatedPanel2 = new StyleGuideRelatedPanel();
                styleGuideRelatedPanel2.addLine((JComponent)new MJLabel("<html>" + ResourceStatics.sRes.getString("services.dialog.restartjm.destroy.note") + "</html>"));
                styleGuideRelatedPanel2.addLine((JComponent)((Object)this.fAdminUserPanel), 8);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add((AbstractButton)this.fStopButton);
                buttonGroup.add((AbstractButton)this.fDestroyButton);
                MJLabel mJLabel = new MJLabel("<html><b>Note: </b>" + ResourceStatics.sRes.getString("services.dialog.restartjm.note") + "</html>");
                this.addLine((JComponent)this.fStopButton);
                this.addLine((JComponent)((Object)styleGuideRelatedPanel));
                this.addLine((JComponent)this.fDestroyButton);
                this.addLine((JComponent)((Object)styleGuideRelatedPanel2));
                this.addLine((JComponent)mJLabel);
                this.addLine((JComponent)((Object)new StyleGuideEmptyPanel()), 8);
                this.fStopButton.setName("stopButton");
                this.fDestroyButton.setName("destroyButton");
            }

            @Override
            public JComponent getComponent() {
                return this;
            }

            @Override
            public Object[] getValue() {
                RestartChoice restartChoice = this.fStopButton.isSelected() ? RestartChoice.STOP_RESUME : RestartChoice.DESTROY_START;
                char[] cArray = this.fAdminUserPanel.getValue();
                return new Object[]{restartChoice, cArray};
            }

            @Override
            public void registerOkayButton(final MJButton mJButton) {
                this.fStopButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        mJButton.setEnabled(true);
                    }
                });
                this.fDestroyButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RestartDialogContent.this.fAdminUserPanel.registerOkayButton(mJButton);
                    }
                });
            }
        }
    }

    private static enum RestartChoice {
        STOP_RESUME,
        DESTROY_START;

    }

    private static class RestartJMRequestCreator
    implements ActionRequestCreator {
        private RestartJMRequestCreator() {
        }

        @Override
        public ActionRequest createActionServiceRequest(ActionEvent actionEvent, ClientMonitor clientMonitor, TargetSource targetSource, SystemErrorHandler systemErrorHandler) {
            RestartJMDialog restartJMDialog = new RestartJMDialog(MJAbstractAction.getFrame((ActionEvent)actionEvent), clientMonitor, targetSource);
            restartJMDialog.pack();
            restartJMDialog.setSize(DEFAULT_DIALOG_SIZE);
            restartJMDialog.setLocationRelativeTo(MJAbstractAction.getFrame((ActionEvent)actionEvent));
            restartJMDialog.setVisible(true);
            ArrayList<ServiceRequest> arrayList = new ArrayList<ServiceRequest>();
            if (!restartJMDialog.isCancelled()) {
                for (ServiceInfo serviceInfo : targetSource.getTargets()) {
                    Object[] objectArray = (Object[])restartJMDialog.getValue();
                    RestartChoice restartChoice = (RestartChoice)((Object)objectArray[0]);
                    switch (restartChoice) {
                        case DESTROY_START: {
                            JobManagerServiceRequest jobManagerServiceRequest = JobManagerServiceRequest.createHardRestartRequest(serviceInfo.getServiceName(), serviceInfo.getHost(), clientMonitor.getBaseport());
                            char[] cArray = (char[])objectArray[1];
                            if (cArray == null || cArray.length == 0) {
                                jobManagerServiceRequest.registerAdminUser(false);
                            } else {
                                jobManagerServiceRequest.registerAdminUser(true);
                                jobManagerServiceRequest.setAdminPassword(cArray);
                            }
                            arrayList.add(jobManagerServiceRequest);
                            break;
                        }
                        case STOP_RESUME: {
                            JobManagerServiceRequest jobManagerServiceRequest = JobManagerServiceRequest.createSoftRestartRequest(serviceInfo.getServiceName(), serviceInfo.getHost(), clientMonitor.getBaseport());
                            jobManagerServiceRequest.registerAdminUser(false);
                            arrayList.add(jobManagerServiceRequest);
                        }
                    }
                }
            }
            return new ActionRequest(clientMonitor, restartJMDialog.isCancelled(), arrayList, systemErrorHandler);
        }
    }
}

