/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.CompletionObserver;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.Node;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.StandardTestInstantiator;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.TestExecutor;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.TestInstantiator;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.internal.FileParser;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.PackageInfo;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.RunIdentifier;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.Test;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.util.AlreadyInUseException;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ComputeCluster;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ComputeNode;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.JobManager;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.RunConditions;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.Scheduler;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestInvoker;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestingCallback;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestingToken;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class TestRunner
implements TestInvoker,
CompletionObserver {
    private FileParser fFileParser;
    private boolean fIsAvailable = true;
    private InetAddress fLocalHost = null;
    private int fBasePort = -1;

    public TestRunner() {
        this(null);
    }

    public TestRunner(String string) {
        try {
            this.fLocalHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Cannot resolve local machine.", unknownHostException);
        }
        this.fFileParser = new FileParser(string);
    }

    @Override
    public TestingToken runTests(ComputeCluster computeCluster, TestingCallback testingCallback, RunConditions runConditions) {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "TestRunner: In the method runTests.");
        if (computeCluster == null) {
            throw new IllegalArgumentException("cluster was null");
        }
        Scheduler scheduler = computeCluster.getScheduler();
        this.fBasePort = 27350;
        if (scheduler instanceof JobManager) {
            this.fBasePort = ((JobManager)scheduler).getBasePort();
        }
        if (testingCallback == null) {
            throw new IllegalArgumentException("callback was null");
        }
        if (runConditions == null) {
            // empty if block
        }
        Vector<Node> vector = this.createNodeList(computeCluster.getAllNodes());
        StandardTestInstantiator standardTestInstantiator = new StandardTestInstantiator();
        Collection<Test> collection = ((TestInstantiator)standardTestInstantiator).createTestList(vector);
        RunIdentifier runIdentifier = new RunIdentifier();
        for (Test test : collection) {
            test.setRunID(runIdentifier);
            test.setTestingCallback(testingCallback);
        }
        Object object = null;
        try {
            object = new TestExecutor(this);
            this.fIsAvailable = false;
            ((TestExecutor)object).submit(collection);
        }
        catch (AlreadyInUseException alreadyInUseException) {
            this.fIsAvailable = false;
        }
        return object;
    }

    @Override
    public void allComplete() {
        this.fIsAvailable = true;
    }

    public boolean isAvailable() {
        return this.fIsAvailable;
    }

    private Vector<Node> createNodeList(ComputeNode[] computeNodeArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ComputeNode computeNode : computeNodeArray) {
            hashSet.add(computeNode.getHostname());
        }
        Vector vector = new Vector();
        for (String string : hashSet) {
            vector.add(new Node(string, this.fBasePort, false, this.fFileParser.createCommandSet(string)));
        }
        String string = this.fLocalHost.getHostName();
        vector.add(0, new Node(string, this.fBasePort, true, this.fFileParser.createCommandSet("client")));
        return vector;
    }
}

