/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.model;

import com.mathworks.toolbox.distcomp.admincenter.testing.model.NodeData;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ReturnStatus;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestResult;
import java.io.Serializable;
import java.util.Date;

public class TestResultData
implements Serializable {
    private static final long serialVersionUID = 1754025775906280468L;
    private final NodeData fExecutorNode;
    private final NodeData fReceivingNode;
    private final TestCategory fTestCategory;
    private final ReturnStatus fReturnStatus;
    private final Date fStartTime;
    private final Date fStopTime;
    private final String fMessage;
    private final String fTestDescription;

    public TestResultData(TestResult testResult) {
        this.fExecutorNode = new NodeData(testResult.getExecutingNode());
        this.fReceivingNode = new NodeData(testResult.getReceivingNode());
        this.fTestCategory = testResult.getTestCategory();
        this.fReturnStatus = testResult.getReturnStatus();
        this.fStartTime = new Date(testResult.getStartTime().getTime());
        this.fStopTime = new Date(testResult.getStopTime().getTime());
        this.fMessage = testResult.getMessage();
        this.fTestDescription = testResult.getName();
    }

    public NodeData getExecutorNode() {
        return this.fExecutorNode;
    }

    public NodeData getReceivingNode() {
        return this.fReceivingNode;
    }

    public TestCategory getTestCategory() {
        return this.fTestCategory;
    }

    public ReturnStatus getReturnStatus() {
        return this.fReturnStatus;
    }

    public Date getStartTime() {
        return this.fStartTime;
    }

    public Date getStopTime() {
        return this.fStopTime;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String getTestDescription() {
        return this.fTestDescription;
    }

    public String toString() {
        return this.getMessage();
    }
}

