/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.view;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.admincenter.resources.ResourceStatics;
import com.mathworks.toolbox.distcomp.admincenter.resources.icons.AdminCenterIcon;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.ClusterData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultData;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultDataFilter;
import com.mathworks.toolbox.distcomp.admincenter.testing.model.TestResultsContainer;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ReturnStatus;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideRelatedPanel;
import java.text.DateFormat;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;

class SummaryReport
extends StyleGuidePanel {
    private final MJLabel fRunDateLabel = new MJLabel();
    private final MJLabel fElapsedLabel = new MJLabel();
    private final MJLabel fNodesLabel = new MJLabel();
    private final MJLabel fTotalLabel = new MJLabel();
    private final MJLabel fPassedLabel = new MJLabel();
    private final MJLabel fInfoOnlyLabel = new MJLabel();
    private final MJLabel fWarningLabel = new MJLabel();
    private final MJLabel fFailedLabel = new MJLabel();
    private final MJLabel fSkippedLabel = new MJLabel();

    SummaryReport(ClusterData clusterData) {
        if (clusterData == null || clusterData.getTestResultsContainer() == null) {
            throw new IllegalArgumentException("cluster cannot be null, cannot have a null results container");
        }
        TestResultsContainer testResultsContainer = clusterData.getTestResultsContainer();
        this.setBorder(new TitledBorder(ResourceStatics.sRes.getString("results.summary.title")));
        AbstractStyleGuidePanel abstractStyleGuidePanel = this.createTestsRunInfoPanel(clusterData);
        AbstractStyleGuidePanel abstractStyleGuidePanel2 = this.createTestsPassFailInfoPanel(testResultsContainer);
        this.addLine((JComponent[][])new JComponent[][]{{abstractStyleGuidePanel2, null, abstractStyleGuidePanel}}, 8, 1);
        this.setName("TestConnectivityDialog.SummaryReport");
        this.fElapsedLabel.setName("TestConnectivityDialog.ElapsedLabel");
        this.fNodesLabel.setName("TestConnectivityDialog.NodesLabel");
        this.fRunDateLabel.setName("TestConnectivityDialog.RunDateLabel");
        this.fTotalLabel.setName("TestConnectivityDialog.TotalLabel");
    }

    private AbstractStyleGuidePanel createTestsPassFailInfoPanel(TestResultsContainer testResultsContainer) {
        int n = testResultsContainer.getResultsCount();
        this.fTotalLabel.setText(MessageFormat.format(ResourceStatics.sRes.getString("results.summary.number"), n));
        this.fPassedLabel.setText(MessageFormat.format(ResourceStatics.sRes.getString("results.summary.SUCCESS"), SummaryReport.getNumberOfStatus(testResultsContainer, ReturnStatus.SUCCESS)));
        MJLabel mJLabel = null;
        if (SummaryReport.getNumberOfStatus(testResultsContainer, ReturnStatus.SUCCESS) == n) {
            mJLabel = new MJLabel((Icon)AdminCenterIcon.SUCCESS.getIcon());
        }
        this.fFailedLabel.setText(MessageFormat.format(ResourceStatics.sRes.getString("results.summary.ERROR"), SummaryReport.getNumberOfStatus(testResultsContainer, ReturnStatus.ERROR)));
        MJLabel mJLabel2 = null;
        if (SummaryReport.getNumberOfStatus(testResultsContainer, ReturnStatus.ERROR) > 0) {
            mJLabel2 = new MJLabel((Icon)AdminCenterIcon.ERROR.getIcon());
        }
        this.fWarningLabel.setText(MessageFormat.format(ResourceStatics.sRes.getString("results.summary.WARNING"), SummaryReport.getNumberOfStatus(testResultsContainer, ReturnStatus.WARNING)));
        this.fSkippedLabel.setText(MessageFormat.format(ResourceStatics.sRes.getString("results.summary.SKIPPED"), SummaryReport.getNumberOfStatus(testResultsContainer, ReturnStatus.SKIPPED)));
        this.fInfoOnlyLabel.setText(MessageFormat.format(ResourceStatics.sRes.getString("results.summary.INFO"), SummaryReport.getNumberOfStatus(testResultsContainer, ReturnStatus.INFO)));
        StyleGuideRelatedPanel styleGuideRelatedPanel = new StyleGuideRelatedPanel();
        styleGuideRelatedPanel.addLine(new JComponent[][]{{null, this.fTotalLabel}, {mJLabel, this.fPassedLabel}, {mJLabel2, this.fFailedLabel}, {null, this.fWarningLabel}, {null, this.fSkippedLabel}, {null, this.fInfoOnlyLabel}});
        return styleGuideRelatedPanel;
    }

    private AbstractStyleGuidePanel createTestsRunInfoPanel(ClusterData clusterData) {
        TestResultsContainer testResultsContainer = clusterData.getTestResultsContainer();
        String string = DateFormat.getDateTimeInstance(2, 2).format(testResultsContainer.getStartTime());
        this.fRunDateLabel.setText(MessageFormat.format(ResourceStatics.sRes.getString("results.summary.started"), string));
        this.fElapsedLabel.setText(String.format(ResourceStatics.sRes.getString("results.summary.elapsed"), Float.valueOf((float)testResultsContainer.getRunTime() / 1000.0f)));
        this.fNodesLabel.setText(MessageFormat.format(ResourceStatics.sRes.getString("results.summary.nodes"), clusterData.getNodeCount()));
        StyleGuideRelatedPanel styleGuideRelatedPanel = new StyleGuideRelatedPanel();
        styleGuideRelatedPanel.addLine((JComponent)this.fRunDateLabel);
        styleGuideRelatedPanel.addLine((JComponent)this.fElapsedLabel);
        styleGuideRelatedPanel.addLine((JComponent)this.fNodesLabel);
        styleGuideRelatedPanel.addLine((JComponent)((Object)new StyleGuideEmptyPanel()), 8);
        return styleGuideRelatedPanel;
    }

    private static int getNumberOfStatus(TestResultsContainer testResultsContainer, final ReturnStatus returnStatus) {
        TestResultDataFilter testResultDataFilter = new TestResultDataFilter(){

            @Override
            public boolean include(TestResultData testResultData) {
                return testResultData.getReturnStatus() == returnStatus;
            }
        };
        return testResultsContainer.getTestResults(testResultDataFilter).length;
    }
}

