/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotConnectException;
import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotSendJobFilesException;
import com.mathworks.toolbox.distcomp.clusteraccess.ExecuteCommandChore;
import com.mathworks.toolbox.distcomp.clusteraccess.JobAlreadyMirroredException;
import com.mathworks.toolbox.distcomp.clusteraccess.LastMirrorAndRemoveChore;
import com.mathworks.toolbox.distcomp.clusteraccess.LastMirrorFilesChore;
import com.mathworks.toolbox.distcomp.clusteraccess.Logger;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesChore;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.RemoteMachineChore;
import com.mathworks.toolbox.distcomp.clusteraccess.RemoveFilesChore;
import com.mathworks.toolbox.distcomp.clusteraccess.UploadFilesChore;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.util.DaemonThreadFactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class FileMirrorControl {
    private final String fHostname;
    private final ParameterMap fParameterMap;
    private final ScheduledThreadPoolExecutor fExecutor;
    private final Lock fLock = new ReentrantLock();
    private final Map<Integer, MirrorFilesChore> fJobidsMirrored = new LinkedHashMap<Integer, MirrorFilesChore>();
    private final Set<RemoteMachineChore> fOneTimeChores = new LinkedHashSet<RemoteMachineChore>();
    private final Map<RemoteMachineChore, FutureTask<Object>> fChoresToFutureTasks = new LinkedHashMap<RemoteMachineChore, FutureTask<Object>>();

    FileMirrorControl(String string, ParameterMap parameterMap) {
        this.fHostname = string;
        this.fParameterMap = parameterMap;
        this.fExecutor = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory(this.getClass().getSimpleName() + " fExecutor ", Logger.LOGGER));
    }

    RemoteMachineChore sendAndMirrorJobFiles(MirrorFilesInfo mirrorFilesInfo) throws InterruptedException, JobAlreadyMirroredException, CouldNotSendJobFilesException, CouldNotConnectException {
        try {
            this.fLock.lock();
            if (!this.isBeingMirrored(mirrorFilesInfo.getJobId())) {
                UploadFilesChore uploadFilesChore = new UploadFilesChore(mirrorFilesInfo, this.fHostname, this.fParameterMap, this);
                this.submitOneTimeChore(uploadFilesChore);
                UploadFilesChore uploadFilesChore2 = uploadFilesChore;
                return uploadFilesChore2;
            }
            throw new JobAlreadyMirroredException(mirrorFilesInfo.getJobId());
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBeingMirrored(int n) {
        try {
            this.fLock.lock();
            boolean bl = this.fJobidsMirrored.containsKey(n);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitOneTimeChore(RemoteMachineChore remoteMachineChore) {
        try {
            this.fLock.lock();
            FutureTask<Object> futureTask = new FutureTask<Object>(remoteMachineChore, new Object());
            this.fOneTimeChores.add(remoteMachineChore);
            this.fChoresToFutureTasks.put(remoteMachineChore, futureTask);
            this.fExecutor.execute(futureTask);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleOneTimeChore(RemoteMachineChore remoteMachineChore, long l) {
        try {
            this.fLock.lock();
            FutureTask<Object> futureTask = new FutureTask<Object>(remoteMachineChore, new Object());
            this.fOneTimeChores.add(remoteMachineChore);
            this.fChoresToFutureTasks.put(remoteMachineChore, futureTask);
            this.fExecutor.schedule(futureTask, l, TimeUnit.MILLISECONDS);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void oneTimeChoreCompleted(RemoteMachineChore remoteMachineChore) {
        try {
            this.fLock.lock();
            this.fOneTimeChores.remove(remoteMachineChore);
            this.fChoresToFutureTasks.remove(remoteMachineChore);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitMirrorFilesChore(int n, MirrorFilesChore mirrorFilesChore) {
        try {
            this.fLock.lock();
            FutureTask<Object> futureTask = new FutureTask<Object>(mirrorFilesChore, new Object());
            this.fJobidsMirrored.put(n, mirrorFilesChore);
            this.fChoresToFutureTasks.put(mirrorFilesChore, futureTask);
            this.fExecutor.execute(mirrorFilesChore);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MirrorFilesChore getMirrorFilesChore(int n) {
        try {
            this.fLock.lock();
            MirrorFilesChore mirrorFilesChore = this.fJobidsMirrored.get(n);
            return mirrorFilesChore;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MirrorFilesChore removeMirrorChoreForJob(int n) {
        try {
            this.fLock.lock();
            MirrorFilesChore mirrorFilesChore = this.fJobidsMirrored.remove(n);
            this.fChoresToFutureTasks.remove(mirrorFilesChore);
            MirrorFilesChore mirrorFilesChore2 = mirrorFilesChore;
            return mirrorFilesChore2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    MirrorFilesChore startMirrorForJob(MirrorFilesInfo mirrorFilesInfo) throws JobAlreadyMirroredException, CouldNotConnectException {
        try {
            this.fLock.lock();
            if (!this.isBeingMirrored(mirrorFilesInfo.getJobId())) {
                MirrorFilesChore mirrorFilesChore = new MirrorFilesChore(mirrorFilesInfo, this.fHostname, this.fParameterMap, this);
                this.submitMirrorFilesChore(mirrorFilesInfo.getJobId(), mirrorFilesChore);
                MirrorFilesChore mirrorFilesChore2 = mirrorFilesChore;
                return mirrorFilesChore2;
            }
            throw new JobAlreadyMirroredException(mirrorFilesInfo.getJobId());
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LastMirrorFilesChore createLastMirrorForJob(MirrorFilesInfo mirrorFilesInfo) {
        try {
            this.fLock.lock();
            MirrorFilesChore mirrorFilesChore = this.getMirrorFilesChore(mirrorFilesInfo.getJobId());
            LastMirrorFilesChore lastMirrorFilesChore = mirrorFilesChore != null ? mirrorFilesChore.createLastFileMirrorChore() : new LastMirrorFilesChore(mirrorFilesInfo, this.fHostname, this.fParameterMap, this);
            LastMirrorFilesChore lastMirrorFilesChore2 = lastMirrorFilesChore;
            return lastMirrorFilesChore2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopMirrorBeforeLastMirror(MirrorFilesInfo mirrorFilesInfo) {
        try {
            this.fLock.lock();
            MirrorFilesChore mirrorFilesChore = this.getMirrorFilesChore(mirrorFilesInfo.getJobId());
            if (mirrorFilesChore != null) {
                mirrorFilesChore.stop();
                FutureTask<Object> futureTask = this.fChoresToFutureTasks.get(mirrorFilesChore);
                futureTask.cancel(false);
                this.removeMirrorChoreForJob(mirrorFilesInfo.getJobId());
            }
        }
        finally {
            this.fLock.unlock();
            this.fExecutor.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LastMirrorFilesChore doLastMirrorForJob(MirrorFilesInfo mirrorFilesInfo) throws InterruptedException, CouldNotConnectException {
        try {
            this.fLock.lock();
            LastMirrorFilesChore lastMirrorFilesChore = this.createLastMirrorForJob(mirrorFilesInfo);
            this.stopMirrorBeforeLastMirror(mirrorFilesInfo);
            this.submitOneTimeChore(lastMirrorFilesChore);
            LastMirrorFilesChore lastMirrorFilesChore2 = lastMirrorFilesChore;
            return lastMirrorFilesChore2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LastMirrorFilesChore stopMirroringJobGracefully(MirrorFilesInfo mirrorFilesInfo, long l) {
        try {
            this.fLock.lock();
            LastMirrorFilesChore lastMirrorFilesChore = this.createLastMirrorForJob(mirrorFilesInfo);
            this.submitOneTimeChore(lastMirrorFilesChore);
            LastMirrorAndRemoveChore lastMirrorAndRemoveChore = new LastMirrorAndRemoveChore(mirrorFilesInfo, this.fHostname, this.fParameterMap, this);
            this.scheduleOneTimeChore(lastMirrorAndRemoveChore, l);
            Logger.LOGGER.finest("Scheduled " + lastMirrorAndRemoveChore.logPrefix() + " in " + l);
            LastMirrorFilesChore lastMirrorFilesChore2 = lastMirrorFilesChore;
            return lastMirrorFilesChore2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelMirrorForJob(int n) {
        try {
            this.fLock.lock();
            MirrorFilesChore mirrorFilesChore = this.getMirrorFilesChore(n);
            if (mirrorFilesChore != null) {
                mirrorFilesChore.cancel();
                FutureTask<Object> futureTask = this.fChoresToFutureTasks.get(mirrorFilesChore);
                futureTask.cancel(false);
                this.removeMirrorChoreForJob(n);
            } else {
                Logger.LOGGER.finest(this.logPrefix() + "No mirror is running for " + n);
            }
        }
        finally {
            this.fLock.unlock();
            this.fExecutor.purge();
        }
    }

    MirrorFilesChore resumeMirrorForJob(MirrorFilesInfo mirrorFilesInfo) throws JobAlreadyMirroredException, CouldNotConnectException {
        return this.startMirrorForJob(mirrorFilesInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleMirrorChore(MirrorFilesChore mirrorFilesChore, long l) {
        try {
            this.fLock.lock();
            FutureTask<Object> futureTask = new FutureTask<Object>(mirrorFilesChore, new Object());
            this.fChoresToFutureTasks.put(mirrorFilesChore, futureTask);
            this.fExecutor.schedule(mirrorFilesChore, l, TimeUnit.MILLISECONDS);
        }
        finally {
            this.fLock.unlock();
        }
    }

    void cancelAllFileMirrorChores() {
        this.cancelAllOneTimeChores();
        this.cancelAllMirrorChores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllOneTimeChores() {
        try {
            this.fLock.lock();
            for (RemoteMachineChore remoteMachineChore : this.fOneTimeChores) {
                FutureTask<Object> futureTask = this.fChoresToFutureTasks.remove(remoteMachineChore);
                futureTask.cancel(false);
                remoteMachineChore.cancel();
            }
        }
        finally {
            this.fLock.unlock();
            this.fExecutor.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllMirrorChores() {
        try {
            this.fLock.lock();
            Iterator<Integer> iterator = this.fJobidsMirrored.keySet().iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                RemoteMachineChore remoteMachineChore = this.fJobidsMirrored.get(n);
                FutureTask<Object> futureTask = this.fChoresToFutureTasks.remove(remoteMachineChore);
                futureTask.cancel(false);
                remoteMachineChore.cancel();
                iterator.remove();
            }
        }
        finally {
            this.fLock.unlock();
            this.fExecutor.purge();
        }
    }

    RemoteMachineChore removeFilesForJob(MirrorFilesInfo mirrorFilesInfo) throws InterruptedException, JobAlreadyMirroredException, CouldNotConnectException {
        try {
            this.fLock.lock();
            if (!this.isBeingMirrored(mirrorFilesInfo.getJobId())) {
                RemoveFilesChore removeFilesChore = new RemoveFilesChore(mirrorFilesInfo, this.fHostname, this.fParameterMap, this);
                this.submitOneTimeChore(removeFilesChore);
                RemoveFilesChore removeFilesChore2 = removeFilesChore;
                return removeFilesChore2;
            }
            throw new JobAlreadyMirroredException(mirrorFilesInfo.getJobId());
        }
        finally {
            this.fLock.unlock();
        }
    }

    ExecuteCommandChore executeCommand(String string) throws InterruptedException, CouldNotConnectException {
        ExecuteCommandChore executeCommandChore = new ExecuteCommandChore(string, this.fHostname, this.fParameterMap, this);
        this.submitOneTimeChore(executeCommandChore);
        return executeCommandChore;
    }

    private String logPrefix() {
        return this.fHostname + " :";
    }
}

