/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.PackageInfo;
import com.mathworks.toolbox.distcomp.control.DisplayableResults;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.RemoteCommand;
import com.mathworks.toolbox.distcomp.logging.DistcompConsoleHandler;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.security.ClientCertificateStore;
import com.mathworks.toolbox.distcomp.mjs.security.SharedSecret;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.ErrorPrinter;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.distcomp.util.FormattableException;
import com.mathworks.toolbox.distcomp.util.Version;
import com.sun.jini.start.LifeCycle;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.cert.Certificate;
import java.util.Date;

public class CommandListener {
    private static final int MAX_BYTES_TO_FLUSH = 1000000;
    private static long sStartTime;
    private int fPort;
    private ErrorPrinter fPrinter;
    private boolean fShouldListen = true;
    private Thread fListeningThread = null;
    private final int fSocketTimeoutInMilliSeconds = 1000;
    private ServerSocket fSsock = null;
    private boolean fPrint = false;

    public CommandListener(String[] stringArray, LifeCycle lifeCycle) {
        int n;
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid array length.");
        }
        this.fPrint = true;
        if (this.fPrint) {
            System.out.println("mdce service using MDCS version " + Version.VERSION_STRING);
        }
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port number.");
        }
        this.fPort = n;
        try {
            int n2 = Integer.parseInt(stringArray[1]);
            PackageInfo.LOGGER.addHandler(new DistcompConsoleHandler(n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid log level.");
        }
        if (Boolean.getBoolean("com.mathworks.toolbox.distcomp.rmi.useSecureCommunication")) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Attempting to install certificate from shared secret.");
            Certificate certificate = SharedSecret.getInstance().getSharedSecretCertificate();
            String string = CommandListener.class.getSimpleName();
            ClientCertificateStore.getInstance().setCertificateEntry(string, certificate);
        }
        this.fPrinter = new ErrorPrinterImpl();
        if (this.fPrint) {
            System.out.println("Listening for remote commands on port " + this.fPort);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandListener.this.listenForCommands();
            }
        };
        this.fListeningThread = new Thread(runnable);
        this.fListeningThread.start();
        sStartTime = System.currentTimeMillis();
    }

    public CommandListener(int n, ErrorPrinter errorPrinter) {
        this.fPort = n;
        this.fPrinter = errorPrinter;
    }

    public static Date getStartTime() {
        return new Date(sStartTime);
    }

    public void listenForCommands() {
        this.startListening();
        try {
            this.createServerSocket();
        }
        catch (Exception exception) {
            this.fPrinter.printError(exception);
            return;
        }
        while (this.shouldListen()) {
            Serializable serializable;
            MDCSCommand mDCSCommand;
            Socket socket;
            block19: {
                try {
                    socket = this.getSocket();
                }
                catch (Exception exception) {
                    this.fPrinter.printError(exception);
                    continue;
                }
                if (socket == null) {
                    return;
                }
                try {
                    mDCSCommand = this.getCommand(socket);
                }
                catch (IOException iOException) {
                    this.closeSocket(socket);
                    continue;
                }
                catch (Throwable throwable) {
                    this.fPrinter.printError(throwable);
                    this.flushInputstream(socket);
                    this.sendObjectAndCloseSocket(socket, throwable);
                    continue;
                }
                try {
                    if (!mDCSCommand.checkVersion()) {
                        serializable = new VersionException(mDCSCommand);
                        this.fPrinter.printError((Throwable)serializable);
                        this.sendObjectAndCloseSocket(socket, serializable);
                    }
                    break block19;
                }
                catch (Throwable throwable) {
                    this.fPrinter.printError(throwable);
                    this.sendObjectAndCloseSocket(socket, throwable);
                }
                continue;
            }
            if (this.fPrint) {
                System.out.println(mDCSCommand.getPreRunDescription());
            }
            try {
                serializable = this.runCommand(mDCSCommand);
            }
            catch (Throwable throwable) {
                this.fPrinter.printError(throwable);
                this.sendObjectAndCloseSocket(socket, throwable);
                continue;
            }
            if (this.fPrint && serializable instanceof DisplayableResults) {
                System.out.println(((DisplayableResults)serializable).getPostRunDescription());
            }
            this.sendObjectAndCloseSocket(socket, serializable);
        }
        if (!this.fSsock.isClosed()) {
            try {
                this.fSsock.close();
            }
            catch (Exception exception) {
                this.fPrinter.printError(exception);
            }
        }
        this.fSsock = null;
    }

    public void sendObjectAndCloseSocket(Socket socket, Object object) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            socket.close();
        }
        catch (Exception exception) {
            this.fPrinter.printError("An error occurred while sending an object.\nThe socket on the client side might have been closed due to a timeout.", exception);
        }
    }

    private void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            this.fPrinter.printError("An error occurred while closing a socket.", iOException);
        }
    }

    protected void createServerSocket() throws Exception {
        try {
            this.fSsock = new ServerSocket(this.fPort);
        }
        catch (BindException bindException) {
            throw new DistcompBindException(this.fPort);
        }
        catch (IOException iOException) {
            throw new PortIOException(iOException, this.fPort);
        }
    }

    protected Socket getSocket() throws Exception {
        Socket socket = null;
        try {
            this.fSsock.setSoTimeout(1000);
            while (this.shouldListen() && socket == null) {
                try {
                    socket = this.fSsock.accept();
                }
                catch (SocketTimeoutException socketTimeoutException) {}
            }
        }
        catch (Exception exception) {
            throw new Exception("An error occurred while receiving the command.", exception);
        }
        return socket;
    }

    public MDCSCommand getCommand(Socket socket) throws IOException, InvalidDistcompClassException {
        MDCSCommand mDCSCommand;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            mDCSCommand = (MDCSCommand)objectInputStream.readObject();
        }
        catch (InvalidClassException invalidClassException) {
            this.fPrinter.printError(invalidClassException);
            throw new InvalidDistcompClassException(Version.VERSION_STRING);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fPrinter.printError(classNotFoundException);
            throw new InvalidDistcompClassException(Version.VERSION_STRING);
        }
        return mDCSCommand;
    }

    public MDCSCommandResults runCommand(MDCSCommand mDCSCommand) throws Exception {
        return mDCSCommand.run();
    }

    public synchronized boolean shouldListen() {
        return this.fShouldListen;
    }

    public synchronized void stopListening() {
        this.fShouldListen = false;
    }

    public synchronized void startListening() {
        this.fShouldListen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInputstream(Socket socket) {
        int n = -1;
        try {
            n = socket.getSoTimeout();
            socket.setSoTimeout(1000);
            socket.getInputStream().skip(1000000L);
        }
        catch (Throwable throwable) {
        }
        finally {
            if (n >= 0) {
                try {
                    socket.setSoTimeout(n);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static enum ErrorKey {
        COULD_NOT_ATTACH_TO_PORT,
        INVALID_CLASS,
        INVALID_VERSION,
        INVALID_CLASS_DETAIL,
        INVALID_VERSION_DETAIL,
        PORT_BUSY;

    }

    private static class PortIOException
    extends FormattableException {
        public PortIOException(IOException iOException, int n) {
            super(iOException, (Object)ErrorKey.COULD_NOT_ATTACH_TO_PORT, n);
        }
    }

    private static class DistcompBindException
    extends DistcompDiagnosticException {
        public DistcompBindException(int n) {
            super(new FormattableException(null, (Object)ErrorKey.PORT_BUSY, new Object[0]){}, (Object)ErrorKey.COULD_NOT_ATTACH_TO_PORT, n);
        }
    }

    private static class VersionException
    extends DistcompDiagnosticException {
        public VersionException(RemoteCommand remoteCommand) {
            super(new FormattableException(null, (Object)ErrorKey.INVALID_VERSION_DETAIL, new Object[]{Version.VERSION_STRING, remoteCommand.getVersionString()}){}, (Object)ErrorKey.INVALID_VERSION, new Object[0]);
            this.setRemoteVersionNum(remoteCommand.getVersionNumber());
        }
    }

    private static class InvalidDistcompClassException
    extends DistcompDiagnosticException {
        private InvalidDistcompClassException(String string) {
            super(new FormattableException(null, (Object)ErrorKey.INVALID_CLASS_DETAIL, new Object[]{string}){}, (Object)ErrorKey.INVALID_CLASS, new Object[0]);
        }
    }
}

