/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.DisplayableResults;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.StatusResultsFormatter;
import com.mathworks.toolbox.distcomp.control.serviceinfo.JobManagerServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.NoValidMDCSHostnameException;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.WorkerServiceInfo;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerNodeInfo;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.util.NodeInfoAnalyzer;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import com.mathworks.toolbox.distcomp.worker.WorkerNodeInfo;
import java.util.List;

public final class StatusResults
implements DisplayableResults {
    private static final long serialVersionUID = 4937604141305088999L;
    private static final int LEVEL_ONE = 1;
    private static final int LEVEL_TWO = 2;
    private final String fOutput;
    private final WarningAndNoteInfo fWarningsAndNotes;
    private final String fVerboseDesc;
    private final JobManagerNodeInfo[] fJInfo;
    private final WorkerNodeInfo[] fWInfo;
    private final boolean fHasLookup;
    private static final String sMsgStopped = "Stopped services";
    private static final String sMsgUnknown = "Unknown";
    private static final String sMsgName = "Name";
    private static final String sMsgRunningOnHost = "Running on host";
    private static final String sMsgNetworkAddresses = "Network addresses of host";
    private static final String sMsgStartTime = "Start time";
    private static final String sMsgPort = "Port";
    private static final String sMsgLookupInConfig = "Requested job manager lookup processes";
    private static final String sMsgRegisteredWithLookup = "Registered with job manager lookup processes on hosts";
    private static final String sMsgUsingMulticast = "Using multicast";
    private static final String sMsgJobManager = "Job manager";
    private static final String sMsgJobManagers = "Job managers";
    private static final String sMsgNumWorkers = "Number of workers";
    private static final String sMsgWorkerNamesHostNames = "Worker names and host names";
    private static final String sMsgDatabaseSize = "Database size in bytes";
    private static final String sMsgVMHeapSize = "VM heap size in bytes";
    private static final String sMsgDatabaseCacheSize = "Database item cache size";
    private static final String sMsgWorkerLeaseTimeout = "Worker lease timeout in msec";
    private static final String sMsgWorker = "Worker";
    private static final String sMsgWorkers = "Workers";
    private static final String sMsgIdle = "Idle";
    private static final String sMsgBusy = "Busy";
    private static final String sMsgStatus = "Status";
    private static final String sMsgWorkerJMConnectionStatus = "Connection with job manager";
    private static final String sMsgWorkerJMHostname = "Job manager hostname";
    private static final String sMsgFileDependDir = "File dependencies directory";
    private static final String sMsgWorkerStartupDir = "Worker startup directory";
    private static final String sMsgLookupProcess = "Job manager lookup process";
    private static final String sMsgLookupProcesses = "Job manager lookup processes";
    private static final String sMsgMDCE = "MDCE service";
    private static final String sMsgMDCESecurityLevel = "Security level";
    private static final String sMsgMDCEVersion = "Version";
    private static final String sMsgMDCEMatlabRoot = "MATLAB";
    private static final String sMsgMDCEPlatform = "Platform";
    private static final String sMsgMDCEDefFile = "mdce_def File";
    private static final String sMsgRunning = "Running";
    private static final String sMsgNotRunning = "Not running";
    private static final String sMsgConnectionOk = "Connected";
    private static final String sMsgConnectionFailed = "Failed";
    private static final String sMsgWorkerFailedToConnect = "Worker has not been able to contact job manager";
    private static final String sMsgLostConnection = "Lost connection";

    @Override
    public String getOutputForDisplay() {
        return this.fOutput;
    }

    @Override
    public WarningAndNoteInfo getWarnings() {
        return this.fWarningsAndNotes;
    }

    @Override
    public String getPostRunDescription() {
        return this.fVerboseDesc;
    }

    public JobManagerNodeInfo[] getJobManagerNodeInfo() {
        return this.fJInfo;
    }

    public WorkerNodeInfo[] getWorkerNodeInfo() {
        return this.fWInfo;
    }

    public boolean isLookupRunning() {
        return this.fHasLookup;
    }

    public static MDCSCommandResults create(JobManagerNodeInfo[] jobManagerNodeInfoArray, WorkerNodeInfo[] workerNodeInfoArray, MDCSServiceInfo mDCSServiceInfo, List<ServiceInfo> list, int n) {
        boolean bl;
        boolean bl2 = mDCSServiceInfo.getHasLookup();
        String string = null;
        try {
            string = mDCSServiceInfo.getMDCSHostName();
        }
        catch (NoValidMDCSHostnameException noValidMDCSHostnameException) {
            // empty catch block
        }
        String string2 = StatusResults.getMDCEString(mDCSServiceInfo, n);
        boolean bl3 = bl = bl2 || jobManagerNodeInfoArray != null && jobManagerNodeInfoArray.length > 0;
        if (bl) {
            string2 = string2 + StatusResults.getLookupString(bl2);
        }
        if (jobManagerNodeInfoArray != null) {
            for (JobManagerNodeInfo jobManagerNodeInfo : jobManagerNodeInfoArray) {
                if (jobManagerNodeInfo == null) continue;
                string2 = string2 + StatusResults.getJobManagerString(jobManagerNodeInfo, n);
            }
        }
        if (workerNodeInfoArray != null) {
            for (WorkerNodeInfo workerNodeInfo : workerNodeInfoArray) {
                if (workerNodeInfo == null) continue;
                string2 = string2 + StatusResults.getWorkerString(workerNodeInfo, n);
            }
        }
        if (list.size() > 0) {
            string2 = string2 + StatusResults.getStoppedServicesString(list);
        }
        string2 = string2 + StatusResults.getMDCESummary(string, jobManagerNodeInfoArray, workerNodeInfoArray, bl2);
        WarningAndNoteInfo warningAndNoteInfo = new WarningAndNoteInfo();
        NodeInfoAnalyzer.addWarningsAndNotes(warningAndNoteInfo, string, jobManagerNodeInfoArray, workerNodeInfoArray, bl2, false);
        String string3 = StatusResults.msgRetrievedMDCEStatus(string);
        return new StatusResults(string2, warningAndNoteInfo, string3, bl2, jobManagerNodeInfoArray, workerNodeInfoArray);
    }

    private StatusResults(String string, WarningAndNoteInfo warningAndNoteInfo, String string2, boolean bl, JobManagerNodeInfo[] jobManagerNodeInfoArray, WorkerNodeInfo[] workerNodeInfoArray) {
        this.fOutput = string;
        this.fWarningsAndNotes = warningAndNoteInfo;
        this.fVerboseDesc = string2;
        this.fHasLookup = bl;
        if (jobManagerNodeInfoArray == null || jobManagerNodeInfoArray.length == 0) {
            this.fJInfo = null;
        } else {
            this.fJInfo = new JobManagerNodeInfo[jobManagerNodeInfoArray.length];
            System.arraycopy(jobManagerNodeInfoArray, 0, this.fJInfo, 0, jobManagerNodeInfoArray.length);
        }
        if (workerNodeInfoArray == null || workerNodeInfoArray.length == 0) {
            this.fWInfo = null;
        } else {
            this.fWInfo = new WorkerNodeInfo[workerNodeInfoArray.length];
            System.arraycopy(workerNodeInfoArray, 0, this.fWInfo, 0, workerNodeInfoArray.length);
        }
    }

    private static void getLevelOneOnly(StatusResultsFormatter statusResultsFormatter, NodeInfo nodeInfo) {
        statusResultsFormatter.add(sMsgName, nodeInfo.getName());
        statusResultsFormatter.add(sMsgRunningOnHost, nodeInfo.getHostName());
    }

    private static void getLevelThreeOnly(StatusResultsFormatter statusResultsFormatter, NodeInfo nodeInfo) {
        statusResultsFormatter.add(sMsgNetworkAddresses, nodeInfo.getAllHostAddresses());
    }

    private static void getLevelTwoOnly(StatusResultsFormatter statusResultsFormatter, NodeInfo nodeInfo) {
        if (nodeInfo.getStartTime() != null) {
            statusResultsFormatter.add(sMsgStartTime, nodeInfo.getStartTime().toString());
        } else {
            statusResultsFormatter.add(sMsgStartTime, "");
        }
        statusResultsFormatter.add(sMsgPort, nodeInfo.getPort());
        String[] stringArray = nodeInfo.getLookupURLsInConfiguration();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{sMsgUsingMulticast};
        }
        statusResultsFormatter.add(sMsgLookupInConfig, stringArray);
        statusResultsFormatter.add(sMsgRegisteredWithLookup, nodeInfo.getLookupURLs());
    }

    private static String getJobManagerString(JobManagerNodeInfo jobManagerNodeInfo, int n) {
        StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(sMsgJobManager);
        StatusResults.getLevelOneOnly(statusResultsFormatter, jobManagerNodeInfo);
        String[] stringArray = jobManagerNodeInfo.getWorkerHostnames();
        String[] stringArray2 = jobManagerNodeInfo.getWorkerNames();
        int n2 = 0;
        if (stringArray != null) {
            n2 = stringArray.length;
        }
        statusResultsFormatter.add(sMsgNumWorkers, n2);
        if (n > 1) {
            statusResultsFormatter.add(sMsgWorkerNamesHostNames, stringArray2, stringArray);
            StatusResults.getLevelTwoOnly(statusResultsFormatter, jobManagerNodeInfo);
        }
        if (n > 2) {
            statusResultsFormatter.add(sMsgDatabaseSize, jobManagerNodeInfo.getDatabaseSize());
            statusResultsFormatter.add(sMsgVMHeapSize, jobManagerNodeInfo.getVMHeapSize());
            statusResultsFormatter.add(sMsgDatabaseCacheSize, jobManagerNodeInfo.getDatabaseCacheSize());
            statusResultsFormatter.add(sMsgWorkerLeaseTimeout, jobManagerNodeInfo.getWorkerLeaseTimeout());
            StatusResults.getLevelThreeOnly(statusResultsFormatter, jobManagerNodeInfo);
        }
        return statusResultsFormatter.getBuffer();
    }

    private static String getWorkerString(WorkerNodeInfo workerNodeInfo, int n) {
        StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(sMsgWorker);
        StatusResults.getLevelOneOnly(statusResultsFormatter, workerNodeInfo);
        String string = sMsgIdle;
        if (workerNodeInfo.isBusy()) {
            string = sMsgBusy;
        }
        statusResultsFormatter.add(sMsgStatus, string);
        statusResultsFormatter.add(sMsgJobManager, workerNodeInfo.getJobManagerNameInConfiguration());
        String[] stringArray = StatusResults.getJobManagerConnectionStatus(workerNodeInfo);
        statusResultsFormatter.add(sMsgWorkerJMConnectionStatus, stringArray[0]);
        if (n > 1) {
            statusResultsFormatter.add(sMsgWorkerJMHostname, stringArray[1]);
            StatusResults.getLevelTwoOnly(statusResultsFormatter, workerNodeInfo);
        }
        if (n > 2) {
            statusResultsFormatter.add(sMsgFileDependDir, workerNodeInfo.getFileDependenciesDir());
            statusResultsFormatter.add(sMsgWorkerStartupDir, workerNodeInfo.getWorkDir());
            StatusResults.getLevelThreeOnly(statusResultsFormatter, workerNodeInfo);
        }
        return statusResultsFormatter.getBuffer();
    }

    private static String getLookupString(boolean bl) {
        StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(sMsgLookupProcess);
        String string = bl ? sMsgRunning : sMsgNotRunning;
        statusResultsFormatter.add(sMsgStatus, string);
        return statusResultsFormatter.getBuffer();
    }

    private static String getMDCEString(MDCSServiceInfo mDCSServiceInfo, int n) {
        if (n > 1) {
            StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(sMsgMDCE);
            statusResultsFormatter.add(sMsgMDCESecurityLevel, mDCSServiceInfo.getSecurityLevel().intValue());
            statusResultsFormatter.add(sMsgMDCEVersion, mDCSServiceInfo.getVersion());
            statusResultsFormatter.add(sMsgMDCEMatlabRoot, mDCSServiceInfo.getMatlabRoot());
            statusResultsFormatter.add(sMsgMDCEDefFile, mDCSServiceInfo.getMdceDefFile());
            statusResultsFormatter.add(sMsgMDCEPlatform, mDCSServiceInfo.getSystemArchitecture().toString());
            return statusResultsFormatter.getBuffer();
        }
        return "";
    }

    private static String[] getJobManagerConnectionStatus(WorkerNodeInfo workerNodeInfo) {
        String string = workerNodeInfo.getJobManagerHostName();
        if (workerNodeInfo.isConnectedToJM()) {
            return new String[]{sMsgConnectionOk, string};
        }
        if (string == null || string.length() == 0) {
            return new String[]{sMsgConnectionFailed, sMsgWorkerFailedToConnect};
        }
        return new String[]{sMsgLostConnection, StatusResults.msgLostConnectionTo(string)};
    }

    private static String getMDCESummary(String string, JobManagerNodeInfo[] jobManagerNodeInfoArray, WorkerNodeInfo[] workerNodeInfoArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (jobManagerNodeInfoArray != null) {
            n = jobManagerNodeInfoArray.length;
        }
        if (workerNodeInfoArray != null) {
            n2 = workerNodeInfoArray.length;
        }
        if (bl) {
            n3 = 1;
        }
        StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(StatusResults.msgMDCESummary(string));
        statusResultsFormatter.add(sMsgLookupProcesses, n3);
        statusResultsFormatter.add(sMsgJobManagers, n);
        statusResultsFormatter.add(sMsgWorkers, n2);
        return statusResultsFormatter.getBuffer();
    }

    private static String getStoppedServicesString(List<ServiceInfo> list) {
        StatusResultsFormatter statusResultsFormatter = new StatusResultsFormatter(sMsgStopped);
        for (ServiceInfo serviceInfo : list) {
            if (serviceInfo instanceof WorkerServiceInfo) {
                statusResultsFormatter.add(sMsgWorker, serviceInfo.getServiceName());
                continue;
            }
            if (serviceInfo instanceof JobManagerServiceInfo) {
                statusResultsFormatter.add(sMsgJobManager, serviceInfo.getServiceName());
                continue;
            }
            statusResultsFormatter.add(sMsgUnknown, serviceInfo.getServiceName());
        }
        return statusResultsFormatter.getBuffer();
    }

    private static String msgLostConnectionTo(String string) {
        return "Was " + string + " until connection was lost";
    }

    private static String msgRetrievedMDCEStatus(String string) {
        return "Retrieved the node status on the host " + string + ".";
    }

    private static String msgMDCESummary(String string) {
        return "Summary:\nThe mdce service on " + string + " manages the following processes";
    }
}

