/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.service.DistcompServiceInfo;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class JobManagerServiceInfo
extends DistcompServiceInfo {
    private final int fState;
    private final JobIDAndMLType[] fJobIDAndMLTypes;
    private final int fNumIdleWorkers;
    private final int fNumBusyWorkers;
    private final WorkerProperties[] fIdleWorkerProperties;
    private final WorkerProperties[] fBusyWorkerProperties;

    public JobManagerServiceInfo(WorkerProperties[] workerPropertiesArray, WorkerProperties[] workerPropertiesArray2, int n, int n2, JobIDAndMLType[] jobIDAndMLTypeArray, int n3) {
        this.fNumIdleWorkers = n;
        this.fNumBusyWorkers = n2;
        this.fJobIDAndMLTypes = (JobIDAndMLType[])jobIDAndMLTypeArray.clone();
        this.fState = n3;
        this.fIdleWorkerProperties = (WorkerProperties[])workerPropertiesArray.clone();
        this.fBusyWorkerProperties = (WorkerProperties[])workerPropertiesArray2.clone();
    }

    public WorkerProperties[] getIdleWorkerProperties() {
        return (WorkerProperties[])this.fIdleWorkerProperties.clone();
    }

    public WorkerProperties[] getBusyWorkerProperties() {
        return (WorkerProperties[])this.fBusyWorkerProperties.clone();
    }

    public JobIDAndMLType[] getJobs() {
        return (JobIDAndMLType[])this.fJobIDAndMLTypes.clone();
    }

    public int getNumBusyWorkers() {
        return this.fNumBusyWorkers;
    }

    public int getNumIdleWorkers() {
        return this.fNumIdleWorkers;
    }

    public int getState() {
        return this.fState;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        JobManagerServiceInfo jobManagerServiceInfo = (JobManagerServiceInfo)object;
        if (this.fNumBusyWorkers != jobManagerServiceInfo.fNumBusyWorkers) {
            return false;
        }
        if (this.fNumIdleWorkers != jobManagerServiceInfo.fNumIdleWorkers) {
            return false;
        }
        if (this.fState != jobManagerServiceInfo.fState) {
            return false;
        }
        if (!JobManagerServiceInfo.sameWorkerProperties(this.fBusyWorkerProperties, jobManagerServiceInfo.fBusyWorkerProperties)) {
            return false;
        }
        if (!JobManagerServiceInfo.sameWorkerProperties(this.fIdleWorkerProperties, jobManagerServiceInfo.fIdleWorkerProperties)) {
            return false;
        }
        return Arrays.equals(this.fJobIDAndMLTypes, jobManagerServiceInfo.fJobIDAndMLTypes);
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(17, 37);
        hashCodeBuilder.appendSuper(super.hashCode());
        hashCodeBuilder.append(this.fState);
        hashCodeBuilder.append((Object[])this.fJobIDAndMLTypes);
        hashCodeBuilder.append(this.fNumIdleWorkers);
        hashCodeBuilder.append(this.fNumBusyWorkers);
        hashCodeBuilder.append((Object[])this.fIdleWorkerProperties);
        hashCodeBuilder.append((Object[])this.fBusyWorkerProperties);
        return hashCodeBuilder.toHashCode();
    }

    private static boolean sameWorkerProperties(WorkerProperties[] workerPropertiesArray, WorkerProperties[] workerPropertiesArray2) {
        if (workerPropertiesArray == null && workerPropertiesArray2 == null) {
            return true;
        }
        if (workerPropertiesArray == null || workerPropertiesArray2 == null) {
            return false;
        }
        if (workerPropertiesArray.length != workerPropertiesArray2.length) {
            return false;
        }
        HashSet<WorkerProperties> hashSet = new HashSet<WorkerProperties>(Arrays.asList(workerPropertiesArray));
        HashSet<WorkerProperties> hashSet2 = new HashSet<WorkerProperties>(Arrays.asList(workerPropertiesArray2));
        return ((Object)hashSet).equals(hashSet2);
    }
}

