/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class TokenManager {
    private ReentrantLock fDataLock;
    private int fTotalTokens;
    private int fAvailableTokens;
    private LinkedList<WaitingToken> fWaitingTokens;

    TokenManager(int n) {
        this.fTotalTokens = n;
        this.fAvailableTokens = n;
        this.fWaitingTokens = new LinkedList();
        this.fDataLock = new ReentrantLock();
    }

    SemaphoreToken acquire(int n) throws InterruptedException {
        return this.acquire(n, n);
    }

    SemaphoreToken acquire(int n, int n2) throws InterruptedException {
        assert (n <= n2) : "Min number requested must be less than or equal to max";
        DataLock dataLock = this.acquireDataLock();
        try {
            if (n > this.fTotalTokens) {
                throw new IllegalStateException("Too many licenses requested");
            }
            if (n <= this.fAvailableTokens && this.fWaitingTokens.isEmpty()) {
                int n3 = Math.min(n2, this.fAvailableTokens);
                this.fAvailableTokens -= n3;
                SemaphoreToken semaphoreToken = new SemaphoreToken(n3, this);
                return semaphoreToken;
            }
            WaitingToken waitingToken = new WaitingToken(n, n2);
            this.fWaitingTokens.add(waitingToken);
            try {
                waitingToken.await();
                if (waitingToken.fException != null) {
                    throw waitingToken.fException;
                }
                assert (waitingToken.fNumAcquired >= n) : "Incorrect number acquired";
                SemaphoreToken semaphoreToken = new SemaphoreToken(waitingToken.fNumAcquired, this);
                return semaphoreToken;
            }
            catch (InterruptedException interruptedException) {
                this.fWaitingTokens.remove(waitingToken);
                if (waitingToken.fNumAcquired > 0) {
                    this.release(waitingToken.fNumAcquired);
                }
                throw interruptedException;
            }
        }
        finally {
            dataLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(SemaphoreToken semaphoreToken) {
        int n;
        SemaphoreToken semaphoreToken2 = semaphoreToken;
        synchronized (semaphoreToken2) {
            if (semaphoreToken.fTokenHasBeenUsed) {
                return;
            }
            semaphoreToken.fTokenHasBeenUsed = true;
            n = semaphoreToken.fNumAcquired;
        }
        this.release(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(int n) {
        DataLock dataLock = this.acquireDataLockUninterruptibly();
        try {
            this.fAvailableTokens += n;
            this.fAvailableTokens = Math.min(this.fTotalTokens, this.fAvailableTokens);
            while (!this.fWaitingTokens.isEmpty()) {
                WaitingToken waitingToken = this.fWaitingTokens.getFirst();
                if (waitingToken.fMinRequested > this.fTotalTokens) {
                    waitingToken.fException = new IllegalStateException("Too many licenses requested");
                } else if (waitingToken.fMinRequested <= this.fAvailableTokens) {
                    waitingToken.fNumAcquired = Math.min(waitingToken.fMaxRequested, this.fAvailableTokens);
                    this.fAvailableTokens -= waitingToken.fNumAcquired;
                } else {
                    return;
                }
                this.fWaitingTokens.removeFirst();
                waitingToken.signal();
            }
        }
        finally {
            dataLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTotalNumberOfTokens(int n) {
        assert (n > 0) : "Total number of licenses must be greater than zero";
        DataLock dataLock = this.acquireDataLockUninterruptibly();
        try {
            int n2 = n - this.fTotalTokens;
            this.fTotalTokens = n;
            this.release(n2);
        }
        finally {
            dataLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfTokens() {
        DataLock dataLock = this.acquireDataLockUninterruptibly();
        try {
            int n = this.fTotalTokens;
            return n;
        }
        finally {
            dataLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfAvailableTokens() {
        DataLock dataLock = this.acquireDataLockUninterruptibly();
        try {
            int n = this.fAvailableTokens;
            return n;
        }
        finally {
            dataLock.release();
        }
    }

    private DataLock acquireDataLock() throws InterruptedException {
        this.fDataLock.lockInterruptibly();
        return new DataLock();
    }

    private DataLock acquireDataLockUninterruptibly() {
        this.fDataLock.lock();
        return new DataLock();
    }

    static class SemaphoreToken {
        private int fNumAcquired;
        private boolean fTokenHasBeenUsed = false;
        private TokenManager fTokenManager;

        private SemaphoreToken(int n, TokenManager tokenManager) {
            this.fNumAcquired = n;
            this.fTokenManager = tokenManager;
        }

        public int getNumberAcquired() {
            return this.fNumAcquired;
        }

        public boolean hasBeenRelease() {
            return this.fTokenHasBeenUsed;
        }

        public void release() {
            this.fTokenManager.release(this);
        }
    }

    private class WaitingToken {
        int fMaxRequested;
        int fMinRequested;
        int fNumAcquired;
        IllegalStateException fException;
        private boolean fIsWaiting;
        private Condition fCondition;

        private WaitingToken(int n, int n2) {
            this.fMaxRequested = n2;
            this.fMinRequested = n;
            this.fNumAcquired = -1;
            this.fException = null;
            this.fIsWaiting = true;
            this.fCondition = TokenManager.this.fDataLock.newCondition();
        }

        void await() throws InterruptedException {
            while (this.fIsWaiting) {
                this.fCondition.await();
            }
        }

        void signalAll() {
            this.fIsWaiting = false;
            this.fCondition.signalAll();
        }

        void signal() {
            this.fIsWaiting = false;
            this.fCondition.signal();
        }
    }

    private class DataLock {
        private boolean fLockInUse = true;

        private DataLock() {
        }

        private synchronized void release() {
            if (this.fLockInUse) {
                this.fLockInUse = false;
                TokenManager.this.fDataLock.unlock();
            }
        }
    }
}

