/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.datastore;

import com.mathworks.toolbox.distcomp.mjs.datastore.DataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreInputStream;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreOutputStream;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public class DataStoreItem
implements TransferableData,
Serializable {
    private final Uuid fDataID = UuidFactory.generate();
    private final int fNumDataBytes;
    private DataStore fDataStoreProxy;

    public DataStoreItem(int n, DataStore dataStore) {
        this.fNumDataBytes = n;
        this.fDataStoreProxy = dataStore;
    }

    @Override
    public int getNumBytes() {
        return this.fNumDataBytes;
    }

    @Override
    public InputStream getInputStream() {
        assert (this.fDataStoreProxy != null) : "The data store proxy must be set in order to get a data store item input stream";
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new DataStoreInputStream(this.fDataStoreProxy, this), (int)this.fDataStoreProxy.getMinTransferSize());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return bufferedInputStream;
    }

    public OutputStream getOutputStream() {
        assert (this.fDataStoreProxy != null) : "The data store proxy must be set in order to get a data store item output stream";
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new DataStoreOutputStream(this.fDataStoreProxy, this), (int)this.fDataStoreProxy.getMinTransferSize());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return bufferedOutputStream;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DataStoreItem) {
            return ((DataStoreItem)object).fDataID.equals((Object)this.fDataID);
        }
        return false;
    }

    public int hashCode() {
        return this.fDataID.hashCode();
    }
}

