/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.nativedmatlab;

import com.mathworks.toolbox.distcomp.nativedmatlab.ByteBuffAndKey;
import com.mathworks.toolbox.distcomp.nativedmatlab.PhantomReferenceReaper;
import com.mathworks.toolbox.distcomp.nativedmatlab.WeakAndPhantomRefs;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;

public final class FreeableDirectByteBuffer {
    private static final int sMIN_ACCEPTABLE_BUFFER_SIZE = 8;
    private static ConcurrentHashMap<Long, WeakAndPhantomRefs> sBufAndKeyMap;
    private static PhantomReferenceReaper fRefReaper;

    private FreeableDirectByteBuffer() {
    }

    public static ByteBuffAndKey allocateFreeableDirect(int n) {
        if (n > 8) {
            ByteBuffer byteBuffer = FreeableDirectByteBuffer.nativeAllocateDirect(n);
            if (byteBuffer == null) {
                throw new OutOfMemoryError("Failed to allocate a direct ByteBuffer of size: " + n);
            }
            byteBuffer.position(0);
            long l = byteBuffer.getLong();
            byteBuffer.clear();
            ByteBuffAndKey byteBuffAndKey = new ByteBuffAndKey(byteBuffer, l, true);
            sBufAndKeyMap.put(l, new WeakAndPhantomRefs(byteBuffAndKey, fRefReaper.getRefQueue()));
            return byteBuffAndKey;
        }
        return new ByteBuffAndKey(ByteBuffer.allocateDirect(n), -1L, false);
    }

    static void freeByKey(long l) {
        ByteBuffAndKey byteBuffAndKey;
        WeakAndPhantomRefs weakAndPhantomRefs = sBufAndKeyMap.remove(l);
        if (weakAndPhantomRefs != null && (byteBuffAndKey = (ByteBuffAndKey)weakAndPhantomRefs.pWeak.get()) != null) {
            byteBuffAndKey.getBuffer().position(0).limit(0);
        }
        FreeableDirectByteBuffer.free(l);
    }

    public static void freeByBuffAndKey(ByteBuffAndKey byteBuffAndKey) {
        FreeableDirectByteBuffer.freeByKey(byteBuffAndKey.getKey());
    }

    static native boolean free(long var0);

    private static native ByteBuffer nativeAllocateDirect(int var0);

    private static native long memstats();

    public static native long bytesAllocated();

    public static void dumpStats() {
        for (Long l : sBufAndKeyMap.keySet()) {
            WeakAndPhantomRefs weakAndPhantomRefs = sBufAndKeyMap.get(l);
            System.out.println("Key: " + l + ", value: " + (weakAndPhantomRefs == null ? "null" : "" + weakAndPhantomRefs.pWeak.get()));
        }
        FreeableDirectByteBuffer.memstats();
    }

    static {
        System.loadLibrary("dctprocess");
        sBufAndKeyMap = new ConcurrentHashMap();
        fRefReaper = PhantomReferenceReaper.build();
    }
}

