/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

class SingleEdgeBorder
extends AbstractBorder {
    private int fEdge;

    SingleEdgeBorder(int n) {
        this.fEdge = n;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        Insets insets = new Insets(0, 0, 0, 0);
        return this.getBorderInsets(component, insets);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.right = insets.top = insets.bottom;
        insets.left = insets.top;
        switch (this.fEdge) {
            case 1: {
                insets.top = 1;
                break;
            }
            case 3: {
                insets.bottom = PlatformInfo.isWindowsClassicAppearance() ? 2 : 1;
                break;
            }
            case 2: {
                insets.left = 1;
                break;
            }
            case 4: {
                insets.right = PlatformInfo.isWindowsClassicAppearance() ? 2 : 1;
            }
        }
        return insets;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        switch (this.fEdge) {
            case 1: {
                graphics.setColor(UIManager.getColor(PlatformInfo.isWindowsClassicAppearance() ? "controlShadow" : "inactiveCaption"));
                graphics.drawLine(n, 0, n + n3 - 1, 0);
                break;
            }
            case 3: {
                if (PlatformInfo.isWindowsClassicAppearance()) {
                    graphics.setColor(UIManager.getColor("controlLtHighlight"));
                    graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                    graphics.setColor(UIManager.getColor("control"));
                    graphics.drawLine(n, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                    break;
                }
                graphics.setColor(UIManager.getColor("inactiveCaption"));
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                break;
            }
            case 2: {
                graphics.setColor(UIManager.getColor(PlatformInfo.isWindowsClassicAppearance() ? "controlShadow" : "inactiveCaption"));
                graphics.drawLine(0, n2, 0, n2 + n4 - 1);
                break;
            }
            case 4: {
                if (PlatformInfo.isWindowsClassicAppearance()) {
                    graphics.setColor(UIManager.getColor("controlLtHighlight"));
                    graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
                    graphics.setColor(UIManager.getColor("control"));
                    graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2 + n4 - 1);
                    break;
                }
                graphics.setColor(UIManager.getColor("inactiveCaption"));
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }
        }
        graphics.setColor(color);
    }
}

