/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutput;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ProcessInstance;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class DrainableOutputImpl
implements DrainableOutput {
    public static final String sTRUNCATED_MESSAGE = "<truncated...>";
    public static final String sCONTINUATION_PREFIX = "  ";
    private final Map<Instance, StringBuffer> fOutputBuffers;
    private final Map<Instance, Boolean> fIsTruncated;
    private Instance fLastProcessPrinted = null;
    private final boolean fPrintLabIndex;
    private boolean fIsOpen;
    private final int fMaxLengthPerLab;
    private final String fLabIndexFormat;

    public DrainableOutputImpl(Instance[] instanceArray, boolean bl, int n) {
        assert (n > 0) : "Maximum string length must be > 0.";
        this.fOutputBuffers = new TreeMap<Instance, StringBuffer>();
        this.fIsTruncated = new TreeMap<Instance, Boolean>();
        int n2 = 1;
        for (Instance instance : instanceArray) {
            ProcessInstance processInstance;
            this.fOutputBuffers.put(instance, new StringBuffer());
            this.fIsTruncated.put(instance, false);
            if (!(instance instanceof ProcessInstance) || (processInstance = (ProcessInstance)instance).getLabIndex() <= n2) continue;
            n2 = processInstance.getLabIndex();
        }
        this.fPrintLabIndex = bl;
        this.fIsOpen = true;
        this.fMaxLengthPerLab = n;
        int n3 = (int)Math.floor(Math.log10(n2)) + 1;
        this.fLabIndexFormat = "Lab %" + n3 + "d: \n";
    }

    public DrainableOutputImpl(Instance[] instanceArray, boolean bl) {
        this(instanceArray, bl, SessionConstants.sMAX_STORED_STR_LENGTH_PER_LAB);
    }

    @Override
    public synchronized void addOutput(Instance instance, String[] stringArray) {
        int n;
        if (!this.fIsOpen) {
            return;
        }
        StringBuffer stringBuffer = this.fOutputBuffers.get(instance);
        assert (stringBuffer != null) : "Received output for an unknown process instance " + instance;
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD output from " + instance);
        int n2 = 0;
        for (n = stringArray.length - 1; n >= 0; --n) {
            if ((n2 += stringArray[n].length()) <= this.fMaxLengthPerLab) continue;
            stringArray[n] = stringArray[n].substring(n2 - this.fMaxLengthPerLab);
            n2 = this.fMaxLengthPerLab;
            stringBuffer.delete(0, stringBuffer.length());
            this.fIsTruncated.put(instance, true);
            break;
        }
        int n3 = Math.max(0, n);
        int n4 = n2 + stringBuffer.length();
        if (n4 > this.fMaxLengthPerLab) {
            stringBuffer.delete(0, n4 - this.fMaxLengthPerLab);
            this.fIsTruncated.put(instance, true);
        }
        for (int i = n3; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        assert (stringBuffer.length() <= this.fMaxLengthPerLab) : "StringBuffer has not been trimmed to the correct length";
    }

    @Override
    public synchronized void closeForOutput() {
        this.fIsOpen = false;
    }

    @Override
    public synchronized String[] drainOutput() {
        return this.doDrainOutput(false);
    }

    @Override
    public synchronized String[] drainAllOutput() {
        return this.doDrainOutput(true);
    }

    private String[] doDrainOutput(boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Instance instance : this.fOutputBuffers.keySet()) {
            String string = this.getStringToPrint(instance, bl);
            if (string == null) continue;
            linkedList.add(string);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private String getStringToPrint(Instance instance, boolean bl) {
        StringBuffer stringBuffer = this.fOutputBuffers.get(instance);
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Draining output for lab: " + instance + "buffer length: " + stringBuffer.length());
        if (stringBuffer.length() == 0) {
            return null;
        }
        String string = "";
        if (bl) {
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
        } else {
            int n = stringBuffer.lastIndexOf("\n");
            if (n <= 0) {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "Nothing to print on " + instance);
                return null;
            }
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "From zero to " + n + " out of " + stringBuffer.length() + " on " + instance);
            string = stringBuffer.substring(n + 1, stringBuffer.length());
            stringBuffer.delete(n, stringBuffer.length());
        }
        if (this.fIsTruncated.get(instance).booleanValue()) {
            stringBuffer.insert(0, sTRUNCATED_MESSAGE);
            this.fIsTruncated.put(instance, false);
        }
        if (this.fPrintLabIndex) {
            String string2 = this.formatPrefix(instance);
            stringBuffer.insert(0, string2);
            string2 = this.continuationPrefix(string2);
            String string3 = '\n' + string2;
            int n = stringBuffer.indexOf("\n", string2.length());
            while (n >= 0) {
                stringBuffer.replace(n, n + 1, string3);
                n = stringBuffer.indexOf("\n", n + 1);
            }
        }
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Draining output for lab: " + instance + " sb buffer length: " + stringBuffer.length() + " retaining " + string.length() + " characters.");
        String string4 = stringBuffer.toString();
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.insert(0, string);
        return string4;
    }

    private String formatPrefix(Instance instance) {
        ProcessInstance processInstance = (ProcessInstance)instance;
        int n = processInstance.getLabIndex();
        String string = String.format(this.fLabIndexFormat, n);
        if (instance.equals(this.fLastProcessPrinted)) {
            string = this.continuationPrefix(string);
        } else {
            this.fLastProcessPrinted = instance;
        }
        return string;
    }

    private String continuationPrefix(String string) {
        return sCONTINUATION_PREFIX;
    }
}

