/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.BufferTransferCommand;
import com.mathworks.toolbox.distcomp.pmode.DependencyCommandResult;
import com.mathworks.toolbox.distcomp.pmode.DependencyExistsException;
import com.mathworks.toolbox.distcomp.pmode.FileDependenciesAssistant;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.Session;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.FileUtils;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import java.io.File;
import java.io.ObjectStreamException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;

public final class NewDirectoryDependencyCommand
extends BufferTransferCommand {
    private static final String ADD_COMMAND = "distcomp.pAddDependenciesFromZipfile";
    private transient File fClientDir;
    private final String fClientDirStr;
    private final boolean fIsAbsolute;
    private final String fRemoteName;

    public NewDirectoryDependencyCommand(ByteBufferHandle byteBufferHandle, File file) {
        super(byteBufferHandle);
        assert (file.isDirectory()) : "Must be constructed with a directory.";
        this.fClientDir = file;
        this.fClientDirStr = file.getPath();
        this.fIsAbsolute = file.isAbsolute();
        this.fRemoteName = this.fIsAbsolute ? this.fClientDir.getName() : this.fClientDir.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(ReturnGroup returnGroup, Instance instance, Session session) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Dispatch of NewDirectoryDependencyCommand for fClientDir: " + this.fClientDir + " with fRemoteName: " + this.fRemoteName + " and fIsAbsolute: " + this.fIsAbsolute + ".");
        DependencyCommandResult dependencyCommandResult = new DependencyCommandResult(this.getSequenceNumber());
        try {
            assert (this.fBuffer != null) : "Input ByteBuffer was null";
            FileDependenciesAssistant fileDependenciesAssistant = session.getFileDependenciesAssistant();
            if (fileDependenciesAssistant.dependencyExists(this.fClientDir)) {
                throw new DependencyExistsException(this.fClientDir.getPath() + " is already added as a FileDependency.");
            }
            final File file = File.createTempFile(UUID.randomUUID().toString(), ".zip");
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "NewDirectoryDependencyCommand: zipFile ( " + file + ") created.");
            this.writeBufferToFile(file);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "NewDirectoryDependencyCommand: buffer written to " + file + ".");
            MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            CompletionObserver completionObserver = new CompletionObserver(){

                public void completed(int n, Object object) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "NewDirectoryDependencyCommand: completion observer triggered for " + file + ".");
                    countDownLatch.countDown();
                    file.delete();
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "NewDirectoryDependencyCommand: " + file + " deleted.");
                }
            };
            matlabMCR.feval(ADD_COMMAND, new Object[]{file.getPath(), this.fClientDir.getPath(), fileDependenciesAssistant.getDependencyDir().getPath()}, 0, completionObserver);
            countDownLatch.await();
            File file2 = new File(fileDependenciesAssistant.getDependencyDir(), FileUtils.convertToLocalSeparators(this.fRemoteName));
            if (!fileDependenciesAssistant.addDependency(this.fClientDir, file2)) {
                throw new DependencyExistsException(this.fClientDir.getPath() + " : unexpectedly failed to add as a FileDependency");
            }
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Throwable caught during dispatch.", throwable);
            dependencyCommandResult.setException(throwable);
        }
        finally {
            if (this.fBuffer != null) {
                this.fBuffer.free();
            }
            returnGroup.returnTo(this.getSourceProcess(), dependencyCommandResult);
        }
    }

    private void unzipFileAndAddToPath(File file, File file2) {
    }

    private Object readResolve() throws ObjectStreamException {
        this.fClientDir = new File(this.fClientDirStr);
        return this;
    }
}

