/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.FinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MCommand;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageRegistry;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.Executor;
import com.mathworks.toolbox.distcomp.util.LimitedQueueExecutor;
import com.mathworks.toolbox.distcomp.util.Pair;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ReturnMessageDispatcherImpl
implements Dispatcher<ReturnMessage>,
ObservableMessageRegistry {
    private Executor fDispatchExec;
    private ErrorHandler fErrorHandler;
    private ConcurrentHashMap<Pair<Long, Instance>, List<MessageObserver>> fMessageObserverMap = new ConcurrentHashMap();
    private final Object fNewMessageObserverListLock = new Object();
    private List<MessageObserver> fNewMessageObserverList = Collections.synchronizedList(new LinkedList());

    public static ReturnMessageDispatcherImpl create(Executor executor, ErrorHandler errorHandler) {
        return new ReturnMessageDispatcherImpl(executor, errorHandler);
    }

    protected ReturnMessageDispatcherImpl(Executor executor, ErrorHandler errorHandler) {
        this.fDispatchExec = new LimitedQueueExecutor(executor, SessionConstants.sMAX_RETURN_MESSAGE_DISPATCH_IN_PROGRESS);
        this.fErrorHandler = errorHandler;
    }

    @Override
    public void dispatch(final ReturnMessage returnMessage, final Instance instance) {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Received a ReturnMessage with ID:" + returnMessage.getOriginalSequenceNumber() + " from src:" + instance);
        Pair<Long, Instance> pair = new Pair<Long, Instance>(returnMessage.getOriginalSequenceNumber(), instance);
        final List<MessageObserver> list = returnMessage instanceof FinalReturnMessage ? this.fMessageObserverMap.remove(pair) : this.fMessageObserverMap.get(pair);
        if (list == null) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "No observers for message with ID:" + returnMessage.getOriginalSequenceNumber() + " from src:" + instance);
            return;
        }
        try {
            this.fDispatchExec.execute(new Runnable(){

                @Override
                public void run() {
                    for (MessageObserver messageObserver : list) {
                        try {
                            if (messageObserver == null) continue;
                            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Message " + returnMessage.getClass().getSimpleName() + " " + returnMessage.getOriginalSequenceNumber() + " dispatched to " + messageObserver);
                            messageObserver.completed(returnMessage, instance);
                        }
                        catch (Throwable throwable) {
                            PackageInfo.LOGGER.log(DistcompLevel.ONE, "ReturnMessageObserver threw a Throwable.", throwable);
                        }
                    }
                }
            });
        }
        catch (Executor.ExecutorDestroyedException executorDestroyedException) {
            this.fErrorHandler.executorError(executorDestroyedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReturnMessageObserver(ObservableMessage observableMessage, Instance instance, MessageObserver messageObserver) {
        List<MessageObserver> list;
        Pair<Long, Instance> pair = new Pair<Long, Instance>(observableMessage.getSequenceNumber(), instance);
        Object object = this.fNewMessageObserverListLock;
        synchronized (object) {
            list = this.fMessageObserverMap.putIfAbsent(pair, this.fNewMessageObserverList);
            if (list == null) {
                list = this.fNewMessageObserverList;
                this.fNewMessageObserverList = Collections.synchronizedList(new LinkedList());
            }
        }
        list.add(messageObserver);
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Size of MessageObserverMap = " + this.fMessageObserverMap.size());
    }

    public MessageObserver removeMessageObserver(MCommand mCommand, int n) {
        return null;
    }

    @Override
    public Dispatcher<ReturnMessage> getDispatcher() {
        return this;
    }

    @Override
    public void destroy() {
        this.fMessageObserverMap.clear();
    }
}

