/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.BufferTransferCommand;
import com.mathworks.toolbox.distcomp.pmode.DependencyCommandResult;
import com.mathworks.toolbox.distcomp.pmode.FileDependenciesAssistant;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.Session;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.FileUtils;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;

public final class UpdateFileDependencyCommand
extends BufferTransferCommand {
    private static final String CLEAR_COMMAND = "clear";
    private transient File fDependency;
    private transient File fChangedFile;
    private final String fDependencyStr;
    private final String fChangedFileStr;

    public UpdateFileDependencyCommand(ByteBufferHandle byteBufferHandle, File file, File file2) {
        super(byteBufferHandle);
        this.fChangedFile = file;
        this.fChangedFileStr = file.getPath();
        assert (this.fChangedFile.getPath().startsWith(file2.getPath())) : "File MUST begin with the same string as provided to find it in dependency list";
        this.fDependency = file2;
        this.fDependencyStr = file2.getPath();
    }

    private File getLocalFile(FileDependenciesAssistant fileDependenciesAssistant) throws IOException {
        File file = fileDependenciesAssistant.getLocalFileFromRemoteFile(this.fChangedFile, this.fDependency);
        if (!file.exists()) {
            FileUtils.createNewFileAndParent(file);
        }
        if (!file.canWrite()) {
            throw new IOException(file.getPath() + " is not writeable");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(ReturnGroup returnGroup, Instance instance, Session session) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Dispatch of UpdateFileDependencyCommand for fChangedFile: " + this.fChangedFile + " in fDependency: " + this.fDependency);
        DependencyCommandResult dependencyCommandResult = new DependencyCommandResult(this.getSequenceNumber());
        try {
            assert (this.fBuffer != null) : "Input ByteBuffer was null";
            File file = this.getLocalFile(session.getFileDependenciesAssistant());
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "UpdateFileDependencyCommand: localFile: " + file);
            MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
            matlabMCR.fevalNoOutput(CLEAR_COMMAND, new Object[]{file.getPath()});
            this.writeBufferToFile(file);
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Throwable caught during dispatch.", throwable);
            dependencyCommandResult.setException(throwable);
        }
        finally {
            if (this.fBuffer != null) {
                this.fBuffer.free();
            }
            returnGroup.returnTo(this.getSourceProcess(), dependencyCommandResult);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        this.fDependency = new File(this.fDependencyStr);
        this.fChangedFile = new File(this.fChangedFileStr);
        return this;
    }
}

