/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.pmode.io.HeaderPayload;
import com.mathworks.toolbox.distcomp.pmode.io.MessageDirection;
import com.mathworks.toolbox.distcomp.pmode.io.Messages;
import com.mathworks.toolbox.distcomp.pmode.io.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.io.Selectable;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingRuntimeException;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.PmodeSerializable;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.Executor;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

final class TransmissionChannel
implements Selectable {
    private final BlockingQueue<HeaderPayload> fReceiveQueue;
    private final BlockingQueue<MessageHolder> fSendQueue;
    private HeaderPayload fPartiallyReceivedMessage;
    private final Connection fConnection;
    private Dispatcher<Message> fDispatcher = null;
    private Executor fDispatchExec = null;
    private ErrorHandler fErrorHandler;
    private SelectionKey fSelectionKey;

    TransmissionChannel(Connection connection, ErrorHandler errorHandler) throws PeerMessagingRuntimeException {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "In TransmissionChannel constructor for " + connection);
        this.fErrorHandler = errorHandler;
        this.fConnection = connection;
        try {
            this.fConnection.getSelectableChannel().configureBlocking(false);
        }
        catch (IOException iOException) {
            throw new PeerMessagingRuntimeException("IOException caught while configuring " + this.fConnection + " to not block.", iOException);
        }
        this.fSendQueue = new LinkedBlockingQueue<MessageHolder>();
        this.fReceiveQueue = new LinkedBlockingQueue<HeaderPayload>();
        this.fPartiallyReceivedMessage = Messages.createHeaderPayloadForReceive();
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Exiting TransmissionChannel constructor for " + connection);
    }

    @Override
    public Instance getRemoteProcess() {
        return this.fConnection.getRemoteInstance();
    }

    private void enqueueMessageForSending(HeaderPayload headerPayload) throws InterruptedException {
        MessageHolder messageHolder = new MessageHolder(headerPayload, MessageDirection.OUTGOING);
        messageHolder.acquireNecessaryPermits();
        this.fSendQueue.put(messageHolder);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Enqueued message, queue size now: " + this.fSendQueue.size());
    }

    private synchronized void dispatchOnExec(final HeaderPayload headerPayload) {
        assert (this.fDispatcher != null) : "No dispatcher!";
        assert (this.fDispatchExec != null) : "No executor!";
        final Dispatcher<Message> dispatcher = this.fDispatcher;
        try {
            final MessageHolder messageHolder = new MessageHolder(headerPayload, MessageDirection.INCOMING);
            messageHolder.acquireNecessaryPermits();
            this.fDispatchExec.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        PmodeSerializable pmodeSerializable = Messages.interpretCompletedMessage(headerPayload);
                        if (pmodeSerializable instanceof Message) {
                            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "actual dispatch of " + pmodeSerializable + " from: " + TransmissionChannel.this.fConnection.getRemoteInstance());
                            dispatcher.dispatch((Message)pmodeSerializable, TransmissionChannel.this.fConnection.getRemoteInstance());
                        } else {
                            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Received a message that was NOT and instanceof Message. This was of class " + pmodeSerializable.getClass().getName());
                        }
                    }
                    catch (Throwable throwable) {
                        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Error occurred during interpretation/dispatch", throwable);
                        TransmissionChannel.this.fErrorHandler.readError(TransmissionChannel.this.fConnection.getRemoteInstance(), throwable);
                    }
                    finally {
                        messageHolder.releaseAcquiredPermits();
                    }
                }
            });
        }
        catch (Executor.ExecutorDestroyedException executorDestroyedException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "No executor for dispatch", executorDestroyedException);
        }
    }

    synchronized void setDispatcher(Dispatcher<Message> dispatcher, Executor executor) {
        this.fDispatcher = dispatcher;
        this.fDispatchExec = executor;
        while (!this.fReceiveQueue.isEmpty()) {
            HeaderPayload headerPayload = (HeaderPayload)this.fReceiveQueue.remove();
            this.dispatchOnExec(headerPayload);
        }
    }

    @Override
    public void handleSelect() throws IOException {
        if (this.fConnection.isOpen() && this.fSelectionKey.isValid() && this.fSelectionKey.isReadable()) {
            while (this.handleRead() && this.fSelectionKey.isReadable()) {
            }
        }
        if (this.fConnection.isOpen() && this.fSelectionKey.isValid() && this.fSelectionKey.isWritable()) {
            while (this.handleWrite() && this.fSelectionKey.isWritable()) {
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.fSelectionKey.cancel();
        this.fConnection.close();
    }

    private void detectEndOfFile(long l) throws IOException {
        if (l == -1L) {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Read -1: EOF for connection " + this.fConnection);
            this.close();
            throw new EOFException("EOF while reading from " + this.fConnection);
        }
    }

    private long readFromChannel(ByteBuffer byteBuffer) throws IOException {
        long l = this.fConnection.read(byteBuffer);
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Read: " + l + " into " + byteBuffer + " from: " + this.fConnection);
        this.detectEndOfFile(l);
        return l;
    }

    private long readFromChannel(ByteBuffer[] byteBufferArray) throws IOException {
        long l = this.fConnection.read(byteBufferArray);
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Read: " + l + " into buffer array of length: " + byteBufferArray.length + " from: " + this.fConnection);
        this.detectEndOfFile(l);
        return l;
    }

    private static ByteBuffer[] handleArr2BufArr(ByteBufferHandle[] byteBufferHandleArray) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[byteBufferHandleArray.length];
        for (int i = 0; i < byteBufferHandleArray.length; ++i) {
            byteBufferArray[i] = byteBufferHandleArray[i].get();
        }
        return byteBufferArray;
    }

    private synchronized boolean handleRead() throws IOException {
        boolean bl;
        boolean bl2 = bl = this.fPartiallyReceivedMessage.isHeaderCompletelyTransmitted();
        if (!bl) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Attempting to read a header");
            this.readFromChannel(this.fPartiallyReceivedMessage.getHeaderMessage().get());
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Completed reading a header");
            if (this.fPartiallyReceivedMessage.isHeaderCompletelyTransmitted()) {
                Messages.configurePayload(this.fPartiallyReceivedMessage);
                bl = true;
            }
        }
        if (bl) {
            long l;
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Attempting to read the payload");
            if (l == 0L && !bl2) {
                long l2 = System.currentTimeMillis();
                for (l = this.readFromChannel(TransmissionChannel.handleArr2BufArr(this.fPartiallyReceivedMessage.getPayloadMessages())); l == 0L && System.currentTimeMillis() < l2 + 5L; l += this.readFromChannel(TransmissionChannel.handleArr2BufArr(this.fPartiallyReceivedMessage.getPayloadMessages()))) {
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.fPartiallyReceivedMessage.isPayloadCompletelyTransmitted()) {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "have read the payload");
                if (this.fDispatcher != null) {
                    assert (this.fReceiveQueue.isEmpty()) : "Receive queue was non-empty after dispatcher had been set";
                    this.dispatchOnExec(this.fPartiallyReceivedMessage);
                } else {
                    boolean bl3 = this.fReceiveQueue.offer(this.fPartiallyReceivedMessage);
                    if (!bl3) {
                        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to enqueue a received message");
                        assert (false) : "Failed to enqueue a received message";
                    }
                }
                this.fPartiallyReceivedMessage = Messages.createHeaderPayloadForReceive();
                return true;
            }
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Have not read the payload");
        }
        return false;
    }

    private int[] iLimitBuffers(ByteBuffer[] byteBufferArray) {
        int n = byteBufferArray.length;
        int[] nArray = new int[n];
        int n2 = 0x300000;
        for (int i = 0; i < n; ++i) {
            if (byteBufferArray[i].hasRemaining()) {
                int n3 = byteBufferArray[i].position();
                int n4 = Math.min(n3 + n2, byteBufferArray[i].limit());
                int n5 = n4 - n3;
                n2 -= n5;
                nArray[i] = byteBufferArray[i].limit();
                byteBufferArray[i].limit(n4);
                continue;
            }
            nArray[i] = -1;
        }
        return nArray;
    }

    private void iRestoreBufferLimits(ByteBuffer[] byteBufferArray, int[] nArray) {
        int n = byteBufferArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == -1) continue;
            byteBufferArray[i].limit(nArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleWrite() throws IOException {
        MessageHolder messageHolder = (MessageHolder)this.fSendQueue.peek();
        if (messageHolder == null) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "removeInterestOps(SelectionKey.OP_WRITE) for " + this.fConnection);
            this.removeInterestOps(4);
            return false;
        }
        HeaderPayload headerPayload = messageHolder.getHeaderPayload();
        ByteBuffer[] byteBufferArray = TransmissionChannel.handleArr2BufArr(headerPayload.getAllMessages());
        int[] nArray = this.iLimitBuffers(byteBufferArray);
        try {
            long l = this.fConnection.write(byteBufferArray);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Write: " + l + " to: " + this.fConnection);
        }
        finally {
            this.iRestoreBufferLimits(byteBufferArray, nArray);
        }
        if (headerPayload.isPayloadCompletelyTransmitted()) {
            for (ByteBufferHandle byteBufferHandle : headerPayload.getPayloadMessages()) {
                byteBufferHandle.free();
            }
            this.fSendQueue.remove(messageHolder);
            messageHolder.releaseAcquiredPermits();
            return true;
        }
        return false;
    }

    public void enqueueMessageForSending(PmodeSerializable pmodeSerializable) throws InterruptedException, IOException {
        this.enqueueMessageForSending(Messages.createHeaderPayloadForSend(pmodeSerializable));
    }

    void registerWithSelector(Selector selector, int n, Object object) throws ClosedChannelException {
        this.fSelectionKey = this.fConnection.getSelectableChannel().register(selector, n, object);
        if (!this.fSelectionKey.isValid()) {
            String string = "Invalid selection key " + this.fSelectionKey + " returned from registering " + this.fConnection;
            PackageInfo.LOGGER.log(DistcompLevel.TWO, string);
            assert (this.fSelectionKey.isValid()) : string;
        }
    }

    void addInterestOps(int n) {
        this.fSelectionKey.interestOps(this.fSelectionKey.interestOps() | n);
    }

    void removeInterestOps(int n) {
        this.fSelectionKey.interestOps(this.fSelectionKey.interestOps() & ~n);
    }

    public String toString() {
        return "TransmissionChannel{fConnection=" + this.fConnection + '}';
    }

    private static class MessageHolder {
        private static final Semaphore sOUTGOING_QUEUED_KB_LIMIT = new Semaphore(51200);
        private static final Semaphore sOUTGOING_QUEUED_DIRECT_KB_LIMIT = new Semaphore(512000);
        private static final Semaphore sINCOMING_QUEUED_KB_LIMIT = new Semaphore(51200);
        private static final Semaphore sINCOMING_QUEUED_DIRECT_KB_LIMIT = new Semaphore(512000);
        private HeaderPayload fHeaderPayload;
        private int fHeapAcquired;
        private int fDirectAcquired;
        private MessageDirection fDirection;
        private long fAcquisitionTime;
        private int fTotalMessageKb;

        MessageHolder(HeaderPayload headerPayload, MessageDirection messageDirection) {
            this.fHeaderPayload = headerPayload;
            this.fDirection = messageDirection;
            this.fHeapAcquired = 0;
            this.fDirectAcquired = 0;
            this.fAcquisitionTime = -1L;
        }

        HeaderPayload getHeaderPayload() {
            return this.fHeaderPayload;
        }

        void acquireNecessaryPermits() {
            int n = this.fHeaderPayload.heapKBytes();
            int n2 = this.fHeaderPayload.directKBytes();
            int n3 = Math.min(51200, n);
            int n4 = Math.min(512000, n2);
            this.fTotalMessageKb = n + n2;
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, (Object)((Object)this.fDirection) + " Permit acquisition: " + " heap: " + n3 + "(wanted: " + n + ")" + " direct: " + n4 + "(wanted: " + n2 + ")");
            switch (this.fDirection) {
                case INCOMING: {
                    PackageInfo.LOGGER.log(DistcompLevel.FIVE, "INCOMING permits available: heap: " + sINCOMING_QUEUED_KB_LIMIT.availablePermits() + ", direct: " + sINCOMING_QUEUED_DIRECT_KB_LIMIT.availablePermits());
                    sINCOMING_QUEUED_KB_LIMIT.acquireUninterruptibly(n3);
                    sINCOMING_QUEUED_DIRECT_KB_LIMIT.acquireUninterruptibly(n4);
                    this.fHeapAcquired = n3;
                    this.fDirectAcquired = n4;
                    break;
                }
                case OUTGOING: {
                    PackageInfo.LOGGER.log(DistcompLevel.FIVE, "OUTGOING permits available: heap: " + sOUTGOING_QUEUED_KB_LIMIT.availablePermits() + ", direct: " + sOUTGOING_QUEUED_DIRECT_KB_LIMIT.availablePermits());
                    sOUTGOING_QUEUED_KB_LIMIT.acquireUninterruptibly(n3);
                    sOUTGOING_QUEUED_DIRECT_KB_LIMIT.acquireUninterruptibly(n4);
                    this.fHeapAcquired = n3;
                    this.fDirectAcquired = n4;
                }
            }
            this.fAcquisitionTime = System.currentTimeMillis();
        }

        void releaseAcquiredPermits() {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, (Object)((Object)this.fDirection) + " Permit release: " + " heap: " + this.fHeapAcquired + " direct: " + this.fDirectAcquired);
            switch (this.fDirection) {
                case INCOMING: {
                    sINCOMING_QUEUED_DIRECT_KB_LIMIT.release(this.fDirectAcquired);
                    sINCOMING_QUEUED_KB_LIMIT.release(this.fHeapAcquired);
                    break;
                }
                case OUTGOING: {
                    sOUTGOING_QUEUED_DIRECT_KB_LIMIT.release(this.fDirectAcquired);
                    sOUTGOING_QUEUED_KB_LIMIT.release(this.fHeapAcquired);
                    long l = System.currentTimeMillis() - this.fAcquisitionTime;
                    PackageInfo.LOGGER.log(DistcompLevel.SIX, "Message size: " + this.fTotalMessageKb + " Kb " + "sent in " + l + " ms");
                }
            }
        }
    }
}

