/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.peermessaging.ProtocolId;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.util.Pair;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class ProcessInstance
implements Instance,
Comparable<ProcessInstance> {
    public static final int CLIENT_VALUE_FOR_LAB_FEATURES = -1;
    private ProcessType fType;
    private static ProcessInstance sClientInstance = null;
    private static Map<Integer, ProcessInstance> sLabInstanceMap = null;
    private static ProcessInstance sThisProcess = null;

    private ProcessInstance(ProcessType processType) {
        this.fType = processType;
    }

    @Override
    public int compareTo(ProcessInstance processInstance) {
        if (processInstance == null) {
            throw new NullPointerException("Attempted comparison of ProcessInstance with null");
        }
        return this.fType == ProcessType.CLIENT ? 1 : -1;
    }

    public ProcessType getProcessType() {
        return this.fType;
    }

    public int getLabIndex() {
        throw new IllegalStateException("Cannot ask " + (Object)((Object)this.fType) + " for labindex");
    }

    @Override
    public ProtocolId getProtocolId() {
        throw new UnsupportedOperationException("ProcessInstances can not be encoded and decoded.");
    }

    @Override
    public int getByteLengthOfInstanceBootstrap() {
        throw new UnsupportedOperationException("ProcessInstances can not be encoded and decoded.");
    }

    @Override
    public void encodeInstanceBootstrap(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("ProcessInstances can not be encoded and decoded.");
    }

    @Override
    public ProcessInstance decodeRemoteInstanceBootstrap(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("ProcessInstances can not be encoded and decoded.");
    }

    @Override
    public UUID getGroupUuid() {
        throw new UnsupportedOperationException("A ProcessInstance does not have a group UUID.");
    }

    @Override
    public UUID getUuid() {
        throw new UnsupportedOperationException("A ProcessInstance does not have a peer UUID.");
    }

    public static synchronized ProcessInstance getThisProcess() {
        assert (sThisProcess != null) : "setThisProcess() must be called before getThisProcess()";
        return sThisProcess;
    }

    public static synchronized void setThisProcess(ProcessInstance processInstance) {
        sThisProcess = processInstance;
    }

    public static synchronized ProcessInstance getLabInstance(int n) {
        if (sLabInstanceMap == null) {
            sLabInstanceMap = new HashMap<Integer, ProcessInstance>();
        }
        if (!sLabInstanceMap.containsKey(n)) {
            sLabInstanceMap.put(n, new LabProcessInstance(n));
        }
        return sLabInstanceMap.get(n);
    }

    public static synchronized ProcessInstance[] getAllLabs(int n) {
        ProcessInstance[] processInstanceArray = new ProcessInstance[n];
        for (int i = 0; i < n; ++i) {
            processInstanceArray[i] = ProcessInstance.getLabInstance(1 + i);
        }
        return processInstanceArray;
    }

    public static synchronized ProcessInstance getClientInstance() {
        if (sClientInstance == null) {
            sClientInstance = new ClientProcessInstance();
        }
        return sClientInstance;
    }

    public static Pair<ProcessInstance, Integer> decodeProcessInstance(int n, int n2, int n3) {
        if (ProcessType.CLIENT.getProcessTypeCode() == n) {
            return new Pair<ProcessInstance, Integer>(ProcessInstance.getClientInstance(), n3);
        }
        if (ProcessType.LAB.getProcessTypeCode() == n) {
            return new Pair<ProcessInstance, Integer>(ProcessInstance.getLabInstance(n2), n3);
        }
        throw new IllegalArgumentException("Can not decode " + n + " as a processTypeCode.");
    }

    private static class ClientProcessInstance
    extends ProcessInstance {
        private ClientProcessInstance() {
            super(ProcessType.CLIENT);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof ClientProcessInstance;
        }

        public int hashCode() {
            return -1;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[Process: ");
            stringBuffer.append(this.getProcessType().toString());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private static class LabProcessInstance
    extends ProcessInstance {
        private int fLabIndex;

        private LabProcessInstance(int n) {
            super(ProcessType.LAB);
            this.fLabIndex = n;
        }

        @Override
        public int compareTo(ProcessInstance processInstance) {
            if (processInstance == null) {
                throw new NullPointerException("Attempted comparison of ProcessInstance with null");
            }
            if (processInstance instanceof LabProcessInstance) {
                LabProcessInstance labProcessInstance = (LabProcessInstance)processInstance;
                return this.fLabIndex - labProcessInstance.getLabIndex();
            }
            return super.compareTo(processInstance);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LabProcessInstance)) {
                return false;
            }
            LabProcessInstance labProcessInstance = (LabProcessInstance)object;
            return labProcessInstance.fLabIndex == this.fLabIndex;
        }

        @Override
        public int getLabIndex() {
            return this.fLabIndex;
        }

        public int hashCode() {
            return this.fLabIndex;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[Process: ");
            stringBuffer.append(this.getProcessType().toString());
            stringBuffer.append(" ");
            stringBuffer.append(this.fLabIndex);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    public static enum ProcessType {
        CLIENT(1, "client"),
        LAB(0, "lab");

        private final int fCode;
        private final String fString;

        private ProcessType(int n2, String string2) {
            this.fCode = n2;
            this.fString = string2;
        }

        public int getProcessTypeCode() {
            return this.fCode;
        }

        public String toString() {
            return this.fString;
        }
    }
}

