/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.shared.AcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import java.io.Serializable;
import java.util.UUID;

public final class ServerSocketAcceptInfo
implements AcceptInfo,
Serializable {
    public static final int DEFAULT_BACKLOG = 10;
    public static final int DEFAULT_OFFSET = 0;
    public static final int DEFAULT_STEP = 1;
    private final UUID fGroupUuid;
    private final AcceptorSecurityDescription fSecurityDescription;
    private final int fMinPort;
    private final int fMaxPort;
    private final int fPortOffset;
    private final int fPortStep;
    private final int fBacklog;
    private final long fHandShakeTimeout;
    private static final UUID TEMPLATE_UUID = new UUID(0L, 0L);
    private static final AcceptorSecurityDescription TEMPLATE_SECURITY_DESCRIPTION = null;

    public ServerSocketAcceptInfo(UUID uUID, int n, int n2, int n3, int n4, int n5, AcceptorSecurityDescription acceptorSecurityDescription, long l) {
        if (n4 <= 0) {
            throw new IllegalArgumentException("portStep must be greater than zero but is " + n4);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("portOffset must be zero or greater but is " + n3);
        }
        if (n + n3 > n2) {
            throw new IllegalArgumentException("minPort " + n + " plus portOffset must be less than or equal to maxPort " + n2);
        }
        this.fGroupUuid = uUID;
        this.fSecurityDescription = acceptorSecurityDescription;
        this.fMinPort = n;
        this.fMaxPort = n2;
        this.fPortOffset = n3;
        this.fPortStep = n4;
        this.fBacklog = n5;
        this.fHandShakeTimeout = l;
    }

    public ServerSocketAcceptInfo(UUID uUID, int n, int n2, AcceptorSecurityDescription acceptorSecurityDescription, long l) {
        this(uUID, n, n, 0, 1, n2, acceptorSecurityDescription, l);
    }

    @Override
    public UUID getGroupUUID() {
        return this.fGroupUuid;
    }

    @Override
    public AcceptorSecurityDescription getAcceptorSecurityDescription() {
        return this.fSecurityDescription;
    }

    @Override
    public long getHandShakeTimeout() {
        return this.fHandShakeTimeout;
    }

    public int getMinPort() {
        return this.fMinPort;
    }

    public int getMaxPort() {
        return this.fMaxPort;
    }

    public int getPortOffset() {
        return this.fPortOffset;
    }

    public int getPortStep() {
        return this.fPortStep;
    }

    public int getBacklog() {
        return this.fBacklog;
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName() + " for group " + this.fGroupUuid;
    }

    @Override
    public boolean peersConnectingAsGroupShareBarrier() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ServerSocketAcceptInfo serverSocketAcceptInfo = (ServerSocketAcceptInfo)object;
        if (this.fBacklog != serverSocketAcceptInfo.fBacklog) {
            return false;
        }
        if (this.fHandShakeTimeout != serverSocketAcceptInfo.fHandShakeTimeout) {
            return false;
        }
        if (this.fMaxPort != serverSocketAcceptInfo.fMaxPort) {
            return false;
        }
        if (this.fMinPort != serverSocketAcceptInfo.fMinPort) {
            return false;
        }
        if (this.fPortOffset != serverSocketAcceptInfo.fPortOffset) {
            return false;
        }
        if (this.fPortStep != serverSocketAcceptInfo.fPortStep) {
            return false;
        }
        if (!this.fGroupUuid.equals(serverSocketAcceptInfo.fGroupUuid)) {
            return false;
        }
        return this.fSecurityDescription.equals(serverSocketAcceptInfo.fSecurityDescription);
    }

    public int hashCode() {
        int n = this.fGroupUuid.hashCode();
        n = 31 * n + this.fSecurityDescription.hashCode();
        n = 31 * n + this.fMinPort;
        n = 31 * n + this.fMaxPort;
        n = 31 * n + this.fPortOffset;
        n = 31 * n + this.fPortStep;
        n = 31 * n + this.fBacklog;
        n = 31 * n + (int)(this.fHandShakeTimeout ^ this.fHandShakeTimeout >>> 32);
        return n;
    }

    public String toString() {
        return "ServerSocketAcceptInfo{fGroupUuid=" + this.fGroupUuid + ", fSecurityDescription=" + this.fSecurityDescription + ", fMinPort=" + this.fMinPort + ", fMaxPort=" + this.fMaxPort + ", fPortOffset=" + this.fPortOffset + ", fPortStep=" + this.fPortStep + ", fBacklog=" + this.fBacklog + ", fHandShakeTimeout=" + this.fHandShakeTimeout + '}';
    }

    public static ServerSocketAcceptInfo createTemplate(int n, int n2, int n3) {
        return new ServerSocketAcceptInfo(TEMPLATE_UUID, n, n2, 0, 1, n3, TEMPLATE_SECURITY_DESCRIPTION, 10000L);
    }

    public ServerSocketAcceptInfo createFromTemplate(UUID uUID, AcceptorSecurityDescription acceptorSecurityDescription, long l) {
        return new ServerSocketAcceptInfo(uUID, this.fMinPort, this.fMaxPort, this.fPortOffset, this.fPortStep, this.fBacklog, acceptorSecurityDescription, l);
    }

    public ServerSocketAcceptInfo createWithNewPortOffsetAndStep(int n, int n2) {
        return new ServerSocketAcceptInfo(this.fGroupUuid, this.fMinPort, this.fMaxPort, n, n2, this.fBacklog, this.fSecurityDescription, this.fHandShakeTimeout);
    }
}

