/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.cli;

import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.CredentialDescription;
import com.mathworks.toolbox.distcomp.remote.CredentialParameter;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.NoMatchingProtocolException;
import com.mathworks.toolbox.distcomp.remote.NoSuchProtocolException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ProtocolProvider;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.cli.FactoryRegistry;
import com.mathworks.toolbox.distcomp.remote.cli.GlobalParameter;
import com.mathworks.toolbox.distcomp.remote.cli.InternalStateException;
import com.mathworks.toolbox.distcomp.remote.cli.ResourceHandler;
import com.mathworks.toolbox.distcomp.remote.spi.Protocol;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class HelpPrinter {
    private static final String COMMAND_TYPE_PROPERTY = System.getProperty("commandtype");
    private final FactoryRegistry fRegistry;
    private final ResourceHandler fHandler;
    private final String fScriptName;
    private final HelpItemFactory fFactory;
    private final List<HelpItem> fGlobalItems;

    public HelpPrinter(FactoryRegistry factoryRegistry, ResourceHandler resourceHandler, String string) {
        this.fRegistry = factoryRegistry;
        this.fHandler = resourceHandler;
        this.fScriptName = string;
        this.fFactory = new HelpItemFactory(this.fHandler);
        this.fGlobalItems = new LinkedList<HelpItem>();
        this.fGlobalItems.add(this.fFactory.create(GlobalParameter.REMOTE_HOST, new Object[0]));
        this.fGlobalItems.add(this.fFactory.create(GlobalParameter.REMOTE_PLATFORM_TYPE, new Object[0]));
        this.fGlobalItems.add(this.fFactory.create(GlobalParameter.USE_BACKSLASH, new Object[0]));
        this.fGlobalItems.add(this.fFactory.create(GlobalParameter.QUIET, new Object[0]));
        this.fGlobalItems.add(this.fFactory.create(GlobalParameter.LOG, new Object[0]));
        this.fGlobalItems.add(this.fFactory.create(GlobalParameter.HELP, new Object[0]));
    }

    public void printHelpAndExit(RemoteExecutionException remoteExecutionException, String string, String string2, boolean bl) {
        Object object;
        List<HelpItem> list;
        if (remoteExecutionException != null) {
            list = new StringWriter();
            remoteExecutionException.printStackTrace(new PrintWriter((Writer)((Object)list)));
            Logger.LOGGER.warning(((StringWriter)((Object)list)).toString());
            object = remoteExecutionException.getMessage();
            if (bl) {
                System.err.println("\nError: " + (String)object);
            } else {
                this.error((String)object);
            }
        }
        list = COMMAND_TYPE_PROPERTY == null ? this.createHelpItems(string, string2) : this.createHelpItemsFixedCommandType(COMMAND_TYPE_PROPERTY, string2);
        if (string2 == null) {
            object = this.fFactory.create("NO.Protocol");
        } else {
            try {
                object = this.fFactory.create(string2.toUpperCase() + ".Protocol");
            }
            catch (InternalStateException internalStateException) {
                object = null;
            }
        }
        System.out.println(this.formatOutput(this.fFactory.create(this.fScriptName.toUpperCase() + ".Header"), (HelpItem)object, this.fFactory.create(this.fScriptName.toUpperCase() + ".Footer"), this.fFactory.create(this.fScriptName.toUpperCase() + ".Examples"), list));
        System.exit(0);
    }

    private List<HelpItem> createHelpItemsFixedCommandType(String string, String string2) {
        assert (string != null);
        Protocol protocol = null;
        if (string2 != null) {
            try {
                protocol = ProtocolProvider.getInstance().getProtocolByType(string2);
            }
            catch (NoSuchProtocolException noSuchProtocolException) {
                this.error("protocol " + string2 + " does not exist.");
            }
        }
        Class<? extends Command> clazz = this.fRegistry.getCommandClassByType(string);
        if (protocol != null && !protocol.getCommandClass().isAssignableFrom(clazz)) {
            this.error("protocol " + string2 + " cannot be used for " + "command type " + string);
        }
        LinkedList<HelpItem> linkedList = new LinkedList<HelpItem>();
        linkedList.add(this.fFactory.create(clazz));
        for (Parameter<?> parameter : this.fRegistry.getFactoryByCommandClass(clazz).getParameterSet().getParameters()) {
            linkedList.add(this.fFactory.create(parameter, new Object[0]));
        }
        List<HelpItem> list = this.createProtocolHelpItems(protocol, clazz);
        return this.concatHelpItems(linkedList, list);
    }

    public List<HelpItem> createHelpItems(String string, String string2) {
        LinkedList<HelpItem> linkedList = new LinkedList<HelpItem>();
        HelpItem helpItem = string == null ? (string2 == null ? this.fFactory.create(GlobalParameter.COMMAND_TYPE, this.fRegistry.getCommandTypes().toString()) : this.fFactory.create(string2, "", "")) : this.fFactory.create(string, "", "");
        linkedList.add(helpItem);
        Protocol protocol = null;
        if (string2 != null) {
            try {
                protocol = ProtocolProvider.getInstance().getProtocolByType(string2);
            }
            catch (NoSuchProtocolException noSuchProtocolException) {
                this.error("protocol " + string2 + " does not exist.");
            }
        }
        Class<? extends Command> clazz = null;
        if (string == null) {
            if (protocol != null) {
                clazz = protocol.getCommandClass();
            }
        } else {
            clazz = this.fRegistry.getCommandClassByType(string);
            if (protocol != null && !protocol.getCommandClass().isAssignableFrom(clazz)) {
                this.error("protocol " + string2 + " cannot be used for " + "command type " + string);
            }
        }
        if (clazz == null) {
            linkedList.add(this.fFactory.create("CommandType"));
        } else {
            linkedList.add(this.fFactory.create(clazz));
            for (Parameter parameter : this.fRegistry.getFactoryByCommandClass(clazz).getParameterSet().getParameters()) {
                linkedList.add(this.fFactory.create(parameter, new Object[0]));
            }
        }
        List<HelpItem> list = this.createProtocolHelpItems(protocol, clazz);
        return this.concatHelpItems(linkedList, list);
    }

    private List<HelpItem> createProtocolHelpItems(Protocol protocol, Class<? extends Command> clazz) {
        LinkedList<HelpItem> linkedList = new LinkedList<HelpItem>();
        if (protocol == null) {
            List<String> list = null;
            if (clazz == null) {
                list = ProtocolProvider.getInstance().getProtocolTypes();
            } else {
                try {
                    list = ProtocolProvider.getInstance().getProtocolTypes(clazz);
                }
                catch (NoMatchingProtocolException noMatchingProtocolException) {
                    this.error("no available protocols found for command type " + clazz.getSimpleName());
                }
            }
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!this.fHandler.isResourceUndocumented(iterator.next())) continue;
                iterator.remove();
            }
            linkedList.add(this.fFactory.create(GlobalParameter.PROTOCOL, list.toString(), this.fScriptName));
            linkedList.add(this.fFactory.create("ProtocolType"));
        } else {
            for (Parameter<?> parameter : protocol.getParameterSet().getParameters()) {
                if (parameter instanceof CredentialParameter) {
                    CredentialParameter credentialParameter = (CredentialParameter)parameter;
                    linkedList.addAll(this.addCredentialDescriptions(credentialParameter.getPossibleCredentialDescriptions()));
                    linkedList.add(HelpItem.SEPARATOR);
                    continue;
                }
                linkedList.add(this.fFactory.create(parameter, new Object[0]));
            }
        }
        return linkedList;
    }

    private List<HelpItem> addCredentialDescriptions(Set<CredentialDescription> set) {
        LinkedHashSet<CredentialDescription> linkedHashSet = new LinkedHashSet<CredentialDescription>();
        for (CredentialDescription object2 : set) {
            if (object2.getParameterSet().getParameters().isEmpty()) continue;
            linkedHashSet.add(object2);
        }
        LinkedList linkedList = new LinkedList();
        switch (linkedHashSet.size()) {
            case 0: {
                break;
            }
            case 1: {
                Iterator iterator = linkedHashSet.iterator();
                for (Parameter<?> parameter : ((CredentialDescription)iterator.next()).getParameterSet().getParameters()) {
                    linkedList.add(this.fFactory.create(parameter, new Object[0]));
                }
                break;
            }
            default: {
                linkedList.add(HelpItem.OR_START);
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    for (Parameter<?> parameter : ((CredentialDescription)iterator.next()).getParameterSet().getParameters()) {
                        linkedList.add(this.fFactory.create(parameter, new Object[0]));
                    }
                    if (!iterator.hasNext()) continue;
                    linkedList.add(HelpItem.OR_SEP);
                }
                linkedList.add(HelpItem.OR_END);
            }
        }
        return linkedList;
    }

    public List<HelpItem> concatHelpItems(List<HelpItem> list, List<HelpItem> list2) {
        LinkedList<HelpItem> linkedList = new LinkedList<HelpItem>();
        linkedList.addAll(list);
        if (list.size() > 0) {
            linkedList.add(HelpItem.SEPARATOR);
        }
        linkedList.addAll(this.fGlobalItems);
        if (this.fGlobalItems.size() > 0) {
            linkedList.add(HelpItem.SEPARATOR);
        }
        linkedList.addAll(list2);
        return linkedList;
    }

    private void error(String string) {
        System.err.println("\nError: " + string);
        System.err.println("Type '" + this.fScriptName + " -help' for more information.\n");
        System.exit(1);
    }

    private String formatOutput(HelpItem helpItem, HelpItem helpItem2, HelpItem helpItem3, HelpItem helpItem4, List<HelpItem> list) {
        int n = this.computeKeyWidth(list);
        StringBuilder stringBuilder = new StringBuilder("\n");
        stringBuilder.append(helpItem.getKeyDescriptionString(n));
        if (helpItem2 != null) {
            stringBuilder.append(helpItem2.getKeyDescriptionString(n));
        }
        String string = "Usage: " + this.fScriptName;
        String string2 = String.format("%" + string.length() + "s", "");
        for (HelpItem helpItem5 : list) {
            String string3 = helpItem5.getKeyValueString(string);
            if (string3.length() <= 0) continue;
            stringBuilder.append(string3);
            string = string2;
        }
        stringBuilder.append("\n");
        for (HelpItem helpItem5 : new LinkedHashSet<HelpItem>(list)) {
            stringBuilder.append(helpItem5.getKeyDescriptionString(n));
        }
        stringBuilder.append(helpItem4.getKeyDescriptionString(n));
        stringBuilder.append(helpItem3.getKeyDescriptionString(n));
        return stringBuilder.toString();
    }

    private int computeKeyWidth(List<HelpItem> list) {
        int n = 0;
        for (HelpItem helpItem : list) {
            String string = helpItem.getKey();
            if (string.length() > 16) continue;
            n = Math.max(string.length(), n);
        }
        return n;
    }

    private static final class HelpItem {
        private static final int LINE_WIDTH = 80;
        public static final HelpItem SEPARATOR = new HelpItem("", "", "", false, new Object[0]);
        static final HelpItem OR_START = new HelpItem("\b\b{", "", "", false, new Object[0]);
        static final HelpItem OR_SEP = new HelpItem("\b\b} or {", "", "", false, new Object[0]);
        static final HelpItem OR_END = new HelpItem("\b\b}", "", "", false, new Object[0]);
        private String fKey;
        private String fValue;
        private String fDescription;
        private boolean fOptional;
        private Object[] fArgs;
        private boolean fHidden = false;

        HelpItem(String string, String string2, String string3, boolean bl, Object ... objectArray) {
            this.fKey = string;
            this.fValue = string2;
            this.fDescription = string3;
            this.fOptional = bl;
            this.fArgs = objectArray;
        }

        String getKey() {
            return this.fKey;
        }

        void setHidden(boolean bl) {
            this.fHidden = bl;
        }

        String getKeyValueString(String string) {
            if (this.fHidden) {
                return "";
            }
            if (this != SEPARATOR && this.fKey.length() == 0 && this.fValue.length() == 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(this.fKey);
            if (this.fValue != null && this.fValue.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.fValue);
            }
            if (this.fOptional) {
                stringBuilder.insert(0, "[ ").append(" ]");
            }
            return HelpItem.formatDescription(string, string.length(), stringBuilder.toString());
        }

        String getKeyDescriptionString(int n) {
            if (this.fHidden) {
                return "";
            }
            if (this == SEPARATOR || this.fDescription.length() == 0) {
                return "";
            }
            return HelpItem.formatDescription(this.fKey, n, String.format(this.fDescription, this.fArgs)) + "\n";
        }

        private static String formatDescription(String string, int n, String string2) {
            int n2 = 80 - n - 3;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : HelpItem.wrap(string2, n2)) {
                if (string.length() > n) {
                    stringBuilder.append(string).append("\n");
                    string = "";
                }
                stringBuilder.append(String.format("%-" + n + "s  %s\n", string, string3));
                string = "";
            }
            return stringBuilder.toString();
        }

        private static List<String> wrap(String string, int n) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string2 : string.split("\n")) {
                int n2;
                do {
                    int n3;
                    if ((n2 = string2.length()) >= n && (n3 = string2.lastIndexOf(" ", n)) >= 0) {
                        n2 = n3;
                    }
                    linkedList.add(string2.substring(0, n2));
                } while ((string2 = string2.substring(n2).trim()).length() > 0);
            }
            return linkedList;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof HelpItem)) {
                return false;
            }
            return this.fKey.equals(((HelpItem)object).fKey);
        }

        public int hashCode() {
            return this.fKey.hashCode();
        }
    }

    private static final class HelpItemFactory {
        private ResourceHandler fHandler;

        HelpItemFactory(ResourceHandler resourceHandler) {
            this.fHandler = resourceHandler;
        }

        HelpItem create(Parameter<?> parameter, Object ... objectArray) {
            HelpItem helpItem = new HelpItem(this.fHandler.getResourceKey(parameter), this.fHandler.getResourceValue(parameter), this.fHandler.getResourceDescription(parameter), this.isParameterOptional(parameter), objectArray);
            helpItem.setHidden(this.fHandler.isResourceUndocumented(parameter));
            return helpItem;
        }

        HelpItem create(String string) {
            string = "Usage." + string;
            String string2 = this.fHandler.getResourceKey(string);
            String string3 = this.fHandler.getResourceValue(string);
            String string4 = this.fHandler.getResourceDescription(string);
            return new HelpItem(string2, string3, string4, false, new Object[0]);
        }

        HelpItem create(Class<? extends Command> clazz) {
            return this.create(clazz.getSimpleName());
        }

        HelpItem create(String string, String string2, String string3) {
            return new HelpItem(string, string2, string3, false, new Object[0]);
        }

        private boolean isParameterOptional(Parameter<?> parameter) {
            return !parameter.isRequired() || parameter.promptFor();
        }
    }
}

