/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.mathworks.toolbox.distcomp.remote.CopyFromRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.CopyFuture;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.spi.Lease;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.FilePermissions;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchFutureHelper;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchLeasableSession;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSCPAcknowledgeException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSCPCommandException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSessionLeaseSource;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Level;

final class JSchCopyFromFuture
implements CopyFuture,
Runnable {
    private final JSchFutureHelper fHelper;
    private final CopyFromRemoteCommand fCommand;
    private static final int BUFFER_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSchCopyFromFuture createJschCopyFromFuture(CopyFromRemoteCommand copyFromRemoteCommand, String string, ParameterMap parameterMap, String string2) throws DispatchException {
        boolean bl = false;
        Lease<JSchLeasableSession> lease = null;
        try {
            lease = JSchSessionLeaseSource.INSTANCE.getLease(string, parameterMap);
            JSchCopyFromFuture jSchCopyFromFuture = new JSchCopyFromFuture(copyFromRemoteCommand, lease, string2);
            JSchFutureHelper.startThread(jSchCopyFromFuture, string2);
            bl = true;
            JSchCopyFromFuture jSchCopyFromFuture2 = jSchCopyFromFuture;
            return jSchCopyFromFuture2;
        }
        finally {
            if (!bl && lease != null) {
                lease.release();
            }
        }
    }

    private JSchCopyFromFuture(CopyFromRemoteCommand copyFromRemoteCommand, Lease<JSchLeasableSession> lease, String string) throws ProtocolDispatchException {
        try {
            this.fCommand = copyFromRemoteCommand;
            String string2 = JSchCopyFromFuture.createScpCommand(this.fCommand.getRemoteFile());
            ChannelExec channelExec = JSchCopyFromFuture.createChannelExec(lease.getLeasedConnection().getSession(), string2, string);
            this.fHelper = new JSchFutureHelper(lease, (Channel)channelExec, string);
        }
        catch (JSchException jSchException) {
            throw new ProtocolDispatchException(string + "Could not connect to channel.", (Throwable)jSchException);
        }
    }

    private static String createScpCommand(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("scp ");
        stringBuilder.append("-d -r -f ");
        stringBuilder.append("\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private static ChannelExec createChannelExec(Session session, String string, String string2) throws JSchException {
        ChannelExec channelExec = (ChannelExec)session.openChannel("exec");
        channelExec.setCommand(string);
        Logger.LOGGER.finest(string2 + " " + string);
        return channelExec;
    }

    @Override
    public void cancel() {
        this.fHelper.cancel();
    }

    @Override
    public boolean isRunning() {
        return this.fHelper.isRunning();
    }

    @Override
    public void awaitEnd() throws InterruptedException, FulfillmentException {
        this.fHelper.awaitEnd();
    }

    public boolean isExitStatusOfRemoteCommand() {
        return this.fHelper.isExitStatusOfRemoteCommand();
    }

    public int getExitStatus() throws InterruptedException, FulfillmentException {
        return this.fHelper.getExitStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                try {
                    if (!this.fHelper.hasBeenCancelled()) {
                        this.fHelper.connectToChannel();
                        this.copyFilesFrom();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.LOGGER.log(Level.FINE, this.fHelper.getLogIDString() + ": interrupted", interruptedException);
                }
                catch (Exception exception) {
                    this.fHelper.handleException(exception);
                }
                finally {
                    this.fHelper.disconnectFromChannel();
                }
            }
            finally {
                this.fHelper.releaseLease();
            }
        }
        finally {
            this.fHelper.signalCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFilesFrom() throws IOException, InterruptedException, JSchSCPAcknowledgeException, JSchSCPCommandException {
        File file = this.findTargetDirectory();
        OutputStream outputStream = null;
        try {
            outputStream = this.fHelper.getOutputStream();
            InputStream inputStream = null;
            try {
                inputStream = this.fHelper.getInputStream();
                this.copyFilesFrom(true, file, inputStream, outputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        this.fHelper.waitForChannelToClose();
        Logger.LOGGER.fine(this.fHelper.getLogIDString() + ": completed ");
    }

    private File findTargetDirectory() {
        File file = this.getLocalFile().getAbsoluteFile().getParentFile();
        if (this.getLocalFile().isDirectory()) {
            file = this.getLocalFile().getAbsoluteFile();
        }
        return file;
    }

    private File getLocalFile() {
        return this.fCommand.getLocalFile();
    }

    private boolean checkCancelled(OutputStream outputStream) throws IOException {
        boolean bl = this.fHelper.hasBeenCancelled();
        if (bl) {
            this.sendAck(2, outputStream);
        }
        return bl;
    }

    private void copyFilesFrom(boolean bl, File file, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPAcknowledgeException, JSchSCPCommandException {
        if (bl) {
            this.sendAck(0, outputStream);
        }
        boolean bl2 = true;
        do {
            if (!this.checkCancelled(outputStream)) {
                int n = inputStream.read();
                if (n == 67) {
                    this.copyFileFrom(bl, file, inputStream, outputStream);
                    continue;
                }
                if (n == 68) {
                    this.copyDirectoryFrom(bl, file, inputStream, outputStream);
                    continue;
                }
                if (n == 69) {
                    this.receiveLine(inputStream);
                    this.sendAck(0, outputStream);
                    bl2 = false;
                    continue;
                }
                if (n == 84) {
                    this.receiveLine(inputStream);
                    Logger.LOGGER.warning(this.fHelper.getLogIDString() + ": T not supported. Can not preserve access and modifications times.");
                    continue;
                }
                if (n == -1) {
                    if (!bl) {
                        throw new JSchSCPCommandException(this.fHelper.getLogIDString() + ": unexpected end of file.");
                    }
                    bl2 = false;
                    continue;
                }
                if (n == 1 || n == 2) {
                    String string = this.receiveLine(inputStream);
                    throw new JSchSCPCommandException(" scp error:" + string + " " + n);
                }
                String string = this.receiveLine(inputStream);
                throw new JSchSCPCommandException("Don't know how to interpret " + n + " " + string);
            }
            bl2 = false;
        } while (bl2);
    }

    private void setFilePermissions(byte[] byArray, File file) {
        byte[] byArray2 = new byte[]{byArray[1]};
        byte[] byArray3 = new byte[]{byArray[3]};
        byte by = Byte.parseByte(new String(byArray2));
        byte by2 = Byte.parseByte(new String(byArray3));
        boolean bl = (by & 1) != 0;
        boolean bl2 = (by & 2) != 0;
        boolean bl3 = (by & 4) != 0;
        boolean bl4 = (by2 & 2) != 0;
        boolean bl5 = (by2 & 2) != 0;
        boolean bl6 = (by2 & 4) != 0;
        FilePermissions filePermissions = new FilePermissions(bl, bl3, bl2, bl4, bl6, bl5);
        filePermissions.setPermisions(file, this.fHelper.getLogIDString());
    }

    private void copyDirectoryFrom(boolean bl, File file, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPAcknowledgeException, JSchSCPCommandException {
        File file2;
        String string;
        byte[] byArray = this.receiveBytes(5, inputStream);
        String string2 = this.receiveLine(inputStream);
        String string3 = string2.substring(0, string2.indexOf(" "));
        try {
            long l = Long.parseLong(string3);
            if (l != 0L) {
                throw new JSchSCPCommandException(this.fHelper.getLogIDString() + ": fileLength for a dir should be 0 but is " + l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSchSCPCommandException(this.fHelper.getLogIDString() + ": could not parse '" + string2 + "'", (Throwable)numberFormatException);
        }
        String string4 = string2.substring(string2.indexOf(" ") + 1, string2.length());
        if (bl) {
            string4 = this.getLocalFile().getName();
        }
        if (!this.fCommand.isExcluded(string = this.createRemotePath(file2 = bl && this.getLocalFile().getAbsoluteFile().equals(file) ? file : new File(file, string4)))) {
            boolean bl2 = file2.exists() && file2.isDirectory();
            boolean bl3 = file2.mkdir();
            if (!bl2 && !bl3) {
                throw new JSchSCPCommandException(this.fHelper.getLogIDString() + ": " + file2 + " not present after mkdir()");
            }
            Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": created directory " + file2);
            this.setFilePermissions(byArray, file2);
        }
        this.sendAck(0, outputStream);
        this.copyFilesFrom(false, file2, inputStream, outputStream);
    }

    private void copyFileFrom(boolean bl, File file, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPAcknowledgeException, JSchSCPCommandException {
        long l;
        byte[] byArray = this.receiveBytes(5, inputStream);
        String string = this.receiveLine(inputStream);
        String string2 = string.substring(0, string.indexOf(" "));
        try {
            l = Long.parseLong(string2);
            if (l < 0L) {
                throw new JSchSCPCommandException(this.fHelper.getLogIDString() + ": fileLength for a file should be >= 0 but is " + l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSchSCPCommandException(this.fHelper.getLogIDString() + ": could not parse '" + string + "'", (Throwable)numberFormatException);
        }
        String string3 = string.substring(string.indexOf(" ") + 1, string.length());
        if (bl && !this.getLocalFile().isDirectory()) {
            string3 = this.getLocalFile().getName();
        }
        this.sendAck(0, outputStream);
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + " about to receive : size=" + l + ", name=" + string3);
        File file2 = new File(file, string3);
        String string4 = this.createRemotePath(file2);
        if (!this.fCommand.isExcluded(string4)) {
            this.receiveFile(file2, l, inputStream, outputStream);
            this.setFilePermissions(byArray, file2);
        } else {
            this.drainBitsOfFile(l, inputStream, outputStream);
        }
        this.checkAck(inputStream);
        this.sendAck(0, outputStream);
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + " received : file size=" + l + ", file=" + string3);
    }

    private String createRemotePath(File file) {
        URI uRI;
        URI uRI2 = this.fCommand.getLocalFile().toURI();
        URI uRI3 = uRI2.relativize(uRI = file.toURI());
        String string = uRI3.getPath();
        if ("".equals(string)) {
            return this.fCommand.getRemoteFile();
        }
        return this.fCommand.getRemoteFile() + "/" + string;
    }

    private int checkAck(InputStream inputStream) throws IOException, JSchSCPAcknowledgeException {
        int n;
        int n2 = inputStream.read();
        if (n2 == 0 || n2 == -1) {
            return n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            n = inputStream.read();
            stringBuilder.append((char)n);
        } while (n != 10 && n != -1);
        if (n2 == 1) {
            throw new JSchSCPAcknowledgeException(stringBuilder.toString(), stringBuilder.toString(), n2);
        }
        if (n2 == 2) {
            throw new JSchSCPAcknowledgeException(stringBuilder.toString(), stringBuilder.toString(), n2);
        }
        throw new JSchSCPAcknowledgeException("Expected ssh ack code:" + n2 + " " + stringBuilder.toString(), stringBuilder.toString(), n2);
    }

    private void sendAck(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n);
        outputStream.flush();
    }

    private byte[] receiveBytes(int n, InputStream inputStream) throws IOException, JSchSCPCommandException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray, 0, n);
        if (n2 != n) {
            throw new JSchSCPCommandException(this.fHelper.getLogIDString() + ": expected to read:" + n + " actually read: " + n2);
        }
        return byArray;
    }

    private String receiveLine(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ((n = inputStream.read()) == -1 || n == 10) continue;
            stringBuilder.append((char)n);
        } while (n != -1 && n != 10);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveFile(File file, long l, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPCommandException {
        OutputStream outputStream2 = null;
        try {
            boolean bl;
            int n;
            outputStream2 = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[16384];
            long l2 = 0L;
            int n2 = byArray.length;
            do {
                if ((long)n2 >= l - l2) {
                    n2 = (int)(l - l2);
                }
                if ((n = inputStream.read(byArray, 0, n2)) != n2) {
                    Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": expected to read " + n2 + " for " + file + " but received " + n);
                }
                if (n > 0) {
                    outputStream2.write(byArray, 0, n);
                } else {
                    if (n == -1) {
                        throw new EOFException(this.fHelper.getLogIDString() + ": expected to receive " + l + " for " + file + " but only received " + l2);
                    }
                    if (n2 > 0 && n == 0) {
                        throw new IllegalStateException(this.fHelper.getLogIDString() + ": received unexpected value from read() " + n + " while receiving " + file);
                    }
                }
                bl = this.checkCancelled(outputStream);
            } while ((l2 += (long)n) < l && !bl);
            if (bl) {
                Logger.LOGGER.warning(this.fHelper.getLogIDString() + ": cancelled after receiving " + l2 + " bytes of " + file);
            }
        }
        finally {
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
    }

    private void drainBitsOfFile(long l, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPCommandException {
        boolean bl;
        int n;
        byte[] byArray = new byte[16384];
        long l2 = 0L;
        int n2 = byArray.length;
        do {
            if ((long)n2 > l - l2) {
                n2 = (int)(l - l2);
            }
            if ((n = inputStream.read(byArray, 0, n2)) != n2) {
                throw new JSchSCPCommandException(this.fHelper.getLogIDString() + ": expected to read " + n2 + " but got " + n);
            }
            bl = this.checkCancelled(outputStream);
        } while ((l2 += (long)n) < l && !bl);
        if (bl) {
            Logger.LOGGER.warning(this.fHelper.getLogIDString() + ": cancelled after receiving " + l2 + " bytes");
        }
    }
}

