/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.jobmanager.JobManagerNodeInfo;
import com.mathworks.toolbox.distcomp.jobmanager.RegistrationAuthority;
import com.mathworks.toolbox.distcomp.service.NodeInfo;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import com.mathworks.toolbox.distcomp.worker.RegistrationInfo;
import com.mathworks.toolbox.distcomp.worker.WorkerNodeInfo;

public class NodeInfoAnalyzer {
    public static final boolean JUST_STARTED = true;
    public static final boolean ALREADY_RUNNING = false;

    public static void addWarningsAndNotes(WarningAndNoteInfo warningAndNoteInfo, String string, JobManagerNodeInfo[] jobManagerNodeInfoArray, WorkerNodeInfo[] workerNodeInfoArray, boolean bl, boolean bl2) {
        int n;
        if (jobManagerNodeInfoArray != null) {
            for (n = 0; n < jobManagerNodeInfoArray.length; ++n) {
                NodeInfoAnalyzer.addJobManagerWarningsAndNotes(warningAndNoteInfo, jobManagerNodeInfoArray[n], bl2);
            }
        }
        if (workerNodeInfoArray != null) {
            for (n = 0; n < workerNodeInfoArray.length; ++n) {
                NodeInfoAnalyzer.addWorkerWarningsAndNotes(warningAndNoteInfo, workerNodeInfoArray[n], bl2);
            }
        }
        NodeInfoAnalyzer.getNothingRunningNote(warningAndNoteInfo, string, jobManagerNodeInfoArray, workerNodeInfoArray, bl);
        NodeInfoAnalyzer.addNotReachableWarnings(warningAndNoteInfo, string, jobManagerNodeInfoArray, workerNodeInfoArray);
    }

    public static void addWarningsAndNotes(WarningAndNoteInfo warningAndNoteInfo, NodeInfo nodeInfo, boolean bl) {
        if (nodeInfo instanceof JobManagerNodeInfo) {
            NodeInfoAnalyzer.addJobManagerWarningsAndNotes(warningAndNoteInfo, (JobManagerNodeInfo)nodeInfo, bl);
        } else if (nodeInfo instanceof WorkerNodeInfo) {
            NodeInfoAnalyzer.addWorkerWarningsAndNotes(warningAndNoteInfo, (WorkerNodeInfo)nodeInfo, bl);
        }
    }

    private static void addJobManagerWarningsAndNotes(WarningAndNoteInfo warningAndNoteInfo, JobManagerNodeInfo jobManagerNodeInfo, boolean bl) {
        String[] stringArray;
        if (jobManagerNodeInfo == null) {
            return;
        }
        if (!(bl || (stringArray = jobManagerNodeInfo.getWorkerHostnames()) != null && stringArray.length != 0)) {
            warningAndNoteInfo.addWarning(NodeInfoAnalyzer.msgJMNoWorkers(jobManagerNodeInfo.getName(), jobManagerNodeInfo.getHostName()));
        }
        if (NodeInfoAnalyzer.isLookupMissing(jobManagerNodeInfo)) {
            warningAndNoteInfo.addWarning(NodeInfoAnalyzer.msgJobManagerNoLookup(jobManagerNodeInfo.getName(), jobManagerNodeInfo.getHostName()));
        }
    }

    private static void addWorkerWarningsAndNotes(WarningAndNoteInfo warningAndNoteInfo, WorkerNodeInfo workerNodeInfo, boolean bl) {
        String string;
        Object object;
        if (workerNodeInfo == null) {
            return;
        }
        if (!workerNodeInfo.isConnectedToJM()) {
            object = workerNodeInfo.getJobManagerHostName();
            string = workerNodeInfo.getJobManagerNameInConfiguration();
            if (object == null || ((String)object).length() == 0) {
                if (NodeInfoAnalyzer.isLookupMissing(workerNodeInfo)) {
                    warningAndNoteInfo.addWarning(NodeInfoAnalyzer.msgWorkerCannotFindJMNoLookup(workerNodeInfo.getName(), workerNodeInfo.getHostName(), string));
                } else {
                    warningAndNoteInfo.addWarning(NodeInfoAnalyzer.msgWorkerCannotFindJM(workerNodeInfo.getName(), workerNodeInfo.getHostName(), string));
                }
            } else if (NodeInfoAnalyzer.isLookupMissing(workerNodeInfo)) {
                warningAndNoteInfo.addWarning(NodeInfoAnalyzer.msgWorkerLostJMConnectionNoLookup(workerNodeInfo.getName(), workerNodeInfo.getHostName(), string, (String)object));
            } else {
                warningAndNoteInfo.addWarning(NodeInfoAnalyzer.msgWorkerLostJMConnection(workerNodeInfo.getName(), workerNodeInfo.getHostName(), string, (String)object));
            }
        }
        if (NodeInfoAnalyzer.isLookupMissing(workerNodeInfo) && workerNodeInfo.isConnectedToJM()) {
            warningAndNoteInfo.addWarning(NodeInfoAnalyzer.msgWorkerNoLookup(workerNodeInfo.getName(), workerNodeInfo.getHostName()));
        }
        if ((object = workerNodeInfo.getRegistrationInfo()) == null) {
            warningAndNoteInfo.addWarning("The worker has not registered with the jobmanager yet.");
        } else if (!((RegistrationInfo)object).isRegistered()) {
            string = "The worker failed to register with the jobmanager.";
            RegistrationAuthority.RegistrationFailedException registrationFailedException = ((RegistrationInfo)object).getException();
            if (registrationFailedException != null) {
                string = string + " Reason: " + registrationFailedException.getMessage();
            }
            warningAndNoteInfo.addWarning(string);
        }
    }

    private static boolean isLookupMissing(NodeInfo nodeInfo) {
        String[] stringArray = nodeInfo.getLookupURLs();
        return stringArray == null || stringArray.length == 0;
    }

    private static void getNothingRunningNote(WarningAndNoteInfo warningAndNoteInfo, String string, JobManagerNodeInfo[] jobManagerNodeInfoArray, WorkerNodeInfo[] workerNodeInfoArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        if (jobManagerNodeInfoArray != null) {
            n = jobManagerNodeInfoArray.length;
        }
        if (workerNodeInfoArray != null) {
            n2 = workerNodeInfoArray.length;
        }
        if (n == 0 && n2 == 0 && !bl) {
            warningAndNoteInfo.addNote(NodeInfoAnalyzer.msgNothingRunningInMDCE(string));
        }
    }

    private static void addNotReachableWarnings(WarningAndNoteInfo warningAndNoteInfo, String string, JobManagerNodeInfo[] jobManagerNodeInfoArray, WorkerNodeInfo[] workerNodeInfoArray) {
        int n = NodeInfoAnalyzer.getNumNullElements(jobManagerNodeInfoArray);
        int n2 = NodeInfoAnalyzer.getNumNullElements(workerNodeInfoArray);
        if (n > 0 && n2 > 0) {
            warningAndNoteInfo.addWarning(NodeInfoAnalyzer.msgJMsAndWorkersNotReachable(string, n, n2));
            return;
        }
        if (n > 0) {
            warningAndNoteInfo.addWarning(NodeInfoAnalyzer.msgJMsNotReachable(string, n));
        }
        if (n2 > 0) {
            warningAndNoteInfo.addWarning(NodeInfoAnalyzer.msgWorkersNotReachable(string, n2));
        }
    }

    private static int getNumNullElements(NodeInfo[] nodeInfoArray) {
        int n = 0;
        if (nodeInfoArray != null) {
            for (int i = 0; i < nodeInfoArray.length; ++i) {
                if (nodeInfoArray[i] != null) continue;
                ++n;
            }
        }
        return n;
    }

    private static String msgTroubleshootingSection(int n) {
        return n + ") If the help above does not solve the problem, refer to the " + "troubleshooting\n" + "section in the MDCE documentation.";
    }

    private static String msgTemporaryOrMissingProcesses() {
        return "This problem might correct itself soon, or it might indicate that not all of\nthe necessary processes are running on your cluster.";
    }

    private static String msgTryAgain(int n, String string) {
        return n + ") If the problem has been resolved, you will not see " + "this warning message\n" + "repeated when you execute the following command:\n" + "    nodestatus -infolevel 2 -remotehost " + string;
    }

    private static String msgVerifyJMAndLookupRunning(int n) {
        return n + ") If the warning persists, use the nodestatus command " + "to verify that the job\n" + "manager and its lookup process are running.  If the " + "processes are not running,\n" + "use the startjobmanager command to start them.\n";
    }

    private static String msgVerifyJMAndLookupRunning(int n, String string) {
        return n + ") If the warning persists, verify that the job manager " + "and its lookup process\n" + "are running by executing:\n" + "   nodestatus -remotehost " + string + "\n" + "If the processes are not running, use the startjobmanager " + "command to start\n" + "them.";
    }

    private static String msgVerifyLookupRunning(int n) {
        return n + ") If the warning persists, use the nodestatus command " + "to verify that the job\n" + "manager lookup process is running.";
    }

    private static String msgWorkerNoLookup(String string, String string2) {
        return "The worker " + string + " on the host " + string2 + "\ncannot contact its job manager lookup process.\n" + NodeInfoAnalyzer.msgTemporaryOrMissingProcesses() + "\n" + NodeInfoAnalyzer.msgTryAgain(1, string2) + "\n" + NodeInfoAnalyzer.msgVerifyJMAndLookupRunning(2) + "\n" + NodeInfoAnalyzer.msgTroubleshootingSection(3);
    }

    private static String msgJobManagerNoLookup(String string, String string2) {
        return "The job manager " + string + " on the host " + string2 + "\ncannot contact its job manager lookup process.\n" + NodeInfoAnalyzer.msgTemporaryOrMissingProcesses() + "\n" + NodeInfoAnalyzer.msgTryAgain(1, string2) + "\n" + NodeInfoAnalyzer.msgVerifyLookupRunning(2) + "\n" + NodeInfoAnalyzer.msgTroubleshootingSection(3);
    }

    private static String msgJMNoWorkers(String string, String string2) {
        return "The job manager " + string + " on the host " + string2 + "\ndoes not have any workers registered with it.  " + "Use the startworker command\nwith the arguments\n" + "   -jobmanager " + string + " -jobmanagerhost " + string2 + "\n" + "to start a worker with this job manager.\n" + "If you expected this job manager to have workers registered " + "with it, run the\nnodestatus command on the worker nodes to " + "investigate the cause of the failure.";
    }

    private static String msgWorkerCannotFindJM(String string, String string2, String string3) {
        return "The worker " + string + " on the host " + string2 + "\ncannot find the job manager " + string3 + ".\n" + NodeInfoAnalyzer.msgTemporaryOrMissingProcesses() + "\n" + NodeInfoAnalyzer.msgTryAgain(1, string2) + "\n" + NodeInfoAnalyzer.msgVerifyJMAndLookupRunning(2) + "\n" + NodeInfoAnalyzer.msgTroubleshootingSection(3);
    }

    private static String msgWorkerCannotFindJMNoLookup(String string, String string2, String string3) {
        return "The worker " + string + " on the host " + string2 + "\ncan find neither the job manager " + string3 + ",\nnor the job manager lookup process.\n" + NodeInfoAnalyzer.msgTemporaryOrMissingProcesses() + "\n" + NodeInfoAnalyzer.msgTryAgain(1, string2) + "\n" + NodeInfoAnalyzer.msgVerifyJMAndLookupRunning(2) + "\n" + NodeInfoAnalyzer.msgTroubleshootingSection(3);
    }

    private static String msgWorkerLostJMConnection(String string, String string2, String string3, String string4) {
        return "The worker " + string + " on the host " + string2 + "\nlost its connection with the job manager " + string3 + " on the host\n" + string4 + ".\n" + NodeInfoAnalyzer.msgTryAgain(1, string2) + "\n" + NodeInfoAnalyzer.msgVerifyJMAndLookupRunning(2, string4) + "\n" + NodeInfoAnalyzer.msgTroubleshootingSection(3);
    }

    private static String msgWorkerLostJMConnectionNoLookup(String string, String string2, String string3, String string4) {
        return "The worker " + string + " on the host " + string2 + "\ncannot find its job manager lookup process, and lost its " + "connection with\n" + "the job manager " + string3 + " on the host " + string4 + ".\n" + NodeInfoAnalyzer.msgTemporaryOrMissingProcesses() + "\n" + NodeInfoAnalyzer.msgTryAgain(1, string2) + "\n" + NodeInfoAnalyzer.msgVerifyJMAndLookupRunning(2, string4) + "\n" + NodeInfoAnalyzer.msgTroubleshootingSection(3);
    }

    private static String msgNothingRunningInMDCE(String string) {
        return "The mdce service on " + string + " is not controlling any job managers\n" + "or workers.  To start a job manager or a worker, use " + "the startjobmanager\n" + "or startworker command.";
    }

    private static String msgJMsAndWorkersNotReachable(String string, int n, int n2) {
        return "Could not retrieve status information for " + n + " job manager(s) and " + n2 + "\n" + "worker(s).  Most likely, the processes are still initializing " + "and cannot\n" + "be reached.\n" + NodeInfoAnalyzer.msgTryAgain(1, string) + "\n2) If the problem persists, you can use the stopjobmanager " + "command to stop\n" + "the job manager(s) and stopworker to stop the worker(s).";
    }

    private static String msgJMsNotReachable(String string, int n) {
        return "Could not retrieve status information for " + n + " job manager(s).\n" + "Most likely, the processes are still initializing and " + "cannot be reached.\n" + NodeInfoAnalyzer.msgTryAgain(1, string) + "\n2) If the problem persists, you can use the stopjobmanager " + "command to stop\n" + "the job manager(s).";
    }

    private static String msgWorkersNotReachable(String string, int n) {
        return "Could not retrieve status information for " + n + " worker(s).\n" + "Most likely, the processes are still initializing and " + "cannot be reached.\n" + NodeInfoAnalyzer.msgTryAgain(1, string) + "\n2) If the problem persists, you can use the stopworker " + "command to stop\n" + "the worker(s).\n";
    }
}

