/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.util.LocalNetworkInfo;
import com.mathworks.toolbox.distcomp.util.NetworkConfigException;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NodeLocationMessage {
    public static String clientLocationMessage() {
        String string;
        String[] stringArray;
        String string2;
        String string3 = null;
        try {
            string3 = LocalNetworkInfo.findHostName();
            string2 = "The hostname used by the Parallel Computing Toolbox on this computer is: " + string3 + "\n";
        }
        catch (NetworkConfigException networkConfigException) {
            string2 = "The hostname of this computer is unknown\n";
        }
        if (string3 != null) {
            try {
                stringArray = InetAddress.getByName(string3).getCanonicalHostName();
                string = "which resolves to the fully qualified hostname: " + (String)stringArray + "\n";
            }
            catch (UnknownHostException unknownHostException) {
                string = "The fully qualified hostname of this computer is unknown\n";
            }
        } else {
            string = "";
        }
        String string4 = (stringArray = LocalNetworkInfo.findAllHostAddresses()).length > 0 ? "The IP addresses of this computer are: " + NodeLocationMessage.createAddressListString(stringArray) : "The IP addresses of this computer are unknown";
        return string2 + string + string4;
    }

    public static String jobManagerLocationMessage(JobManagerLocal jobManagerLocal) {
        String string;
        String string2;
        String string3 = "The MJS name is: " + jobManagerLocal.getName() + "\n";
        String string4 = "The MJS hostname is: " + jobManagerLocal.getHostName() + "\n";
        try {
            string2 = InetAddress.getByName(jobManagerLocal.getHostName()).getCanonicalHostName();
            string = "which resolves to the fully qualified hostname: " + string2 + "\n";
        }
        catch (UnknownHostException unknownHostException) {
            string = "The fully qualified hostname of this MJS is unknown\n";
        }
        string2 = "The IP addresses of this MJS are: " + NodeLocationMessage.createAddressListString(jobManagerLocal.getAllHostAddresses());
        return string3 + string4 + string + string2;
    }

    public static String workerLocationMessage(WorkerProxy workerProxy) {
        String string;
        String string2;
        String string3 = "The worker name is: " + workerProxy.getName() + "\n";
        String string4 = "The hostname of the worker computer is: " + workerProxy.getHostName() + "\n";
        try {
            string2 = InetAddress.getByName(workerProxy.getHostName()).getCanonicalHostName();
            string = "which resolves to the fully qualified hostname: " + string2 + "\n";
        }
        catch (UnknownHostException unknownHostException) {
            string = "The fully qualified hostname of the worker computer is unknown\n";
        }
        string2 = "The IP addresses of the worker computer are: " + NodeLocationMessage.createAddressListString(workerProxy.getAllHostAddresses());
        return string3 + string4 + string + string2;
    }

    private static String createAddressListString(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            string = NodeLocationMessage.addCommaOrPeriod(string, stringArray, i);
        }
        return string;
    }

    private static String addCommaOrPeriod(String string, String[] stringArray, int n) {
        if (n != stringArray.length - 1) {
            string = string + ", ";
        }
        return string;
    }
}

